/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.IPLSerialNumbersWithError;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IPLFulfillmentError
extends AbstractSchema {
    public static final Integer BLOCKED_BY_TRADE_COMPLIANCE = 0;
    public static final Integer COMPANY_INFO_REQUIRED = 1;
    public static final Integer INACTIVE_SERIAL_NUMBER = 2;
    public static final Integer INPUT_VALIDATION_ERROR = 3;
    public static final Integer REG_COUNT_EXCEEDED = 4;
    public static final Integer SERIAL_NUMBER_IS_NON_IPL = 5;
    public static final Integer SERIAL_NUMBER_NOT_RECOGNIZED = 6;
    public static final Integer SERVER_INTERNAL_ERROR = 7;
    public static final Integer TECHNICAL_CONTACT_INFO_REQUIRED = 8;
    public static final Integer UNKNOWN = 9;
    public static final Integer WRONG_PRODUCT_ID = 10;
    public static final Integer IPL_SPECIFIC_SERVER_INTERNAL_ERROR = 11;
    public static final Integer TEMPORARY_SERVER_INTERNAL_ERROR = 12;
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private String errorMessageToken;
    private Integer reason;

    public IPLFulfillmentError() {
        this.nameSpace = "rpc";
        this.children.put(262261, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "IPLFulfillmentError";
    }

    public String getOptErrorCode() {
        return this.errorCode;
    }

    public void setOptErrorCode(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.errorCode = value;
    }

    public String getOptErrorMessageToken() {
        return this.errorMessageToken;
    }

    public void setOptErrorMessageToken(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.errorMessageToken = value;
    }

    public Integer getOptReason() {
        return this.reason;
    }

    public String getOptReasonValue() throws ValidationException {
        if (this.reason == null) {
            return null;
        }
        String s = null;
        switch (this.reason) {
            case 0: {
                s = "BLOCKED_BY_TRADE_COMPLIANCE";
                break;
            }
            case 1: {
                s = "COMPANY_INFO_REQUIRED";
                break;
            }
            case 2: {
                s = "INACTIVE_SERIAL_NUMBER";
                break;
            }
            case 3: {
                s = "INPUT_VALIDATION_ERROR";
                break;
            }
            case 4: {
                s = "REG_COUNT_EXCEEDED";
                break;
            }
            case 5: {
                s = "SERIAL_NUMBER_IS_NON_IPL";
                break;
            }
            case 6: {
                s = "SERIAL_NUMBER_NOT_RECOGNIZED";
                break;
            }
            case 7: {
                s = "SERVER_INTERNAL_ERROR";
                break;
            }
            case 8: {
                s = "TECHNICAL_CONTACT_INFO_REQUIRED";
                break;
            }
            case 9: {
                s = "UNKNOWN";
                break;
            }
            case 10: {
                s = "WRONG_PRODUCT_ID";
                break;
            }
            case 11: {
                s = "IPL_SPECIFIC_SERVER_INTERNAL_ERROR";
                break;
            }
            case 12: {
                s = "TEMPORARY_SERVER_INTERNAL_ERROR";
                break;
            }
            default: {
                throw new ValidationException("IPLFulfillmentError/Reason: invalid attribute value:" + this.reason + "!");
            }
        }
        return s;
    }

    public void setOptReason(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.reason = value;
    }

    public void setOptReasonValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.reason = null;
            return;
        }
        if ("BLOCKED_BY_TRADE_COMPLIANCE".equals(value)) {
            this.reason = BLOCKED_BY_TRADE_COMPLIANCE;
        } else if ("COMPANY_INFO_REQUIRED".equals(value)) {
            this.reason = COMPANY_INFO_REQUIRED;
        } else if ("INACTIVE_SERIAL_NUMBER".equals(value)) {
            this.reason = INACTIVE_SERIAL_NUMBER;
        } else if ("INPUT_VALIDATION_ERROR".equals(value)) {
            this.reason = INPUT_VALIDATION_ERROR;
        } else if ("REG_COUNT_EXCEEDED".equals(value)) {
            this.reason = REG_COUNT_EXCEEDED;
        } else if ("SERIAL_NUMBER_IS_NON_IPL".equals(value)) {
            this.reason = SERIAL_NUMBER_IS_NON_IPL;
        } else if ("SERIAL_NUMBER_NOT_RECOGNIZED".equals(value)) {
            this.reason = SERIAL_NUMBER_NOT_RECOGNIZED;
        } else if ("SERVER_INTERNAL_ERROR".equals(value)) {
            this.reason = SERVER_INTERNAL_ERROR;
        } else if ("TECHNICAL_CONTACT_INFO_REQUIRED".equals(value)) {
            this.reason = TECHNICAL_CONTACT_INFO_REQUIRED;
        } else if ("UNKNOWN".equals(value)) {
            this.reason = UNKNOWN;
        } else if ("WRONG_PRODUCT_ID".equals(value)) {
            this.reason = WRONG_PRODUCT_ID;
        } else if ("IPL_SPECIFIC_SERVER_INTERNAL_ERROR".equals(value)) {
            this.reason = IPL_SPECIFIC_SERVER_INTERNAL_ERROR;
        } else if ("TEMPORARY_SERVER_INTERNAL_ERROR".equals(value)) {
            this.reason = TEMPORARY_SERVER_INTERNAL_ERROR;
        } else {
            throw new ValidationException("IPLFulfillmentError/Reason: invalid attribute value:" + value + "!");
        }
    }

    public void addIPLSerialNumbersWithError(IPLSerialNumbersWithError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIPLSerialNumbersWithError(int index, IPLSerialNumbersWithError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IPLSerialNumbersWithError> getIPLSerialNumbersWithError() {
        Vector<IPLSerialNumbersWithError> v = new Vector<IPLSerialNumbersWithError>();
        for (Transportable child : (ChildGroup)this.children.get(262261)) {
            v.add((IPLSerialNumbersWithError)child);
        }
        return v;
    }

    public int getIPLSerialNumbersWithErrorCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262261);
        return childGroup.size();
    }

    public IPLSerialNumbersWithError getIPLSerialNumbersWithError(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262261);
        return (IPLSerialNumbersWithError)childGroup.get(index);
    }

    public void setIPLSerialNumbersWithError(int index, IPLSerialNumbersWithError value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIPLSerialNumbersWithError(IPLSerialNumbersWithError value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 262258;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof IPLSerialNumbersWithError) {
            try {
                this.addIPLSerialNumbersWithError((IPLSerialNumbersWithError)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ErrorCode");
            if (value != null) {
                this.errorCode = value;
            }
            if ((value = attris.getValue("ErrorMessageToken")) != null) {
                this.errorMessageToken = value;
            }
            if ((value = attris.getValue("Reason")) != null) {
                this.setOptReasonValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getIPLSerialNumbersWithErrorCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getIPLSerialNumbersWithError(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"IPLFulfillmentError".equals(element.getNodeName())) {
            throw new ValidationException("IPLFulfillmentError: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ErrorCode");
        if (value != null) {
            this.errorCode = value;
        }
        if ((value = XMLHelper.getAttribute(element, "ErrorMessageToken")) != null) {
            this.errorMessageToken = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Reason")) != null) {
            this.setOptReasonValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "IPLSerialNumbersWithError");
        for (int i = 0; i < v.size(); ++i) {
            IPLSerialNumbersWithError iPLSerialNumbersWithErrorObj = new IPLSerialNumbersWithError();
            iPLSerialNumbersWithErrorObj.importFromElement(v.get(i));
            this.addIPLSerialNumbersWithError(iPLSerialNumbersWithErrorObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("IPLFulfillmentError");
        if (this.errorCode != null) {
            element.setAttribute("ErrorCode", this.errorCode);
        }
        if (this.errorMessageToken != null) {
            element.setAttribute("ErrorMessageToken", this.errorMessageToken);
        }
        if (this.reason != null) {
            element.setAttribute("Reason", this.getOptReasonValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IPLFulfillmentError ");
            if (this.errorCode != null) {
                strAttrs.append("ErrorCode=\"").append(AbstractSchema.checkXMLContent(this.errorCode)).append("\" ");
            }
            if (this.errorMessageToken != null) {
                strAttrs.append("ErrorMessageToken=\"").append(AbstractSchema.checkXMLContent(this.errorMessageToken)).append("\" ");
            }
            if (this.reason != null) {
                strAttrs.append("Reason=\"").append(this.getOptReasonValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IPLFulfillmentError>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

