/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GupItem
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String address;
    private Integer port;
    private String subnetMask;

    public GupItem() {
        this.nameSpace = "rpc";
    }

    @Override
    public String getObjectTypeName() {
        return "GupItem";
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.address = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public String getOptSubnetMask() {
        return this.subnetMask;
    }

    public void setOptSubnetMask(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.subnetMask = value;
    }

    @Override
    public int getObjectType() {
        return 262249;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.address == null) {
            throw new ValidationException("GupItem/Address: attribute is required!");
        }
        if (this.port == null) {
            throw new ValidationException("GupItem/Port: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Address");
            if (value == null) {
                throw new ValidationException("GupItem/Address: attribute is required!");
            }
            this.address = value;
            value = attris.getValue("Port");
            if (value == null) {
                throw new ValidationException("GupItem/Port: attribute is required!");
            }
            try {
                this.port = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("GupItem/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("GupItem/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("SubnetMask");
            if (value != null) {
                this.subnetMask = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"GupItem".equals(element.getNodeName())) {
            throw new ValidationException("GupItem: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Address");
        if (value == null) {
            throw new ValidationException("GupItem/Address: attribute is required!");
        }
        this.address = value;
        value = XMLHelper.getAttribute(element, "Port");
        if (value == null) {
            throw new ValidationException("GupItem/Port: attribute is required!");
        }
        try {
            this.port = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("GupItem/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("GupItem/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "SubnetMask");
        if (value != null) {
            this.subnetMask = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("GupItem");
        if (this.address != null) {
            element.setAttribute("Address", this.address);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.subnetMask != null) {
            element.setAttribute("SubnetMask", this.subnetMask);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<GupItem ");
            if (this.address != null) {
                strAttrs.append("Address=\"").append(AbstractSchema.checkXMLContent(this.address)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.subnetMask != null) {
                strAttrs.append("SubnetMask=\"").append(AbstractSchema.checkXMLContent(this.subnetMask)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</GupItem>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

