/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.DomainComputer;
import com.sygate.scm.common.configobject.rpc.DomainUser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Domain
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String name;
    private String dnsName;
    private String type;

    public Domain() {
        this.nameSpace = "rpc";
        this.children.put(262198, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(262200, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "Domain";
    }

    public String getOptName() {
        return this.name;
    }

    public void setOptName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getOptDnsName() {
        return this.dnsName;
    }

    public void setOptDnsName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.dnsName = value;
    }

    public String getOptType() {
        return this.type;
    }

    public void setOptType(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.type = value;
    }

    public void addDomainUser(DomainUser value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDomainUser(int index, DomainUser value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DomainUser> getDomainUser() {
        Vector<DomainUser> v = new Vector<DomainUser>();
        for (Transportable child : (ChildGroup)this.children.get(262198)) {
            v.add((DomainUser)child);
        }
        return v;
    }

    public int getDomainUserCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262198);
        return childGroup.size();
    }

    public DomainUser getDomainUser(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262198);
        return (DomainUser)childGroup.get(index);
    }

    public void setDomainUser(int index, DomainUser value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDomainUser(DomainUser value) {
        this.removeChild(value);
    }

    public void addDomainComputer(DomainComputer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDomainComputer(int index, DomainComputer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DomainComputer> getDomainComputer() {
        Vector<DomainComputer> v = new Vector<DomainComputer>();
        for (Transportable child : (ChildGroup)this.children.get(262200)) {
            v.add((DomainComputer)child);
        }
        return v;
    }

    public int getDomainComputerCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262200);
        return childGroup.size();
    }

    public DomainComputer getDomainComputer(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(262200);
        return (DomainComputer)childGroup.get(index);
    }

    public void setDomainComputer(int index, DomainComputer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDomainComputer(DomainComputer value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 262201;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof DomainUser) {
            try {
                this.addDomainUser((DomainUser)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof DomainComputer) {
            try {
                this.addDomainComputer((DomainComputer)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value != null) {
                this.name = value;
            }
            if ((value = attris.getValue("DnsName")) != null) {
                this.dnsName = value;
            }
            if ((value = attris.getValue("Type")) != null) {
                this.type = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getDomainUserCount();
        for (i = 0; i < objCnt; ++i) {
            this.getDomainUser(i).setReadonly();
        }
        objCnt = this.getDomainComputerCount();
        for (i = 0; i < objCnt; ++i) {
            this.getDomainComputer(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"Domain".equals(element.getNodeName())) {
            throw new ValidationException("Domain: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value != null) {
            this.name = value;
        }
        if ((value = XMLHelper.getAttribute(element, "DnsName")) != null) {
            this.dnsName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Type")) != null) {
            this.type = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DomainUser");
        for (i = 0; i < v.size(); ++i) {
            DomainUser domainUserObj = new DomainUser();
            domainUserObj.importFromElement(v.get(i));
            this.addDomainUser(domainUserObj);
        }
        v = XMLHelper.getChildElementByName(element, "DomainComputer");
        for (i = 0; i < v.size(); ++i) {
            DomainComputer domainComputerObj = new DomainComputer();
            domainComputerObj.importFromElement(v.get(i));
            this.addDomainComputer(domainComputerObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Domain");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.dnsName != null) {
            element.setAttribute("DnsName", this.dnsName);
        }
        if (this.type != null) {
            element.setAttribute("Type", this.type);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Domain ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.dnsName != null) {
                strAttrs.append("DnsName=\"").append(AbstractSchema.checkXMLContent(this.dnsName)).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(AbstractSchema.checkXMLContent(this.type)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Domain>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

