/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.rpc;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.SystemInfo;
import com.sygate.scm.common.configobject.rpc.Throughput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ClientTransportInfo
extends AbstractSchema {
    public static final Integer STOPPED = 0;
    public static final Integer STARTING = 1;
    public static final Integer READY = 2;
    private static final long serialVersionUID = 1L;
    private Integer status;
    private Long startTime;
    private Long errorCode;

    public ClientTransportInfo() {
        this.nameSpace = "rpc";
        this.children.put(262205, new ChildGroup(0, 1));
        this.children.put(262206, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "ClientTransportInfo";
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusValue() throws ValidationException {
        if (this.status == null) {
            return null;
        }
        String s = null;
        switch (this.status) {
            case 0: {
                s = "STOPPED";
                break;
            }
            case 1: {
                s = "STARTING";
                break;
            }
            case 2: {
                s = "READY";
                break;
            }
            default: {
                throw new ValidationException("ClientTransportInfo/Status: invalid attribute value:" + this.status + "!");
            }
        }
        return s;
    }

    public void setStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.status = value;
    }

    public void setStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("STOPPED".equals(value)) {
            this.status = STOPPED;
        } else if ("STARTING".equals(value)) {
            this.status = STARTING;
        } else if ("READY".equals(value)) {
            this.status = READY;
        } else {
            throw new ValidationException("ClientTransportInfo/Status: invalid attribute value:" + value + "!");
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.startTime = value;
    }

    public Long getOptErrorCode() {
        return this.errorCode;
    }

    public void setOptErrorCode(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.errorCode = value;
    }

    public SystemInfo getOptSystemInfo() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262205);
        if (childGroup.size() > 0) {
            return (SystemInfo)childGroup.get(0);
        }
        return null;
    }

    public void setOptSystemInfo(SystemInfo value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SystemInfo obj = this.getOptSystemInfo();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Throughput getOptThroughput() {
        ChildGroup childGroup = (ChildGroup)this.children.get(262206);
        if (childGroup.size() > 0) {
            return (Throughput)childGroup.get(0);
        }
        return null;
    }

    public void setOptThroughput(Throughput value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Throughput obj = this.getOptThroughput();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 262204;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.status == null) {
            throw new ValidationException("ClientTransportInfo/Status: attribute is required!");
        }
        if (this.startTime == null) {
            throw new ValidationException("ClientTransportInfo/StartTime: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof SystemInfo) {
            try {
                this.setOptSystemInfo((SystemInfo)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Throughput) {
            try {
                this.setOptThroughput((Throughput)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block11: {
            try {
                String value = attris.getValue("Status");
                if (value == null) {
                    throw new ValidationException("ClientTransportInfo/Status: attribute is required!");
                }
                this.setStatusValue(value);
                value = attris.getValue("StartTime");
                if (value == null) {
                    throw new ValidationException("ClientTransportInfo/StartTime: attribute is required!");
                }
                try {
                    this.startTime = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ClientTransportInfo/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ClientTransportInfo/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                }
                value = attris.getValue("ErrorCode");
                if (value == null) break block11;
                try {
                    this.errorCode = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ClientTransportInfo/ErrorCode: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ClientTransportInfo/ErrorCode: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptSystemInfo() != null) {
            this.getOptSystemInfo().setReadonly();
        }
        if (this.getOptThroughput() != null) {
            this.getOptThroughput().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"ClientTransportInfo".equals(element.getNodeName())) {
            throw new ValidationException("ClientTransportInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Status");
        if (value == null) {
            throw new ValidationException("ClientTransportInfo/Status: attribute is required!");
        }
        this.setStatusValue(value);
        value = XMLHelper.getAttribute(element, "StartTime");
        if (value == null) {
            throw new ValidationException("ClientTransportInfo/StartTime: attribute is required!");
        }
        try {
            this.startTime = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("ClientTransportInfo/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("ClientTransportInfo/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "ErrorCode");
        if (value != null) {
            try {
                this.errorCode = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ClientTransportInfo/ErrorCode: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((v = XMLHelper.getChildElementByName(element, "SystemInfo")).size() > 0) {
            SystemInfo systemInfoObj = new SystemInfo();
            systemInfoObj.importFromElement(v.get(0));
            this.setOptSystemInfo(systemInfoObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Throughput")).size() > 0) {
            Throughput throughputObj = new Throughput();
            throughputObj.importFromElement(v.get(0));
            this.setOptThroughput(throughputObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ClientTransportInfo");
        if (this.status != null) {
            element.setAttribute("Status", this.getStatusValue());
        }
        if (this.startTime != null) {
            element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.errorCode != null) {
            element.setAttribute("ErrorCode", this.errorCode.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ClientTransportInfo ");
            if (this.status != null) {
                strAttrs.append("Status=\"").append(this.getStatusValue()).append("\" ");
            }
            if (this.startTime != null) {
                strAttrs.append("StartTime=\"").append(this.startTime.toString()).append("\" ");
            }
            if (this.errorCode != null) {
                strAttrs.append("ErrorCode=\"").append(this.errorCode.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ClientTransportInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

