/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.report.TsNumberOfEnforcerClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TsNumberOfEnforcerClients
extends ConfigObject {
    public static final Integer AUTHENTICATED = 0;
    public static final Integer REJECTED = 1;
    public static final Integer DISCONNECTED = 2;
    public static final Integer PASSED = 3;
    public static final Integer FAILED = 4;
    private static final long serialVersionUID = 1L;
    private Integer eventType;
    private Long startTime;
    private Long endTime;
    private Long timeScale;

    public TsNumberOfEnforcerClients() {
        this.nameSpace = "report";
        this.children.put(131168, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "TsNumberOfEnforcerClients";
    }

    public Integer getEventType() {
        return this.eventType;
    }

    public String getEventTypeValue() throws ValidationException {
        if (this.eventType == null) {
            return null;
        }
        String s = null;
        switch (this.eventType) {
            case 0: {
                s = "AUTHENTICATED";
                break;
            }
            case 1: {
                s = "REJECTED";
                break;
            }
            case 2: {
                s = "DISCONNECTED";
                break;
            }
            case 3: {
                s = "PASSED";
                break;
            }
            case 4: {
                s = "FAILED";
                break;
            }
            default: {
                throw new ValidationException("TsNumberOfEnforcerClients/EventType: invalid attribute value:" + this.eventType + "!");
            }
        }
        return s;
    }

    public void setEventType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.eventType = value;
    }

    public void setEventTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("AUTHENTICATED".equals(value)) {
            this.eventType = AUTHENTICATED;
        } else if ("REJECTED".equals(value)) {
            this.eventType = REJECTED;
        } else if ("DISCONNECTED".equals(value)) {
            this.eventType = DISCONNECTED;
        } else if ("PASSED".equals(value)) {
            this.eventType = PASSED;
        } else if ("FAILED".equals(value)) {
            this.eventType = FAILED;
        } else {
            throw new ValidationException("TsNumberOfEnforcerClients/EventType: invalid attribute value:" + value + "!");
        }
    }

    public Long getOptStartTime() {
        return this.startTime;
    }

    public void setOptStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.startTime = value;
    }

    public Long getOptEndTime() {
        return this.endTime;
    }

    public void setOptEndTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.endTime = value;
    }

    public Long getOptTimeScale() {
        return this.timeScale;
    }

    public void setOptTimeScale(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.timeScale = value;
    }

    public void addTsNumberOfEnforcerClient(TsNumberOfEnforcerClient value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addTsNumberOfEnforcerClient(int index, TsNumberOfEnforcerClient value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<TsNumberOfEnforcerClient> getTsNumberOfEnforcerClient() {
        Vector<TsNumberOfEnforcerClient> v = new Vector<TsNumberOfEnforcerClient>();
        for (Transportable child : (ChildGroup)this.children.get(131168)) {
            v.add((TsNumberOfEnforcerClient)child);
        }
        return v;
    }

    public int getTsNumberOfEnforcerClientCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(131168);
        return childGroup.size();
    }

    public TsNumberOfEnforcerClient getTsNumberOfEnforcerClient(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(131168);
        return (TsNumberOfEnforcerClient)childGroup.get(index);
    }

    public void setTsNumberOfEnforcerClient(int index, TsNumberOfEnforcerClient value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeTsNumberOfEnforcerClient(TsNumberOfEnforcerClient value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 131167;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.eventType == null) {
            throw new ValidationException("TsNumberOfEnforcerClients/EventType: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof TsNumberOfEnforcerClient) {
            try {
                this.addTsNumberOfEnforcerClient((TsNumberOfEnforcerClient)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block15: {
            try {
                String value = attris.getValue("EventType");
                if (value == null) {
                    throw new ValidationException("TsNumberOfEnforcerClients/EventType: attribute is required!");
                }
                this.setEventTypeValue(value);
                value = attris.getValue("StartTime");
                if (value != null) {
                    try {
                        this.startTime = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("TsNumberOfEnforcerClients/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("TsNumberOfEnforcerClients/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("EndTime")) != null) {
                    try {
                        this.endTime = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("TsNumberOfEnforcerClients/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("TsNumberOfEnforcerClients/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("TimeScale")) == null) break block15;
                try {
                    this.timeScale = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("TsNumberOfEnforcerClients/TimeScale: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("TsNumberOfEnforcerClients/TimeScale: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getTsNumberOfEnforcerClientCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getTsNumberOfEnforcerClient(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"TsNumberOfEnforcerClients".equals(element.getNodeName())) {
            throw new ValidationException("TsNumberOfEnforcerClients: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "EventType");
        if (value == null) {
            throw new ValidationException("TsNumberOfEnforcerClients/EventType: attribute is required!");
        }
        this.setEventTypeValue(value);
        value = XMLHelper.getAttribute(element, "StartTime");
        if (value != null) {
            try {
                this.startTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("TsNumberOfEnforcerClients/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "EndTime")) != null) {
            try {
                this.endTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("TsNumberOfEnforcerClients/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "TimeScale")) != null) {
            try {
                this.timeScale = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("TsNumberOfEnforcerClients/TimeScale: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "TsNumberOfEnforcerClient");
        for (int i = 0; i < v.size(); ++i) {
            TsNumberOfEnforcerClient tsNumberOfEnforcerClientObj = new TsNumberOfEnforcerClient();
            tsNumberOfEnforcerClientObj.importFromElement(v.get(i));
            this.addTsNumberOfEnforcerClient(tsNumberOfEnforcerClientObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("TsNumberOfEnforcerClients");
        if (this.eventType != null) {
            element.setAttribute("EventType", this.getEventTypeValue());
        }
        if (this.startTime != null) {
            element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.endTime != null) {
            element.setAttribute("EndTime", this.endTime.toString());
        }
        if (this.timeScale != null) {
            element.setAttribute("TimeScale", this.timeScale.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<TsNumberOfEnforcerClients ");
            if (this.eventType != null) {
                strAttrs.append("EventType=\"").append(this.getEventTypeValue()).append("\" ");
            }
            if (this.startTime != null) {
                strAttrs.append("StartTime=\"").append(this.startTime.toString()).append("\" ");
            }
            if (this.endTime != null) {
                strAttrs.append("EndTime=\"").append(this.endTime.toString()).append("\" ");
            }
            if (this.timeScale != null) {
                strAttrs.append("TimeScale=\"").append(this.timeScale.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</TsNumberOfEnforcerClients>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

