/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.report.TsNumberOfBlockedApp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TsNumberOfBlockedApps
extends ConfigObject {
    public static final Integer ALL = 0;
    public static final Integer GROUP = 1;
    public static final Integer IP = 2;
    public static final Integer OS = 3;
    public static final Integer USER = 4;
    private static final long serialVersionUID = 1L;
    private Integer targetType;
    private String targetValue;
    private Long startTime;
    private Long endTime;
    private Long timeScale;

    public TsNumberOfBlockedApps() {
        this.nameSpace = "report";
        this.children.put(131158, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "TsNumberOfBlockedApps";
    }

    public Integer getTargetType() {
        return this.targetType;
    }

    public String getTargetTypeValue() throws ValidationException {
        if (this.targetType == null) {
            return null;
        }
        String s = null;
        switch (this.targetType) {
            case 0: {
                s = "ALL";
                break;
            }
            case 1: {
                s = "GROUP";
                break;
            }
            case 2: {
                s = "IP";
                break;
            }
            case 3: {
                s = "OS";
                break;
            }
            case 4: {
                s = "USER";
                break;
            }
            default: {
                throw new ValidationException("TsNumberOfBlockedApps/TargetType: invalid attribute value:" + this.targetType + "!");
            }
        }
        return s;
    }

    public void setTargetType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.targetType = value;
    }

    public void setTargetTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ALL".equals(value)) {
            this.targetType = ALL;
        } else if ("GROUP".equals(value)) {
            this.targetType = GROUP;
        } else if ("IP".equals(value)) {
            this.targetType = IP;
        } else if ("OS".equals(value)) {
            this.targetType = OS;
        } else if ("USER".equals(value)) {
            this.targetType = USER;
        } else {
            throw new ValidationException("TsNumberOfBlockedApps/TargetType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptTargetValue() {
        return this.targetValue;
    }

    public void setOptTargetValue(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.targetValue = value;
    }

    public Long getOptStartTime() {
        return this.startTime;
    }

    public void setOptStartTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.startTime = value;
    }

    public Long getOptEndTime() {
        return this.endTime;
    }

    public void setOptEndTime(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.endTime = value;
    }

    public Long getOptTimeScale() {
        return this.timeScale;
    }

    public void setOptTimeScale(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.timeScale = value;
    }

    public void addTsNumberOfBlockedApp(TsNumberOfBlockedApp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addTsNumberOfBlockedApp(int index, TsNumberOfBlockedApp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<TsNumberOfBlockedApp> getTsNumberOfBlockedApp() {
        Vector<TsNumberOfBlockedApp> v = new Vector<TsNumberOfBlockedApp>();
        for (Transportable child : (ChildGroup)this.children.get(131158)) {
            v.add((TsNumberOfBlockedApp)child);
        }
        return v;
    }

    public int getTsNumberOfBlockedAppCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(131158);
        return childGroup.size();
    }

    public TsNumberOfBlockedApp getTsNumberOfBlockedApp(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(131158);
        return (TsNumberOfBlockedApp)childGroup.get(index);
    }

    public void setTsNumberOfBlockedApp(int index, TsNumberOfBlockedApp value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeTsNumberOfBlockedApp(TsNumberOfBlockedApp value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 131157;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.targetType == null) {
            throw new ValidationException("TsNumberOfBlockedApps/TargetType: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof TsNumberOfBlockedApp) {
            try {
                this.addTsNumberOfBlockedApp((TsNumberOfBlockedApp)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block16: {
            try {
                String value = attris.getValue("TargetType");
                if (value == null) {
                    throw new ValidationException("TsNumberOfBlockedApps/TargetType: attribute is required!");
                }
                this.setTargetTypeValue(value);
                value = attris.getValue("TargetValue");
                if (value != null) {
                    this.targetValue = value;
                }
                if ((value = attris.getValue("StartTime")) != null) {
                    try {
                        this.startTime = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("TsNumberOfBlockedApps/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("TsNumberOfBlockedApps/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("EndTime")) != null) {
                    try {
                        this.endTime = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("TsNumberOfBlockedApps/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("TsNumberOfBlockedApps/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("TimeScale")) == null) break block16;
                try {
                    this.timeScale = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("TsNumberOfBlockedApps/TimeScale: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("TsNumberOfBlockedApps/TimeScale: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getTsNumberOfBlockedAppCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getTsNumberOfBlockedApp(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"TsNumberOfBlockedApps".equals(element.getNodeName())) {
            throw new ValidationException("TsNumberOfBlockedApps: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "TargetType");
        if (value == null) {
            throw new ValidationException("TsNumberOfBlockedApps/TargetType: attribute is required!");
        }
        this.setTargetTypeValue(value);
        value = XMLHelper.getAttribute(element, "TargetValue");
        if (value != null) {
            this.targetValue = value;
        }
        if ((value = XMLHelper.getAttribute(element, "StartTime")) != null) {
            try {
                this.startTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("TsNumberOfBlockedApps/StartTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "EndTime")) != null) {
            try {
                this.endTime = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("TsNumberOfBlockedApps/EndTime: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "TimeScale")) != null) {
            try {
                this.timeScale = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("TsNumberOfBlockedApps/TimeScale: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "TsNumberOfBlockedApp");
        for (int i = 0; i < v.size(); ++i) {
            TsNumberOfBlockedApp tsNumberOfBlockedAppObj = new TsNumberOfBlockedApp();
            tsNumberOfBlockedAppObj.importFromElement(v.get(i));
            this.addTsNumberOfBlockedApp(tsNumberOfBlockedAppObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("TsNumberOfBlockedApps");
        if (this.targetType != null) {
            element.setAttribute("TargetType", this.getTargetTypeValue());
        }
        if (this.targetValue != null) {
            element.setAttribute("TargetValue", this.targetValue);
        }
        if (this.startTime != null) {
            element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.endTime != null) {
            element.setAttribute("EndTime", this.endTime.toString());
        }
        if (this.timeScale != null) {
            element.setAttribute("TimeScale", this.timeScale.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<TsNumberOfBlockedApps ");
            if (this.targetType != null) {
                strAttrs.append("TargetType=\"").append(this.getTargetTypeValue()).append("\" ");
            }
            if (this.targetValue != null) {
                strAttrs.append("TargetValue=\"").append(AbstractSchema.checkXMLContent(this.targetValue)).append("\" ");
            }
            if (this.startTime != null) {
                strAttrs.append("StartTime=\"").append(this.startTime.toString()).append("\" ");
            }
            if (this.endTime != null) {
                strAttrs.append("EndTime=\"").append(this.endTime.toString()).append("\" ");
            }
            if (this.timeScale != null) {
                strAttrs.append("TimeScale=\"").append(this.timeScale.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</TsNumberOfBlockedApps>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

