/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.report.ReSubnetBeingAlerted;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReSubnetBeingAlertedArray
extends ConfigObject {
    public static final Integer TRAFFIC = 0;
    public static final Integer PACKET = 1;
    public static final Integer BEHAVIOR = 2;
    private static final long serialVersionUID = 1L;
    private Integer alertType;

    public ReSubnetBeingAlertedArray() {
        this.nameSpace = "report";
        this.children.put(131105, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ReSubnetBeingAlertedArray";
    }

    public Integer getAlertType() {
        return this.alertType;
    }

    public String getAlertTypeValue() throws ValidationException {
        if (this.alertType == null) {
            return null;
        }
        String s = null;
        switch (this.alertType) {
            case 0: {
                s = "TRAFFIC";
                break;
            }
            case 1: {
                s = "PACKET";
                break;
            }
            case 2: {
                s = "BEHAVIOR";
                break;
            }
            default: {
                throw new ValidationException("ReSubnetBeingAlertedArray/AlertType: invalid attribute value:" + this.alertType + "!");
            }
        }
        return s;
    }

    public void setAlertType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.alertType = value;
    }

    public void setAlertTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("TRAFFIC".equals(value)) {
            this.alertType = TRAFFIC;
        } else if ("PACKET".equals(value)) {
            this.alertType = PACKET;
        } else if ("BEHAVIOR".equals(value)) {
            this.alertType = BEHAVIOR;
        } else {
            throw new ValidationException("ReSubnetBeingAlertedArray/AlertType: invalid attribute value:" + value + "!");
        }
    }

    public void addReSubnetBeingAlerted(ReSubnetBeingAlerted value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addReSubnetBeingAlerted(int index, ReSubnetBeingAlerted value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ReSubnetBeingAlerted> getReSubnetBeingAlerted() {
        Vector<ReSubnetBeingAlerted> v = new Vector<ReSubnetBeingAlerted>();
        for (Transportable child : (ChildGroup)this.children.get(131105)) {
            v.add((ReSubnetBeingAlerted)child);
        }
        return v;
    }

    public int getReSubnetBeingAlertedCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(131105);
        return childGroup.size();
    }

    public ReSubnetBeingAlerted getReSubnetBeingAlerted(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(131105);
        return (ReSubnetBeingAlerted)childGroup.get(index);
    }

    public void setReSubnetBeingAlerted(int index, ReSubnetBeingAlerted value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeReSubnetBeingAlerted(ReSubnetBeingAlerted value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 131104;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.alertType == null) {
            throw new ValidationException("ReSubnetBeingAlertedArray/AlertType: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ReSubnetBeingAlerted) {
            try {
                this.addReSubnetBeingAlerted((ReSubnetBeingAlerted)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AlertType");
            if (value == null) {
                throw new ValidationException("ReSubnetBeingAlertedArray/AlertType: attribute is required!");
            }
            this.setAlertTypeValue(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getReSubnetBeingAlertedCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getReSubnetBeingAlerted(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ReSubnetBeingAlertedArray".equals(element.getNodeName())) {
            throw new ValidationException("ReSubnetBeingAlertedArray: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AlertType");
        if (value == null) {
            throw new ValidationException("ReSubnetBeingAlertedArray/AlertType: attribute is required!");
        }
        this.setAlertTypeValue(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ReSubnetBeingAlerted");
        for (int i = 0; i < v.size(); ++i) {
            ReSubnetBeingAlerted reSubnetBeingAlertedObj = new ReSubnetBeingAlerted();
            reSubnetBeingAlertedObj.importFromElement(v.get(i));
            this.addReSubnetBeingAlerted(reSubnetBeingAlertedObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ReSubnetBeingAlertedArray");
        if (this.alertType != null) {
            element.setAttribute("AlertType", this.getAlertTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ReSubnetBeingAlertedArray ");
            if (this.alertType != null) {
                strAttrs.append("AlertType=\"").append(this.getAlertTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ReSubnetBeingAlertedArray>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

