/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReSiteHealth
extends ConfigObject {
    public static final Integer GOOD = 0;
    public static final Integer POOR = 1;
    public static final Integer CRITICAL = 2;
    public static final Integer UNKNOWN = 3;
    private static final long serialVersionUID = 1L;
    private String siteId;
    private Integer healthStatus;
    private String healthReasons;

    public ReSiteHealth() {
        this.nameSpace = "report";
    }

    @Override
    public String getObjectTypeName() {
        return "ReSiteHealth";
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.siteId = value;
    }

    public Integer getHealthStatus() {
        return this.healthStatus;
    }

    public String getHealthStatusValue() throws ValidationException {
        if (this.healthStatus == null) {
            return null;
        }
        String s = null;
        switch (this.healthStatus) {
            case 0: {
                s = "GOOD";
                break;
            }
            case 1: {
                s = "POOR";
                break;
            }
            case 2: {
                s = "CRITICAL";
                break;
            }
            case 3: {
                s = "UNKNOWN";
                break;
            }
            default: {
                throw new ValidationException("ReSiteHealth/HealthStatus: invalid attribute value:" + this.healthStatus + "!");
            }
        }
        return s;
    }

    public void setHealthStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.healthStatus = value;
    }

    public void setHealthStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("GOOD".equals(value)) {
            this.healthStatus = GOOD;
        } else if ("POOR".equals(value)) {
            this.healthStatus = POOR;
        } else if ("CRITICAL".equals(value)) {
            this.healthStatus = CRITICAL;
        } else if ("UNKNOWN".equals(value)) {
            this.healthStatus = UNKNOWN;
        } else {
            throw new ValidationException("ReSiteHealth/HealthStatus: invalid attribute value:" + value + "!");
        }
    }

    public String getOptHealthReasons() {
        return this.healthReasons;
    }

    public void setOptHealthReasons(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.healthReasons = value;
    }

    @Override
    public int getObjectType() {
        return 131075;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.siteId == null) {
            throw new ValidationException("ReSiteHealth/SiteId: attribute is required!");
        }
        if (this.healthStatus == null) {
            throw new ValidationException("ReSiteHealth/HealthStatus: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("SiteId");
            if (value == null) {
                throw new ValidationException("ReSiteHealth/SiteId: attribute is required!");
            }
            this.siteId = value;
            value = attris.getValue("HealthStatus");
            if (value == null) {
                throw new ValidationException("ReSiteHealth/HealthStatus: attribute is required!");
            }
            this.setHealthStatusValue(value);
            value = attris.getValue("HealthReasons");
            if (value != null) {
                this.healthReasons = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ReSiteHealth".equals(element.getNodeName())) {
            throw new ValidationException("ReSiteHealth: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "SiteId");
        if (value == null) {
            throw new ValidationException("ReSiteHealth/SiteId: attribute is required!");
        }
        this.siteId = value;
        value = XMLHelper.getAttribute(element, "HealthStatus");
        if (value == null) {
            throw new ValidationException("ReSiteHealth/HealthStatus: attribute is required!");
        }
        this.setHealthStatusValue(value);
        value = XMLHelper.getAttribute(element, "HealthReasons");
        if (value != null) {
            this.healthReasons = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ReSiteHealth");
        if (this.siteId != null) {
            element.setAttribute("SiteId", this.siteId);
        }
        if (this.healthStatus != null) {
            element.setAttribute("HealthStatus", this.getHealthStatusValue());
        }
        if (this.healthReasons != null) {
            element.setAttribute("HealthReasons", this.healthReasons);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ReSiteHealth ");
            if (this.siteId != null) {
                strAttrs.append("SiteId=\"").append(AbstractSchema.checkXMLContent(this.siteId)).append("\" ");
            }
            if (this.healthStatus != null) {
                strAttrs.append("HealthStatus=\"").append(this.getHealthStatusValue()).append("\" ");
            }
            if (this.healthReasons != null) {
                strAttrs.append("HealthReasons=\"").append(AbstractSchema.checkXMLContent(this.healthReasons)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ReSiteHealth>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

