/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReServerInfo
extends ConfigObject {
    public static final Integer ONLINE = 0;
    public static final Integer OFFLINE = 1;
    public static final Integer GOOD = 0;
    public static final Integer POOR = 1;
    public static final Integer CRITICAL = 2;
    public static final Integer UNKNOWN = 3;
    private static final long serialVersionUID = 1L;
    private String serverId;
    private Integer status;
    private Integer healthStatus;
    private String healthReasons;
    private Integer cpuUsage;
    private Integer memoryUsage;
    private Integer physicalMemoryUsage;
    private Integer heartBeatPerSecond;
    private Integer profileDownloadPerSecond;
    private Integer idsDownloadPerSecond;
    private Integer learnedAppPerSecond;
    private Integer agentInfoUpdatePerSecond;
    private Integer agentSecurityLogPerSecond;
    private Integer agentSystemLogPerSecond;
    private Integer agentTrafficLogPerSecond;
    private Integer agentPacketLogPerSecond;
    private Integer agentBehaviorLogPerSecond;
    private Integer enforcerSystemLogPerSecond;
    private Integer enforcerTrafficLogPerSecond;
    private Integer enforcerClientLogPerSecond;
    private Long freeSystemDiskSpace;
    private Long freeDataDiskSpace;

    public ReServerInfo() {
        this.nameSpace = "report";
    }

    @Override
    public String getObjectTypeName() {
        return "ReServerInfo";
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.serverId = value;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusValue() throws ValidationException {
        if (this.status == null) {
            return null;
        }
        String s = null;
        switch (this.status) {
            case 0: {
                s = "ONLINE";
                break;
            }
            case 1: {
                s = "OFFLINE";
                break;
            }
            default: {
                throw new ValidationException("ReServerInfo/Status: invalid attribute value:" + this.status + "!");
            }
        }
        return s;
    }

    public void setStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.status = value;
    }

    public void setStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ONLINE".equals(value)) {
            this.status = ONLINE;
        } else if ("OFFLINE".equals(value)) {
            this.status = OFFLINE;
        } else {
            throw new ValidationException("ReServerInfo/Status: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptHealthStatus() {
        return this.healthStatus;
    }

    public String getOptHealthStatusValue() throws ValidationException {
        if (this.healthStatus == null) {
            return null;
        }
        String s = null;
        switch (this.healthStatus) {
            case 0: {
                s = "GOOD";
                break;
            }
            case 1: {
                s = "POOR";
                break;
            }
            case 2: {
                s = "CRITICAL";
                break;
            }
            case 3: {
                s = "UNKNOWN";
                break;
            }
            default: {
                throw new ValidationException("ReServerInfo/HealthStatus: invalid attribute value:" + this.healthStatus + "!");
            }
        }
        return s;
    }

    public void setOptHealthStatus(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.healthStatus = value;
    }

    public void setOptHealthStatusValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.healthStatus = null;
            return;
        }
        if ("GOOD".equals(value)) {
            this.healthStatus = GOOD;
        } else if ("POOR".equals(value)) {
            this.healthStatus = POOR;
        } else if ("CRITICAL".equals(value)) {
            this.healthStatus = CRITICAL;
        } else if ("UNKNOWN".equals(value)) {
            this.healthStatus = UNKNOWN;
        } else {
            throw new ValidationException("ReServerInfo/HealthStatus: invalid attribute value:" + value + "!");
        }
    }

    public String getOptHealthReasons() {
        return this.healthReasons;
    }

    public void setOptHealthReasons(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.healthReasons = value;
    }

    public Integer getOptCpuUsage() {
        return this.cpuUsage;
    }

    public void setOptCpuUsage(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.cpuUsage = value;
    }

    public Integer getOptMemoryUsage() {
        return this.memoryUsage;
    }

    public void setOptMemoryUsage(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.memoryUsage = value;
    }

    public Integer getOptPhysicalMemoryUsage() {
        return this.physicalMemoryUsage;
    }

    public void setOptPhysicalMemoryUsage(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.physicalMemoryUsage = value;
    }

    public Integer getOptHeartBeatPerSecond() {
        return this.heartBeatPerSecond;
    }

    public void setOptHeartBeatPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.heartBeatPerSecond = value;
    }

    public Integer getOptProfileDownloadPerSecond() {
        return this.profileDownloadPerSecond;
    }

    public void setOptProfileDownloadPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.profileDownloadPerSecond = value;
    }

    public Integer getOptIdsDownloadPerSecond() {
        return this.idsDownloadPerSecond;
    }

    public void setOptIdsDownloadPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.idsDownloadPerSecond = value;
    }

    public Integer getOptLearnedAppPerSecond() {
        return this.learnedAppPerSecond;
    }

    public void setOptLearnedAppPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.learnedAppPerSecond = value;
    }

    public Integer getOptAgentInfoUpdatePerSecond() {
        return this.agentInfoUpdatePerSecond;
    }

    public void setOptAgentInfoUpdatePerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.agentInfoUpdatePerSecond = value;
    }

    public Integer getOptAgentSecurityLogPerSecond() {
        return this.agentSecurityLogPerSecond;
    }

    public void setOptAgentSecurityLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.agentSecurityLogPerSecond = value;
    }

    public Integer getOptAgentSystemLogPerSecond() {
        return this.agentSystemLogPerSecond;
    }

    public void setOptAgentSystemLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.agentSystemLogPerSecond = value;
    }

    public Integer getOptAgentTrafficLogPerSecond() {
        return this.agentTrafficLogPerSecond;
    }

    public void setOptAgentTrafficLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.agentTrafficLogPerSecond = value;
    }

    public Integer getOptAgentPacketLogPerSecond() {
        return this.agentPacketLogPerSecond;
    }

    public void setOptAgentPacketLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.agentPacketLogPerSecond = value;
    }

    public Integer getOptAgentBehaviorLogPerSecond() {
        return this.agentBehaviorLogPerSecond;
    }

    public void setOptAgentBehaviorLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.agentBehaviorLogPerSecond = value;
    }

    public Integer getOptEnforcerSystemLogPerSecond() {
        return this.enforcerSystemLogPerSecond;
    }

    public void setOptEnforcerSystemLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enforcerSystemLogPerSecond = value;
    }

    public Integer getOptEnforcerTrafficLogPerSecond() {
        return this.enforcerTrafficLogPerSecond;
    }

    public void setOptEnforcerTrafficLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enforcerTrafficLogPerSecond = value;
    }

    public Integer getOptEnforcerClientLogPerSecond() {
        return this.enforcerClientLogPerSecond;
    }

    public void setOptEnforcerClientLogPerSecond(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enforcerClientLogPerSecond = value;
    }

    public Long getOptFreeSystemDiskSpace() {
        return this.freeSystemDiskSpace;
    }

    public void setOptFreeSystemDiskSpace(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.freeSystemDiskSpace = value;
    }

    public Long getOptFreeDataDiskSpace() {
        return this.freeDataDiskSpace;
    }

    public void setOptFreeDataDiskSpace(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.freeDataDiskSpace = value;
    }

    @Override
    public int getObjectType() {
        return 131078;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.serverId == null) {
            throw new ValidationException("ReServerInfo/ServerId: attribute is required!");
        }
        if (this.status == null) {
            throw new ValidationException("ReServerInfo/Status: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block78: {
            try {
                String value = attris.getValue("ServerId");
                if (value == null) {
                    throw new ValidationException("ReServerInfo/ServerId: attribute is required!");
                }
                this.serverId = value;
                value = attris.getValue("Status");
                if (value == null) {
                    throw new ValidationException("ReServerInfo/Status: attribute is required!");
                }
                this.setStatusValue(value);
                value = attris.getValue("HealthStatus");
                if (value != null) {
                    this.setOptHealthStatusValue(value);
                }
                if ((value = attris.getValue("HealthReasons")) != null) {
                    this.healthReasons = value;
                }
                if ((value = attris.getValue("CpuUsage")) != null) {
                    try {
                        this.cpuUsage = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/CpuUsage: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/CpuUsage: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("MemoryUsage")) != null) {
                    try {
                        this.memoryUsage = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/MemoryUsage: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/MemoryUsage: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("PhysicalMemoryUsage")) != null) {
                    try {
                        this.physicalMemoryUsage = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/PhysicalMemoryUsage: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/PhysicalMemoryUsage: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("HeartBeatPerSecond")) != null) {
                    try {
                        this.heartBeatPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/HeartBeatPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/HeartBeatPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("ProfileDownloadPerSecond")) != null) {
                    try {
                        this.profileDownloadPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/ProfileDownloadPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/ProfileDownloadPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("IdsDownloadPerSecond")) != null) {
                    try {
                        this.idsDownloadPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/IdsDownloadPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/IdsDownloadPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("LearnedAppPerSecond")) != null) {
                    try {
                        this.learnedAppPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/LearnedAppPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/LearnedAppPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("AgentInfoUpdatePerSecond")) != null) {
                    try {
                        this.agentInfoUpdatePerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/AgentInfoUpdatePerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/AgentInfoUpdatePerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("AgentSecurityLogPerSecond")) != null) {
                    try {
                        this.agentSecurityLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/AgentSecurityLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/AgentSecurityLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("AgentSystemLogPerSecond")) != null) {
                    try {
                        this.agentSystemLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/AgentSystemLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/AgentSystemLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("AgentTrafficLogPerSecond")) != null) {
                    try {
                        this.agentTrafficLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/AgentTrafficLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/AgentTrafficLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("AgentPacketLogPerSecond")) != null) {
                    try {
                        this.agentPacketLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/AgentPacketLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/AgentPacketLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("AgentBehaviorLogPerSecond")) != null) {
                    try {
                        this.agentBehaviorLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/AgentBehaviorLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/AgentBehaviorLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("EnforcerSystemLogPerSecond")) != null) {
                    try {
                        this.enforcerSystemLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/EnforcerSystemLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/EnforcerSystemLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("EnforcerTrafficLogPerSecond")) != null) {
                    try {
                        this.enforcerTrafficLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/EnforcerTrafficLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/EnforcerTrafficLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("EnforcerClientLogPerSecond")) != null) {
                    try {
                        this.enforcerClientLogPerSecond = Integer.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/EnforcerClientLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/EnforcerClientLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("FreeSystemDiskSpace")) != null) {
                    try {
                        this.freeSystemDiskSpace = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("ReServerInfo/FreeSystemDiskSpace: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("ReServerInfo/FreeSystemDiskSpace: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("FreeDataDiskSpace")) == null) break block78;
                try {
                    this.freeDataDiskSpace = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ReServerInfo/FreeDataDiskSpace: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ReServerInfo/FreeDataDiskSpace: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ReServerInfo".equals(element.getNodeName())) {
            throw new ValidationException("ReServerInfo: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ServerId");
        if (value == null) {
            throw new ValidationException("ReServerInfo/ServerId: attribute is required!");
        }
        this.serverId = value;
        value = XMLHelper.getAttribute(element, "Status");
        if (value == null) {
            throw new ValidationException("ReServerInfo/Status: attribute is required!");
        }
        this.setStatusValue(value);
        value = XMLHelper.getAttribute(element, "HealthStatus");
        if (value != null) {
            this.setOptHealthStatusValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HealthReasons")) != null) {
            this.healthReasons = value;
        }
        if ((value = XMLHelper.getAttribute(element, "CpuUsage")) != null) {
            try {
                this.cpuUsage = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/CpuUsage: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "MemoryUsage")) != null) {
            try {
                this.memoryUsage = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/MemoryUsage: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "PhysicalMemoryUsage")) != null) {
            try {
                this.physicalMemoryUsage = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/PhysicalMemoryUsage: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "HeartBeatPerSecond")) != null) {
            try {
                this.heartBeatPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/HeartBeatPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "ProfileDownloadPerSecond")) != null) {
            try {
                this.profileDownloadPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/ProfileDownloadPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "IdsDownloadPerSecond")) != null) {
            try {
                this.idsDownloadPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/IdsDownloadPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "LearnedAppPerSecond")) != null) {
            try {
                this.learnedAppPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/LearnedAppPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AgentInfoUpdatePerSecond")) != null) {
            try {
                this.agentInfoUpdatePerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/AgentInfoUpdatePerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AgentSecurityLogPerSecond")) != null) {
            try {
                this.agentSecurityLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/AgentSecurityLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AgentSystemLogPerSecond")) != null) {
            try {
                this.agentSystemLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/AgentSystemLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AgentTrafficLogPerSecond")) != null) {
            try {
                this.agentTrafficLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/AgentTrafficLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AgentPacketLogPerSecond")) != null) {
            try {
                this.agentPacketLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/AgentPacketLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "AgentBehaviorLogPerSecond")) != null) {
            try {
                this.agentBehaviorLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/AgentBehaviorLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "EnforcerSystemLogPerSecond")) != null) {
            try {
                this.enforcerSystemLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/EnforcerSystemLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "EnforcerTrafficLogPerSecond")) != null) {
            try {
                this.enforcerTrafficLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/EnforcerTrafficLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "EnforcerClientLogPerSecond")) != null) {
            try {
                this.enforcerClientLogPerSecond = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/EnforcerClientLogPerSecond: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FreeSystemDiskSpace")) != null) {
            try {
                this.freeSystemDiskSpace = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/FreeSystemDiskSpace: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "FreeDataDiskSpace")) != null) {
            try {
                this.freeDataDiskSpace = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ReServerInfo/FreeDataDiskSpace: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ReServerInfo");
        if (this.serverId != null) {
            element.setAttribute("ServerId", this.serverId);
        }
        if (this.status != null) {
            element.setAttribute("Status", this.getStatusValue());
        }
        if (this.healthStatus != null) {
            element.setAttribute("HealthStatus", this.getOptHealthStatusValue());
        }
        if (this.healthReasons != null) {
            element.setAttribute("HealthReasons", this.healthReasons);
        }
        if (this.cpuUsage != null) {
            element.setAttribute("CpuUsage", this.cpuUsage.toString());
        }
        if (this.memoryUsage != null) {
            element.setAttribute("MemoryUsage", this.memoryUsage.toString());
        }
        if (this.physicalMemoryUsage != null) {
            element.setAttribute("PhysicalMemoryUsage", this.physicalMemoryUsage.toString());
        }
        if (this.heartBeatPerSecond != null) {
            element.setAttribute("HeartBeatPerSecond", this.heartBeatPerSecond.toString());
        }
        if (this.profileDownloadPerSecond != null) {
            element.setAttribute("ProfileDownloadPerSecond", this.profileDownloadPerSecond.toString());
        }
        if (this.idsDownloadPerSecond != null) {
            element.setAttribute("IdsDownloadPerSecond", this.idsDownloadPerSecond.toString());
        }
        if (this.learnedAppPerSecond != null) {
            element.setAttribute("LearnedAppPerSecond", this.learnedAppPerSecond.toString());
        }
        if (this.agentInfoUpdatePerSecond != null) {
            element.setAttribute("AgentInfoUpdatePerSecond", this.agentInfoUpdatePerSecond.toString());
        }
        if (this.agentSecurityLogPerSecond != null) {
            element.setAttribute("AgentSecurityLogPerSecond", this.agentSecurityLogPerSecond.toString());
        }
        if (this.agentSystemLogPerSecond != null) {
            element.setAttribute("AgentSystemLogPerSecond", this.agentSystemLogPerSecond.toString());
        }
        if (this.agentTrafficLogPerSecond != null) {
            element.setAttribute("AgentTrafficLogPerSecond", this.agentTrafficLogPerSecond.toString());
        }
        if (this.agentPacketLogPerSecond != null) {
            element.setAttribute("AgentPacketLogPerSecond", this.agentPacketLogPerSecond.toString());
        }
        if (this.agentBehaviorLogPerSecond != null) {
            element.setAttribute("AgentBehaviorLogPerSecond", this.agentBehaviorLogPerSecond.toString());
        }
        if (this.enforcerSystemLogPerSecond != null) {
            element.setAttribute("EnforcerSystemLogPerSecond", this.enforcerSystemLogPerSecond.toString());
        }
        if (this.enforcerTrafficLogPerSecond != null) {
            element.setAttribute("EnforcerTrafficLogPerSecond", this.enforcerTrafficLogPerSecond.toString());
        }
        if (this.enforcerClientLogPerSecond != null) {
            element.setAttribute("EnforcerClientLogPerSecond", this.enforcerClientLogPerSecond.toString());
        }
        if (this.freeSystemDiskSpace != null) {
            element.setAttribute("FreeSystemDiskSpace", this.freeSystemDiskSpace.toString());
        }
        if (this.freeDataDiskSpace != null) {
            element.setAttribute("FreeDataDiskSpace", this.freeDataDiskSpace.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ReServerInfo ");
            if (this.serverId != null) {
                strAttrs.append("ServerId=\"").append(AbstractSchema.checkXMLContent(this.serverId)).append("\" ");
            }
            if (this.status != null) {
                strAttrs.append("Status=\"").append(this.getStatusValue()).append("\" ");
            }
            if (this.healthStatus != null) {
                strAttrs.append("HealthStatus=\"").append(this.getOptHealthStatusValue()).append("\" ");
            }
            if (this.healthReasons != null) {
                strAttrs.append("HealthReasons=\"").append(AbstractSchema.checkXMLContent(this.healthReasons)).append("\" ");
            }
            if (this.cpuUsage != null) {
                strAttrs.append("CpuUsage=\"").append(this.cpuUsage.toString()).append("\" ");
            }
            if (this.memoryUsage != null) {
                strAttrs.append("MemoryUsage=\"").append(this.memoryUsage.toString()).append("\" ");
            }
            if (this.physicalMemoryUsage != null) {
                strAttrs.append("PhysicalMemoryUsage=\"").append(this.physicalMemoryUsage.toString()).append("\" ");
            }
            if (this.heartBeatPerSecond != null) {
                strAttrs.append("HeartBeatPerSecond=\"").append(this.heartBeatPerSecond.toString()).append("\" ");
            }
            if (this.profileDownloadPerSecond != null) {
                strAttrs.append("ProfileDownloadPerSecond=\"").append(this.profileDownloadPerSecond.toString()).append("\" ");
            }
            if (this.idsDownloadPerSecond != null) {
                strAttrs.append("IdsDownloadPerSecond=\"").append(this.idsDownloadPerSecond.toString()).append("\" ");
            }
            if (this.learnedAppPerSecond != null) {
                strAttrs.append("LearnedAppPerSecond=\"").append(this.learnedAppPerSecond.toString()).append("\" ");
            }
            if (this.agentInfoUpdatePerSecond != null) {
                strAttrs.append("AgentInfoUpdatePerSecond=\"").append(this.agentInfoUpdatePerSecond.toString()).append("\" ");
            }
            if (this.agentSecurityLogPerSecond != null) {
                strAttrs.append("AgentSecurityLogPerSecond=\"").append(this.agentSecurityLogPerSecond.toString()).append("\" ");
            }
            if (this.agentSystemLogPerSecond != null) {
                strAttrs.append("AgentSystemLogPerSecond=\"").append(this.agentSystemLogPerSecond.toString()).append("\" ");
            }
            if (this.agentTrafficLogPerSecond != null) {
                strAttrs.append("AgentTrafficLogPerSecond=\"").append(this.agentTrafficLogPerSecond.toString()).append("\" ");
            }
            if (this.agentPacketLogPerSecond != null) {
                strAttrs.append("AgentPacketLogPerSecond=\"").append(this.agentPacketLogPerSecond.toString()).append("\" ");
            }
            if (this.agentBehaviorLogPerSecond != null) {
                strAttrs.append("AgentBehaviorLogPerSecond=\"").append(this.agentBehaviorLogPerSecond.toString()).append("\" ");
            }
            if (this.enforcerSystemLogPerSecond != null) {
                strAttrs.append("EnforcerSystemLogPerSecond=\"").append(this.enforcerSystemLogPerSecond.toString()).append("\" ");
            }
            if (this.enforcerTrafficLogPerSecond != null) {
                strAttrs.append("EnforcerTrafficLogPerSecond=\"").append(this.enforcerTrafficLogPerSecond.toString()).append("\" ");
            }
            if (this.enforcerClientLogPerSecond != null) {
                strAttrs.append("EnforcerClientLogPerSecond=\"").append(this.enforcerClientLogPerSecond.toString()).append("\" ");
            }
            if (this.freeSystemDiskSpace != null) {
                strAttrs.append("FreeSystemDiskSpace=\"").append(this.freeSystemDiskSpace.toString()).append("\" ");
            }
            if (this.freeDataDiskSpace != null) {
                strAttrs.append("FreeDataDiskSpace=\"").append(this.freeDataDiskSpace.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ReServerInfo>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

