/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.report.ReLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RePolicyUsageLocation
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String inheritFrom;

    public RePolicyUsageLocation() {
        this.nameSpace = "report";
        this.children.put(131150, new ChildGroup(1, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "RePolicyUsageLocation";
    }

    public String getOptInheritFrom() {
        return this.inheritFrom;
    }

    public void setOptInheritFrom(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.inheritFrom = value;
    }

    public void addReLocation(ReLocation value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addReLocation(int index, ReLocation value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ReLocation> getReLocation() {
        Vector<ReLocation> v = new Vector<ReLocation>();
        for (Transportable child : (ChildGroup)this.children.get(131150)) {
            v.add((ReLocation)child);
        }
        return v;
    }

    public int getReLocationCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(131150);
        return childGroup.size();
    }

    public ReLocation getReLocation(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(131150);
        return (ReLocation)childGroup.get(index);
    }

    public void setReLocation(int index, ReLocation value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeReLocation(ReLocation value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 131148;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getReLocationCount() < 1) {
            throw new ValidationException("RePolicyUsageLocation/ReLocation: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ReLocation) {
            try {
                this.addReLocation((ReLocation)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("InheritFrom");
            if (value != null) {
                this.inheritFrom = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getReLocationCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getReLocation(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(131150)).size();
        }
        catch (Throwable t) {
            throw new SAXException("RePolicyUsageLocation: can't import element == ReLocation!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"RePolicyUsageLocation".equals(element.getNodeName())) {
            throw new ValidationException("RePolicyUsageLocation: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "InheritFrom");
        if (value != null) {
            this.inheritFrom = value;
        }
        if ((v = XMLHelper.getChildElementByName(element, "ReLocation")).size() < 1) {
            throw new ValidationException("RePolicyUsageLocation/ReLocation: element is require!");
        }
        for (int i = 0; i < v.size(); ++i) {
            ReLocation reLocationObj = new ReLocation();
            reLocationObj.importFromElement(v.get(i));
            this.addReLocation(reLocationObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("RePolicyUsageLocation");
        if (this.inheritFrom != null) {
            element.setAttribute("InheritFrom", this.inheritFrom);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RePolicyUsageLocation ");
            if (this.inheritFrom != null) {
                strAttrs.append("InheritFrom=\"").append(AbstractSchema.checkXMLContent(this.inheritFrom)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RePolicyUsageLocation>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

