/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.report;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.report.ReAttacks;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReAgentBeingAttacked
extends ConfigObject {
    private static final long serialVersionUID = 1L;
    private String hostName;
    private String ipAddress;

    public ReAgentBeingAttacked() {
        this.nameSpace = "report";
        this.children.put(131092, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ReAgentBeingAttacked";
    }

    public String getOptHostName() {
        return this.hostName;
    }

    public void setOptHostName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.hostName = value;
    }

    public String getOptIpAddress() {
        return this.ipAddress;
    }

    public void setOptIpAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ipAddress = value;
    }

    public void addReAttacks(ReAttacks value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addReAttacks(int index, ReAttacks value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<ReAttacks> getReAttacks() {
        Vector<ReAttacks> v = new Vector<ReAttacks>();
        for (Transportable child : (ChildGroup)this.children.get(131092)) {
            v.add((ReAttacks)child);
        }
        return v;
    }

    public int getReAttacksCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(131092);
        return childGroup.size();
    }

    public ReAttacks getReAttacks(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(131092);
        return (ReAttacks)childGroup.get(index);
    }

    public void setReAttacks(int index, ReAttacks value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeReAttacks(ReAttacks value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 131096;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof ReAttacks) {
            try {
                this.addReAttacks((ReAttacks)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("HostName");
            if (value != null) {
                this.hostName = value;
            }
            if ((value = attris.getValue("IpAddress")) != null) {
                this.ipAddress = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getReAttacksCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getReAttacks(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ReAgentBeingAttacked".equals(element.getNodeName())) {
            throw new ValidationException("ReAgentBeingAttacked: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "HostName");
        if (value != null) {
            this.hostName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "IpAddress")) != null) {
            this.ipAddress = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "ReAttacks");
        for (int i = 0; i < v.size(); ++i) {
            ReAttacks reAttacksObj = new ReAttacks();
            reAttacksObj.importFromElement(v.get(i));
            this.addReAttacks(reAttacksObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ReAgentBeingAttacked");
        if (this.hostName != null) {
            element.setAttribute("HostName", this.hostName);
        }
        if (this.ipAddress != null) {
            element.setAttribute("IpAddress", this.ipAddress);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ReAgentBeingAttacked ");
            if (this.hostName != null) {
                strAttrs.append("HostName=\"").append(AbstractSchema.checkXMLContent(this.hostName)).append("\" ");
            }
            if (this.ipAddress != null) {
                strAttrs.append("IpAddress=\"").append(AbstractSchema.checkXMLContent(this.ipAddress)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ReAgentBeingAttacked>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

