/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.enforcer.Switch;
import com.sygate.scm.common.configobject.enforcer.SwitchAction;
import com.sygate.scm.common.configobject.enforcer.Vlan;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SwitchProfile
extends AbstractSchema {
    public static final Integer OTHERS = 0;
    public static final Integer THREECOM = 1;
    public static final Integer ALCATEL = 2;
    public static final Integer ALCATEL_6200 = 3;
    public static final Integer CISCO = 4;
    public static final Integer DELL = 5;
    public static final Integer ENTERASYS = 6;
    public static final Integer EXTERME = 7;
    public static final Integer FOUNDRY = 8;
    public static final Integer HP = 9;
    public static final Integer NORTEL = 10;
    public static final Integer CISCO_AP = 11;
    public static final Integer ARUBA = 12;
    public static final Integer AIRESPACE = 13;
    public static final Integer NORTEL_AP = 14;
    public static final Integer ENTERASYS_AP = 15;
    public static final Integer HUAWEI = 16;
    public static final Integer HUAWEI_JAN2009 = 17;
    public static final Integer ALLIED_TELESIS = 18;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String friendlyName;
    private Integer model;
    private String sharedSecret;
    private Integer reauthTimeout;
    private Boolean forwardOtherProtocol;
    private String radiusId;

    public SwitchProfile() {
        this.nameSpace = "enforcer";
        this.children.put(393254, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(393255, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(393256, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "SwitchProfile";
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.friendlyName = value;
    }

    public Integer getModel() {
        return this.model;
    }

    public String getModelValue() throws ValidationException {
        if (this.model == null) {
            return null;
        }
        String s = null;
        switch (this.model) {
            case 0: {
                s = "OTHERS";
                break;
            }
            case 1: {
                s = "THREECOM";
                break;
            }
            case 2: {
                s = "ALCATEL";
                break;
            }
            case 3: {
                s = "ALCATEL_6200";
                break;
            }
            case 4: {
                s = "CISCO";
                break;
            }
            case 5: {
                s = "DELL";
                break;
            }
            case 6: {
                s = "ENTERASYS";
                break;
            }
            case 7: {
                s = "EXTERME";
                break;
            }
            case 8: {
                s = "FOUNDRY";
                break;
            }
            case 9: {
                s = "HP";
                break;
            }
            case 10: {
                s = "NORTEL";
                break;
            }
            case 11: {
                s = "CISCO_AP";
                break;
            }
            case 12: {
                s = "ARUBA";
                break;
            }
            case 13: {
                s = "AIRESPACE";
                break;
            }
            case 14: {
                s = "NORTEL_AP";
                break;
            }
            case 15: {
                s = "ENTERASYS_AP";
                break;
            }
            case 16: {
                s = "HUAWEI";
                break;
            }
            case 17: {
                s = "HUAWEI_JAN2009";
                break;
            }
            case 18: {
                s = "ALLIED_TELESIS";
                break;
            }
            default: {
                throw new ValidationException("SwitchProfile/Model: invalid attribute value:" + this.model + "!");
            }
        }
        return s;
    }

    public void setModel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.model = value;
    }

    public void setModelValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("OTHERS".equals(value)) {
            this.model = OTHERS;
        } else if ("THREECOM".equals(value)) {
            this.model = THREECOM;
        } else if ("ALCATEL".equals(value)) {
            this.model = ALCATEL;
        } else if ("ALCATEL_6200".equals(value)) {
            this.model = ALCATEL_6200;
        } else if ("CISCO".equals(value)) {
            this.model = CISCO;
        } else if ("DELL".equals(value)) {
            this.model = DELL;
        } else if ("ENTERASYS".equals(value)) {
            this.model = ENTERASYS;
        } else if ("EXTERME".equals(value)) {
            this.model = EXTERME;
        } else if ("FOUNDRY".equals(value)) {
            this.model = FOUNDRY;
        } else if ("HP".equals(value)) {
            this.model = HP;
        } else if ("NORTEL".equals(value)) {
            this.model = NORTEL;
        } else if ("CISCO_AP".equals(value)) {
            this.model = CISCO_AP;
        } else if ("ARUBA".equals(value)) {
            this.model = ARUBA;
        } else if ("AIRESPACE".equals(value)) {
            this.model = AIRESPACE;
        } else if ("NORTEL_AP".equals(value)) {
            this.model = NORTEL_AP;
        } else if ("ENTERASYS_AP".equals(value)) {
            this.model = ENTERASYS_AP;
        } else if ("HUAWEI".equals(value)) {
            this.model = HUAWEI;
        } else if ("HUAWEI_JAN2009".equals(value)) {
            this.model = HUAWEI_JAN2009;
        } else if ("ALLIED_TELESIS".equals(value)) {
            this.model = ALLIED_TELESIS;
        } else {
            throw new ValidationException("SwitchProfile/Model: invalid attribute value:" + value + "!");
        }
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.sharedSecret = value;
    }

    public Integer getReauthTimeout() {
        return this.reauthTimeout;
    }

    public void setReauthTimeout(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.reauthTimeout = value;
    }

    public Boolean getForwardOtherProtocol() {
        return this.forwardOtherProtocol;
    }

    public void setForwardOtherProtocol(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.forwardOtherProtocol = value;
    }

    public String getRadiusId() {
        return this.radiusId;
    }

    public void setRadiusId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.radiusId = value;
    }

    public void addSwitch(Switch value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSwitch(int index, Switch value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Switch> getSwitch() {
        Vector<Switch> v = new Vector<Switch>();
        for (Transportable child : (ChildGroup)this.children.get(393254)) {
            v.add((Switch)child);
        }
        return v;
    }

    public int getSwitchCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393254);
        return childGroup.size();
    }

    public Switch getSwitch(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(393254);
        return (Switch)childGroup.get(index);
    }

    public void setSwitch(int index, Switch value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSwitch(Switch value) {
        this.removeChild(value);
    }

    public void addVlan(Vlan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addVlan(int index, Vlan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Vlan> getVlan() {
        Vector<Vlan> v = new Vector<Vlan>();
        for (Transportable child : (ChildGroup)this.children.get(393255)) {
            v.add((Vlan)child);
        }
        return v;
    }

    public int getVlanCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393255);
        return childGroup.size();
    }

    public Vlan getVlan(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(393255);
        return (Vlan)childGroup.get(index);
    }

    public void setVlan(int index, Vlan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeVlan(Vlan value) {
        this.removeChild(value);
    }

    public void addSwitchAction(SwitchAction value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSwitchAction(int index, SwitchAction value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SwitchAction> getSwitchAction() {
        Vector<SwitchAction> v = new Vector<SwitchAction>();
        for (Transportable child : (ChildGroup)this.children.get(393256)) {
            v.add((SwitchAction)child);
        }
        return v;
    }

    public int getSwitchActionCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393256);
        return childGroup.size();
    }

    public SwitchAction getSwitchAction(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(393256);
        return (SwitchAction)childGroup.get(index);
    }

    public void setSwitchAction(int index, SwitchAction value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSwitchAction(SwitchAction value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 393253;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enable == null) {
            throw new ValidationException("SwitchProfile/Enable: attribute is required!");
        }
        if (this.friendlyName == null) {
            throw new ValidationException("SwitchProfile/FriendlyName: attribute is required!");
        }
        if (this.model == null) {
            throw new ValidationException("SwitchProfile/Model: attribute is required!");
        }
        if (this.sharedSecret == null) {
            throw new ValidationException("SwitchProfile/SharedSecret: attribute is required!");
        }
        if (this.reauthTimeout == null) {
            throw new ValidationException("SwitchProfile/ReauthTimeout: attribute is required!");
        }
        if (this.forwardOtherProtocol == null) {
            throw new ValidationException("SwitchProfile/ForwardOtherProtocol: attribute is required!");
        }
        if (this.radiusId == null) {
            throw new ValidationException("SwitchProfile/RadiusId: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof Switch) {
            try {
                this.addSwitch((Switch)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Vlan) {
            try {
                this.addVlan((Vlan)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SwitchAction) {
            try {
                this.addSwitchAction((SwitchAction)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value == null) {
                throw new ValidationException("SwitchProfile/Enable: attribute is required!");
            }
            this.enable = "1".equals(value);
            value = attris.getValue("FriendlyName");
            if (value == null) {
                throw new ValidationException("SwitchProfile/FriendlyName: attribute is required!");
            }
            this.friendlyName = value;
            value = attris.getValue("Model");
            if (value == null) {
                throw new ValidationException("SwitchProfile/Model: attribute is required!");
            }
            this.setModelValue(value);
            value = attris.getValue("SharedSecret");
            if (value == null) {
                throw new ValidationException("SwitchProfile/SharedSecret: attribute is required!");
            }
            this.sharedSecret = value;
            value = attris.getValue("ReauthTimeout");
            if (value == null) {
                throw new ValidationException("SwitchProfile/ReauthTimeout: attribute is required!");
            }
            try {
                this.reauthTimeout = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SwitchProfile/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SwitchProfile/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("ForwardOtherProtocol");
            if (value == null) {
                throw new ValidationException("SwitchProfile/ForwardOtherProtocol: attribute is required!");
            }
            this.forwardOtherProtocol = "1".equals(value);
            value = attris.getValue("RadiusId");
            if (value == null) {
                throw new ValidationException("SwitchProfile/RadiusId: attribute is required!");
            }
            this.radiusId = value;
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getSwitchCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSwitch(i).setReadonly();
        }
        objCnt = this.getVlanCount();
        for (i = 0; i < objCnt; ++i) {
            this.getVlan(i).setReadonly();
        }
        objCnt = this.getSwitchActionCount();
        for (i = 0; i < objCnt; ++i) {
            this.getSwitchAction(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"SwitchProfile".equals(element.getNodeName())) {
            throw new ValidationException("SwitchProfile: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value == null) {
            throw new ValidationException("SwitchProfile/Enable: attribute is required!");
        }
        this.enable = "1".equals(value);
        value = XMLHelper.getAttribute(element, "FriendlyName");
        if (value == null) {
            throw new ValidationException("SwitchProfile/FriendlyName: attribute is required!");
        }
        this.friendlyName = value;
        value = XMLHelper.getAttribute(element, "Model");
        if (value == null) {
            throw new ValidationException("SwitchProfile/Model: attribute is required!");
        }
        this.setModelValue(value);
        value = XMLHelper.getAttribute(element, "SharedSecret");
        if (value == null) {
            throw new ValidationException("SwitchProfile/SharedSecret: attribute is required!");
        }
        this.sharedSecret = value;
        value = XMLHelper.getAttribute(element, "ReauthTimeout");
        if (value == null) {
            throw new ValidationException("SwitchProfile/ReauthTimeout: attribute is required!");
        }
        try {
            this.reauthTimeout = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SwitchProfile/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SwitchProfile/ReauthTimeout: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "ForwardOtherProtocol");
        if (value == null) {
            throw new ValidationException("SwitchProfile/ForwardOtherProtocol: attribute is required!");
        }
        this.forwardOtherProtocol = "1".equals(value);
        value = XMLHelper.getAttribute(element, "RadiusId");
        if (value == null) {
            throw new ValidationException("SwitchProfile/RadiusId: attribute is required!");
        }
        this.radiusId = value;
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "Switch");
        for (i = 0; i < v.size(); ++i) {
            Switch varSwitchObj = new Switch();
            varSwitchObj.importFromElement(v.get(i));
            this.addSwitch(varSwitchObj);
        }
        v = XMLHelper.getChildElementByName(element, "Vlan");
        for (i = 0; i < v.size(); ++i) {
            Vlan vlanObj = new Vlan();
            vlanObj.importFromElement(v.get(i));
            this.addVlan(vlanObj);
        }
        v = XMLHelper.getChildElementByName(element, "SwitchAction");
        for (i = 0; i < v.size(); ++i) {
            SwitchAction switchActionObj = new SwitchAction();
            switchActionObj.importFromElement(v.get(i));
            this.addSwitchAction(switchActionObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SwitchProfile");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.friendlyName != null) {
            element.setAttribute("FriendlyName", this.friendlyName);
        }
        if (this.model != null) {
            element.setAttribute("Model", this.getModelValue());
        }
        if (this.sharedSecret != null) {
            element.setAttribute("SharedSecret", this.sharedSecret);
        }
        if (this.reauthTimeout != null) {
            element.setAttribute("ReauthTimeout", this.reauthTimeout.toString());
        }
        if (this.forwardOtherProtocol != null) {
            element.setAttribute("ForwardOtherProtocol", this.forwardOtherProtocol != false ? "1" : "0");
        }
        if (this.radiusId != null) {
            element.setAttribute("RadiusId", this.radiusId);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SwitchProfile ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.friendlyName != null) {
                strAttrs.append("FriendlyName=\"").append(AbstractSchema.checkXMLContent(this.friendlyName)).append("\" ");
            }
            if (this.model != null) {
                strAttrs.append("Model=\"").append(this.getModelValue()).append("\" ");
            }
            if (this.sharedSecret != null) {
                strAttrs.append("SharedSecret=\"").append(AbstractSchema.checkXMLContent(this.sharedSecret)).append("\" ");
            }
            if (this.reauthTimeout != null) {
                strAttrs.append("ReauthTimeout=\"").append(this.reauthTimeout.toString()).append("\" ");
            }
            if (this.forwardOtherProtocol != null) {
                strAttrs.append("ForwardOtherProtocol=").append(this.forwardOtherProtocol != false ? "\"1\" " : "\"0\" ");
            }
            if (this.radiusId != null) {
                strAttrs.append("RadiusId=\"").append(AbstractSchema.checkXMLContent(this.radiusId)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SwitchProfile>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

