/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SwitchAction
extends AbstractSchema {
    public static final Integer OPEN_PORT = 0;
    public static final Integer CLOSE_PORT = 1;
    public static final Integer ASSIGN_VLAN = 2;
    public static final Integer PASSED = 0;
    public static final Integer FAILED = 1;
    public static final Integer ANY = 2;
    public static final Integer UNAVAILABLE = 3;
    private static final long serialVersionUID = 1L;
    private Integer order;
    private Integer action;
    private Integer vlanId;
    private Integer hiResult;
    private Integer profileResult;
    private Integer eapResult;
    private String roleName;

    public SwitchAction() {
        this.nameSpace = "enforcer";
    }

    @Override
    public String getObjectTypeName() {
        return "SwitchAction";
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.order = value;
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "OPEN_PORT";
                break;
            }
            case 1: {
                s = "CLOSE_PORT";
                break;
            }
            case 2: {
                s = "ASSIGN_VLAN";
                break;
            }
            default: {
                throw new ValidationException("SwitchAction/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("OPEN_PORT".equals(value)) {
            this.action = OPEN_PORT;
        } else if ("CLOSE_PORT".equals(value)) {
            this.action = CLOSE_PORT;
        } else if ("ASSIGN_VLAN".equals(value)) {
            this.action = ASSIGN_VLAN;
        } else {
            throw new ValidationException("SwitchAction/Action: invalid attribute value:" + value + "!");
        }
    }

    public Integer getVlanId() {
        return this.vlanId;
    }

    public void setVlanId(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.vlanId = value;
    }

    public Integer getHiResult() {
        return this.hiResult;
    }

    public String getHiResultValue() throws ValidationException {
        if (this.hiResult == null) {
            return null;
        }
        String s = null;
        switch (this.hiResult) {
            case 0: {
                s = "PASSED";
                break;
            }
            case 1: {
                s = "FAILED";
                break;
            }
            case 2: {
                s = "ANY";
                break;
            }
            case 3: {
                s = "UNAVAILABLE";
                break;
            }
            default: {
                throw new ValidationException("SwitchAction/HiResult: invalid attribute value:" + this.hiResult + "!");
            }
        }
        return s;
    }

    public void setHiResult(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.hiResult = value;
    }

    public void setHiResultValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("PASSED".equals(value)) {
            this.hiResult = PASSED;
        } else if ("FAILED".equals(value)) {
            this.hiResult = FAILED;
        } else if ("ANY".equals(value)) {
            this.hiResult = ANY;
        } else if ("UNAVAILABLE".equals(value)) {
            this.hiResult = UNAVAILABLE;
        } else {
            throw new ValidationException("SwitchAction/HiResult: invalid attribute value:" + value + "!");
        }
    }

    public Integer getProfileResult() {
        return this.profileResult;
    }

    public String getProfileResultValue() throws ValidationException {
        if (this.profileResult == null) {
            return null;
        }
        String s = null;
        switch (this.profileResult) {
            case 0: {
                s = "PASSED";
                break;
            }
            case 1: {
                s = "FAILED";
                break;
            }
            case 2: {
                s = "ANY";
                break;
            }
            case 3: {
                s = "UNAVAILABLE";
                break;
            }
            default: {
                throw new ValidationException("SwitchAction/ProfileResult: invalid attribute value:" + this.profileResult + "!");
            }
        }
        return s;
    }

    public void setProfileResult(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.profileResult = value;
    }

    public void setProfileResultValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("PASSED".equals(value)) {
            this.profileResult = PASSED;
        } else if ("FAILED".equals(value)) {
            this.profileResult = FAILED;
        } else if ("ANY".equals(value)) {
            this.profileResult = ANY;
        } else if ("UNAVAILABLE".equals(value)) {
            this.profileResult = UNAVAILABLE;
        } else {
            throw new ValidationException("SwitchAction/ProfileResult: invalid attribute value:" + value + "!");
        }
    }

    public Integer getEapResult() {
        return this.eapResult;
    }

    public String getEapResultValue() throws ValidationException {
        if (this.eapResult == null) {
            return null;
        }
        String s = null;
        switch (this.eapResult) {
            case 0: {
                s = "PASSED";
                break;
            }
            case 1: {
                s = "FAILED";
                break;
            }
            case 2: {
                s = "ANY";
                break;
            }
            case 3: {
                s = "UNAVAILABLE";
                break;
            }
            default: {
                throw new ValidationException("SwitchAction/EapResult: invalid attribute value:" + this.eapResult + "!");
            }
        }
        return s;
    }

    public void setEapResult(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.eapResult = value;
    }

    public void setEapResultValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("PASSED".equals(value)) {
            this.eapResult = PASSED;
        } else if ("FAILED".equals(value)) {
            this.eapResult = FAILED;
        } else if ("ANY".equals(value)) {
            this.eapResult = ANY;
        } else if ("UNAVAILABLE".equals(value)) {
            this.eapResult = UNAVAILABLE;
        } else {
            throw new ValidationException("SwitchAction/EapResult: invalid attribute value:" + value + "!");
        }
    }

    public String getOptRoleName() {
        return this.roleName;
    }

    public void setOptRoleName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.roleName = value;
    }

    @Override
    public int getObjectType() {
        return 393256;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.order == null) {
            throw new ValidationException("SwitchAction/Order: attribute is required!");
        }
        if (this.action == null) {
            throw new ValidationException("SwitchAction/Action: attribute is required!");
        }
        if (this.vlanId == null) {
            throw new ValidationException("SwitchAction/VlanId: attribute is required!");
        }
        if (this.hiResult == null) {
            throw new ValidationException("SwitchAction/HiResult: attribute is required!");
        }
        if (this.profileResult == null) {
            throw new ValidationException("SwitchAction/ProfileResult: attribute is required!");
        }
        if (this.eapResult == null) {
            throw new ValidationException("SwitchAction/EapResult: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Order");
            if (value == null) {
                throw new ValidationException("SwitchAction/Order: attribute is required!");
            }
            try {
                this.order = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SwitchAction/Order: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SwitchAction/Order: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Action");
            if (value == null) {
                throw new ValidationException("SwitchAction/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("VlanId");
            if (value == null) {
                throw new ValidationException("SwitchAction/VlanId: attribute is required!");
            }
            try {
                this.vlanId = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("SwitchAction/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("SwitchAction/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("HiResult");
            if (value == null) {
                throw new ValidationException("SwitchAction/HiResult: attribute is required!");
            }
            this.setHiResultValue(value);
            value = attris.getValue("ProfileResult");
            if (value == null) {
                throw new ValidationException("SwitchAction/ProfileResult: attribute is required!");
            }
            this.setProfileResultValue(value);
            value = attris.getValue("EapResult");
            if (value == null) {
                throw new ValidationException("SwitchAction/EapResult: attribute is required!");
            }
            this.setEapResultValue(value);
            value = attris.getValue("RoleName");
            if (value != null) {
                this.roleName = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SwitchAction".equals(element.getNodeName())) {
            throw new ValidationException("SwitchAction: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Order");
        if (value == null) {
            throw new ValidationException("SwitchAction/Order: attribute is required!");
        }
        try {
            this.order = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SwitchAction/Order: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SwitchAction/Order: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Action");
        if (value == null) {
            throw new ValidationException("SwitchAction/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "VlanId");
        if (value == null) {
            throw new ValidationException("SwitchAction/VlanId: attribute is required!");
        }
        try {
            this.vlanId = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("SwitchAction/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("SwitchAction/VlanId: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "HiResult");
        if (value == null) {
            throw new ValidationException("SwitchAction/HiResult: attribute is required!");
        }
        this.setHiResultValue(value);
        value = XMLHelper.getAttribute(element, "ProfileResult");
        if (value == null) {
            throw new ValidationException("SwitchAction/ProfileResult: attribute is required!");
        }
        this.setProfileResultValue(value);
        value = XMLHelper.getAttribute(element, "EapResult");
        if (value == null) {
            throw new ValidationException("SwitchAction/EapResult: attribute is required!");
        }
        this.setEapResultValue(value);
        value = XMLHelper.getAttribute(element, "RoleName");
        if (value != null) {
            this.roleName = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SwitchAction");
        if (this.order != null) {
            element.setAttribute("Order", this.order.toString());
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.vlanId != null) {
            element.setAttribute("VlanId", this.vlanId.toString());
        }
        if (this.hiResult != null) {
            element.setAttribute("HiResult", this.getHiResultValue());
        }
        if (this.profileResult != null) {
            element.setAttribute("ProfileResult", this.getProfileResultValue());
        }
        if (this.eapResult != null) {
            element.setAttribute("EapResult", this.getEapResultValue());
        }
        if (this.roleName != null) {
            element.setAttribute("RoleName", this.roleName);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SwitchAction ");
            if (this.order != null) {
                strAttrs.append("Order=\"").append(this.order.toString()).append("\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.vlanId != null) {
                strAttrs.append("VlanId=\"").append(this.vlanId.toString()).append("\" ");
            }
            if (this.hiResult != null) {
                strAttrs.append("HiResult=\"").append(this.getHiResultValue()).append("\" ");
            }
            if (this.profileResult != null) {
                strAttrs.append("ProfileResult=\"").append(this.getProfileResultValue()).append("\" ");
            }
            if (this.eapResult != null) {
                strAttrs.append("EapResult=\"").append(this.getEapResultValue()).append("\" ");
            }
            if (this.roleName != null) {
                strAttrs.append("RoleName=\"").append(AbstractSchema.checkXMLContent(this.roleName)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SwitchAction>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

