/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Product
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String name;
    private String versionNo;

    public Product() {
        this.nameSpace = "enforcer";
    }

    @Override
    public String getObjectTypeName() {
        return "Product";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getVersionNo() {
        return this.versionNo;
    }

    public void setVersionNo(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.versionNo = value;
    }

    @Override
    public int getObjectType() {
        return 393218;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("Product/Name: attribute is required!");
        }
        if (this.versionNo == null) {
            throw new ValidationException("Product/VersionNo: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("Product/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("VersionNo");
            if (value == null) {
                throw new ValidationException("Product/VersionNo: attribute is required!");
            }
            this.versionNo = value;
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Product".equals(element.getNodeName())) {
            throw new ValidationException("Product: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("Product/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "VersionNo");
        if (value == null) {
            throw new ValidationException("Product/VersionNo: attribute is required!");
        }
        this.versionNo = value;
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Product");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.versionNo != null) {
            element.setAttribute("VersionNo", this.versionNo);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Product ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.versionNo != null) {
                strAttrs.append("VersionNo=\"").append(AbstractSchema.checkXMLContent(this.versionNo)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Product>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

