/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PopupMessage
extends AbstractSchema {
    public static final Integer ONCE = 0;
    public static final Integer EVERY_30_SECONDS = 1;
    public static final Integer EVERY_MINUTE = 2;
    public static final Integer EVERY_2_MINUTES = 3;
    public static final Integer EVERY_5_MINUTES = 4;
    public static final Integer EVERY_10_MINUTES = 5;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer interval;
    private String message;

    public PopupMessage() {
        this.nameSpace = "enforcer";
    }

    @Override
    public String getObjectTypeName() {
        return "PopupMessage";
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public String getIntervalValue() throws ValidationException {
        if (this.interval == null) {
            return null;
        }
        String s = null;
        switch (this.interval) {
            case 0: {
                s = "ONCE";
                break;
            }
            case 1: {
                s = "EVERY_30_SECONDS";
                break;
            }
            case 2: {
                s = "EVERY_MINUTE";
                break;
            }
            case 3: {
                s = "EVERY_2_MINUTES";
                break;
            }
            case 4: {
                s = "EVERY_5_MINUTES";
                break;
            }
            case 5: {
                s = "EVERY_10_MINUTES";
                break;
            }
            default: {
                throw new ValidationException("PopupMessage/Interval: invalid attribute value:" + this.interval + "!");
            }
        }
        return s;
    }

    public void setInterval(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.interval = value;
    }

    public void setIntervalValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ONCE".equals(value)) {
            this.interval = ONCE;
        } else if ("EVERY_30_SECONDS".equals(value)) {
            this.interval = EVERY_30_SECONDS;
        } else if ("EVERY_MINUTE".equals(value)) {
            this.interval = EVERY_MINUTE;
        } else if ("EVERY_2_MINUTES".equals(value)) {
            this.interval = EVERY_2_MINUTES;
        } else if ("EVERY_5_MINUTES".equals(value)) {
            this.interval = EVERY_5_MINUTES;
        } else if ("EVERY_10_MINUTES".equals(value)) {
            this.interval = EVERY_10_MINUTES;
        } else {
            throw new ValidationException("PopupMessage/Interval: invalid attribute value:" + value + "!");
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.message = value;
    }

    @Override
    public int getObjectType() {
        return 393240;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enable == null) {
            throw new ValidationException("PopupMessage/Enable: attribute is required!");
        }
        if (this.interval == null) {
            throw new ValidationException("PopupMessage/Interval: attribute is required!");
        }
        if (this.message == null) {
            throw new ValidationException("PopupMessage/Message: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value == null) {
                throw new ValidationException("PopupMessage/Enable: attribute is required!");
            }
            this.enable = "1".equals(value);
            value = attris.getValue("Interval");
            if (value == null) {
                throw new ValidationException("PopupMessage/Interval: attribute is required!");
            }
            this.setIntervalValue(value);
            value = attris.getValue("Message");
            if (value == null) {
                throw new ValidationException("PopupMessage/Message: attribute is required!");
            }
            this.message = value;
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"PopupMessage".equals(element.getNodeName())) {
            throw new ValidationException("PopupMessage: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value == null) {
            throw new ValidationException("PopupMessage/Enable: attribute is required!");
        }
        this.enable = "1".equals(value);
        value = XMLHelper.getAttribute(element, "Interval");
        if (value == null) {
            throw new ValidationException("PopupMessage/Interval: attribute is required!");
        }
        this.setIntervalValue(value);
        value = XMLHelper.getAttribute(element, "Message");
        if (value == null) {
            throw new ValidationException("PopupMessage/Message: attribute is required!");
        }
        this.message = value;
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("PopupMessage");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.interval != null) {
            element.setAttribute("Interval", this.getIntervalValue());
        }
        if (this.message != null) {
            element.setAttribute("Message", this.message);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PopupMessage ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.interval != null) {
                strAttrs.append("Interval=\"").append(this.getIntervalValue()).append("\" ");
            }
            if (this.message != null) {
                strAttrs.append("Message=\"").append(AbstractSchema.checkXMLContent(this.message)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PopupMessage>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

