/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HttpRedirect
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String url;
    private Integer port;

    public HttpRedirect() {
        this.nameSpace = "enforcer";
    }

    @Override
    public String getObjectTypeName() {
        return "HttpRedirect";
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.url = value;
    }

    public Integer getDefPort() {
        return 80;
    }

    public Integer getOptPort() {
        return this.port;
    }

    public void setOptPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    @Override
    public int getObjectType() {
        return 393241;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enable == null) {
            throw new ValidationException("HttpRedirect/Enable: attribute is required!");
        }
        if (this.url == null) {
            throw new ValidationException("HttpRedirect/Url: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block8: {
            try {
                String value = attris.getValue("Enable");
                if (value == null) {
                    throw new ValidationException("HttpRedirect/Enable: attribute is required!");
                }
                this.enable = "1".equals(value);
                value = attris.getValue("Url");
                if (value == null) {
                    throw new ValidationException("HttpRedirect/Url: attribute is required!");
                }
                this.url = value;
                value = attris.getValue("Port");
                if (value == null) break block8;
                try {
                    this.port = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("HttpRedirect/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("HttpRedirect/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"HttpRedirect".equals(element.getNodeName())) {
            throw new ValidationException("HttpRedirect: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value == null) {
            throw new ValidationException("HttpRedirect/Enable: attribute is required!");
        }
        this.enable = "1".equals(value);
        value = XMLHelper.getAttribute(element, "Url");
        if (value == null) {
            throw new ValidationException("HttpRedirect/Url: attribute is required!");
        }
        this.url = value;
        value = XMLHelper.getAttribute(element, "Port");
        if (value != null) {
            try {
                this.port = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("HttpRedirect/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("HttpRedirect");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.url != null) {
            element.setAttribute("Url", this.url);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HttpRedirect ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.url != null) {
                strAttrs.append("Url=\"").append(AbstractSchema.checkXMLContent(this.url)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HttpRedirect>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

