/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Failover
extends AbstractSchema {
    public static final Integer VERY_HIGH = 0;
    public static final Integer HIGH = 1;
    public static final Integer MEDIUM = 2;
    public static final Integer LOW = 3;
    public static final Integer VERY_LOW = 4;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Integer port;
    private Integer sensitiveLevel;

    public Failover() {
        this.nameSpace = "enforcer";
    }

    @Override
    public String getObjectTypeName() {
        return "Failover";
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public Integer getSensitiveLevel() {
        return this.sensitiveLevel;
    }

    public String getSensitiveLevelValue() throws ValidationException {
        if (this.sensitiveLevel == null) {
            return null;
        }
        String s = null;
        switch (this.sensitiveLevel) {
            case 0: {
                s = "VERY_HIGH";
                break;
            }
            case 1: {
                s = "HIGH";
                break;
            }
            case 2: {
                s = "MEDIUM";
                break;
            }
            case 3: {
                s = "LOW";
                break;
            }
            case 4: {
                s = "VERY_LOW";
                break;
            }
            default: {
                throw new ValidationException("Failover/SensitiveLevel: invalid attribute value:" + this.sensitiveLevel + "!");
            }
        }
        return s;
    }

    public void setSensitiveLevel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.sensitiveLevel = value;
    }

    public void setSensitiveLevelValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("VERY_HIGH".equals(value)) {
            this.sensitiveLevel = VERY_HIGH;
        } else if ("HIGH".equals(value)) {
            this.sensitiveLevel = HIGH;
        } else if ("MEDIUM".equals(value)) {
            this.sensitiveLevel = MEDIUM;
        } else if ("LOW".equals(value)) {
            this.sensitiveLevel = LOW;
        } else if ("VERY_LOW".equals(value)) {
            this.sensitiveLevel = VERY_LOW;
        } else {
            throw new ValidationException("Failover/SensitiveLevel: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 393228;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enable == null) {
            throw new ValidationException("Failover/Enable: attribute is required!");
        }
        if (this.port == null) {
            throw new ValidationException("Failover/Port: attribute is required!");
        }
        if (this.sensitiveLevel == null) {
            throw new ValidationException("Failover/SensitiveLevel: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value == null) {
                throw new ValidationException("Failover/Enable: attribute is required!");
            }
            this.enable = "1".equals(value);
            value = attris.getValue("Port");
            if (value == null) {
                throw new ValidationException("Failover/Port: attribute is required!");
            }
            try {
                this.port = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("Failover/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("Failover/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("SensitiveLevel");
            if (value == null) {
                throw new ValidationException("Failover/SensitiveLevel: attribute is required!");
            }
            this.setSensitiveLevelValue(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Failover".equals(element.getNodeName())) {
            throw new ValidationException("Failover: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value == null) {
            throw new ValidationException("Failover/Enable: attribute is required!");
        }
        this.enable = "1".equals(value);
        value = XMLHelper.getAttribute(element, "Port");
        if (value == null) {
            throw new ValidationException("Failover/Port: attribute is required!");
        }
        try {
            this.port = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Failover/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("Failover/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "SensitiveLevel");
        if (value == null) {
            throw new ValidationException("Failover/SensitiveLevel: attribute is required!");
        }
        this.setSensitiveLevelValue(value);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Failover");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.sensitiveLevel != null) {
            element.setAttribute("SensitiveLevel", this.getSensitiveLevelValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Failover ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.sensitiveLevel != null) {
                strAttrs.append("SensitiveLevel=\"").append(this.getSensitiveLevelValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Failover>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

