/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.enforcer.DhcpMacAddress;
import com.sygate.scm.common.configobject.enforcer.ImportedMacAddress;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DhcpTrustedMacList
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private Boolean enableHostLearning;

    public DhcpTrustedMacList() {
        this.nameSpace = "enforcer";
        this.children.put(393279, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(393288, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "DhcpTrustedMacList";
    }

    public Boolean getEnableHostLearning() {
        return this.enableHostLearning;
    }

    public void setEnableHostLearning(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enableHostLearning = value;
    }

    public void addDhcpMacAddress(DhcpMacAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDhcpMacAddress(int index, DhcpMacAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DhcpMacAddress> getDhcpMacAddress() {
        Vector<DhcpMacAddress> v = new Vector<DhcpMacAddress>();
        for (Transportable child : (ChildGroup)this.children.get(393279)) {
            v.add((DhcpMacAddress)child);
        }
        return v;
    }

    public int getDhcpMacAddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393279);
        return childGroup.size();
    }

    public DhcpMacAddress getDhcpMacAddress(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(393279);
        return (DhcpMacAddress)childGroup.get(index);
    }

    public void setDhcpMacAddress(int index, DhcpMacAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDhcpMacAddress(DhcpMacAddress value) {
        this.removeChild(value);
    }

    public ImportedMacAddress getOptImportedMacAddress() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393288);
        if (childGroup.size() > 0) {
            return (ImportedMacAddress)childGroup.get(0);
        }
        return null;
    }

    public void setOptImportedMacAddress(ImportedMacAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ImportedMacAddress obj = this.getOptImportedMacAddress();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 393277;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enableHostLearning == null) {
            throw new ValidationException("DhcpTrustedMacList/EnableHostLearning: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof DhcpMacAddress) {
            try {
                this.addDhcpMacAddress((DhcpMacAddress)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ImportedMacAddress) {
            try {
                this.setOptImportedMacAddress((ImportedMacAddress)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("EnableHostLearning");
            if (value == null) {
                throw new ValidationException("DhcpTrustedMacList/EnableHostLearning: attribute is required!");
            }
            this.enableHostLearning = "1".equals(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getDhcpMacAddressCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getDhcpMacAddress(i).setReadonly();
        }
        if (this.getOptImportedMacAddress() != null) {
            this.getOptImportedMacAddress().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DhcpTrustedMacList".equals(element.getNodeName())) {
            throw new ValidationException("DhcpTrustedMacList: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "EnableHostLearning");
        if (value == null) {
            throw new ValidationException("DhcpTrustedMacList/EnableHostLearning: attribute is required!");
        }
        this.enableHostLearning = "1".equals(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DhcpMacAddress");
        for (int i = 0; i < v.size(); ++i) {
            DhcpMacAddress dhcpMacAddressObj = new DhcpMacAddress();
            dhcpMacAddressObj.importFromElement(v.get(i));
            this.addDhcpMacAddress(dhcpMacAddressObj);
        }
        v = XMLHelper.getChildElementByName(element, "ImportedMacAddress");
        if (v.size() > 0) {
            ImportedMacAddress importedMacAddressObj = new ImportedMacAddress();
            importedMacAddressObj.importFromElement(v.get(0));
            this.setOptImportedMacAddress(importedMacAddressObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("DhcpTrustedMacList");
        if (this.enableHostLearning != null) {
            element.setAttribute("EnableHostLearning", this.enableHostLearning != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DhcpTrustedMacList ");
            if (this.enableHostLearning != null) {
                strAttrs.append("EnableHostLearning=").append(this.enableHostLearning != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DhcpTrustedMacList>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

