/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.enforcer;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.enforcer.LogSetting;
import com.sygate.scm.common.configobject.enforcer.NtpSetting;
import com.sygate.scm.common.configobject.enforcer.SEPMHealthCheck;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CommonProfile
extends AbstractSchema {
    public static final Integer GATEWAY_ENFORCER = 0;
    public static final Integer LAN_ENFORCER = 1;
    public static final Integer DHCP_ENFORCER = 2;
    public static final Integer INTEGRATED_ENFORCER = 3;
    public static final Integer NAP_ENFORCER = 4;
    private static final long serialVersionUID = 1L;
    private String screenName;
    private String description;
    private Integer runningMode;
    private Integer seatNumber;

    public CommonProfile() {
        this.nameSpace = "enforcer";
        this.children.put(393221, new ChildGroup(1, 1));
        this.children.put(393225, new ChildGroup(0, 1));
        this.children.put(393226, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "CommonProfile";
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.screenName = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.description = value;
    }

    public Integer getRunningMode() {
        return this.runningMode;
    }

    public String getRunningModeValue() throws ValidationException {
        if (this.runningMode == null) {
            return null;
        }
        String s = null;
        switch (this.runningMode) {
            case 0: {
                s = "GATEWAY_ENFORCER";
                break;
            }
            case 1: {
                s = "LAN_ENFORCER";
                break;
            }
            case 2: {
                s = "DHCP_ENFORCER";
                break;
            }
            case 3: {
                s = "INTEGRATED_ENFORCER";
                break;
            }
            case 4: {
                s = "NAP_ENFORCER";
                break;
            }
            default: {
                throw new ValidationException("CommonProfile/RunningMode: invalid attribute value:" + this.runningMode + "!");
            }
        }
        return s;
    }

    public void setRunningMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.runningMode = value;
    }

    public void setRunningModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("GATEWAY_ENFORCER".equals(value)) {
            this.runningMode = GATEWAY_ENFORCER;
        } else if ("LAN_ENFORCER".equals(value)) {
            this.runningMode = LAN_ENFORCER;
        } else if ("DHCP_ENFORCER".equals(value)) {
            this.runningMode = DHCP_ENFORCER;
        } else if ("INTEGRATED_ENFORCER".equals(value)) {
            this.runningMode = INTEGRATED_ENFORCER;
        } else if ("NAP_ENFORCER".equals(value)) {
            this.runningMode = NAP_ENFORCER;
        } else {
            throw new ValidationException("CommonProfile/RunningMode: invalid attribute value:" + value + "!");
        }
    }

    public Integer getSeatNumber() {
        return this.seatNumber;
    }

    public void setSeatNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.seatNumber = value;
    }

    public LogSetting getLogSetting() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393221);
        if (childGroup.size() > 0) {
            return (LogSetting)childGroup.get(0);
        }
        return null;
    }

    public void setLogSetting(LogSetting value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            LogSetting obj = this.getLogSetting();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public NtpSetting getOptNtpSetting() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393225);
        if (childGroup.size() > 0) {
            return (NtpSetting)childGroup.get(0);
        }
        return null;
    }

    public void setOptNtpSetting(NtpSetting value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NtpSetting obj = this.getOptNtpSetting();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SEPMHealthCheck getOptSEPMHealthCheck() {
        ChildGroup childGroup = (ChildGroup)this.children.get(393226);
        if (childGroup.size() > 0) {
            return (SEPMHealthCheck)childGroup.get(0);
        }
        return null;
    }

    public void setOptSEPMHealthCheck(SEPMHealthCheck value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SEPMHealthCheck obj = this.getOptSEPMHealthCheck();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 393220;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.screenName == null) {
            throw new ValidationException("CommonProfile/ScreenName: attribute is required!");
        }
        if (this.runningMode == null) {
            throw new ValidationException("CommonProfile/RunningMode: attribute is required!");
        }
        if (this.seatNumber == null) {
            throw new ValidationException("CommonProfile/SeatNumber: attribute is required!");
        }
        if (this.getLogSetting() == null) {
            throw new ValidationException("CommonProfile/LogSetting: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof LogSetting) {
            try {
                this.setLogSetting((LogSetting)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof NtpSetting) {
            try {
                this.setOptNtpSetting((NtpSetting)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SEPMHealthCheck) {
            try {
                this.setOptSEPMHealthCheck((SEPMHealthCheck)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ScreenName");
            if (value == null) {
                throw new ValidationException("CommonProfile/ScreenName: attribute is required!");
            }
            this.screenName = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("RunningMode")) == null) {
                throw new ValidationException("CommonProfile/RunningMode: attribute is required!");
            }
            this.setRunningModeValue(value);
            value = attris.getValue("SeatNumber");
            if (value == null) {
                throw new ValidationException("CommonProfile/SeatNumber: attribute is required!");
            }
            try {
                this.seatNumber = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("CommonProfile/SeatNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("CommonProfile/SeatNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getLogSetting() != null) {
            this.getLogSetting().setReadonly();
        }
        if (this.getOptNtpSetting() != null) {
            this.getOptNtpSetting().setReadonly();
        }
        if (this.getOptSEPMHealthCheck() != null) {
            this.getOptSEPMHealthCheck().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(393221)).size();
        }
        catch (Throwable t) {
            throw new SAXException("CommonProfile: can't import element == LogSetting!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"CommonProfile".equals(element.getNodeName())) {
            throw new ValidationException("CommonProfile: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ScreenName");
        if (value == null) {
            throw new ValidationException("CommonProfile/ScreenName: attribute is required!");
        }
        this.screenName = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RunningMode")) == null) {
            throw new ValidationException("CommonProfile/RunningMode: attribute is required!");
        }
        this.setRunningModeValue(value);
        value = XMLHelper.getAttribute(element, "SeatNumber");
        if (value == null) {
            throw new ValidationException("CommonProfile/SeatNumber: attribute is required!");
        }
        try {
            this.seatNumber = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("CommonProfile/SeatNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("CommonProfile/SeatNumber: invalid attribute value:" + value + "! " + e.getMessage());
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "LogSetting");
        if (v.size() != 1) {
            throw new ValidationException("CommonProfile/LogSetting: element is require!");
        }
        LogSetting logSettingObj = new LogSetting();
        logSettingObj.importFromElement(v.get(0));
        this.setLogSetting(logSettingObj);
        v = XMLHelper.getChildElementByName(element, "NtpSetting");
        if (v.size() > 0) {
            NtpSetting ntpSettingObj = new NtpSetting();
            ntpSettingObj.importFromElement(v.get(0));
            this.setOptNtpSetting(ntpSettingObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SEPMHealthCheck")).size() > 0) {
            SEPMHealthCheck sEPMHealthCheckObj = new SEPMHealthCheck();
            sEPMHealthCheckObj.importFromElement(v.get(0));
            this.setOptSEPMHealthCheck(sEPMHealthCheckObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("CommonProfile");
        if (this.screenName != null) {
            element.setAttribute("ScreenName", this.screenName);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.runningMode != null) {
            element.setAttribute("RunningMode", this.getRunningModeValue());
        }
        if (this.seatNumber != null) {
            element.setAttribute("SeatNumber", this.seatNumber.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<CommonProfile ");
            if (this.screenName != null) {
                strAttrs.append("ScreenName=\"").append(AbstractSchema.checkXMLContent(this.screenName)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.runningMode != null) {
                strAttrs.append("RunningMode=\"").append(this.getRunningModeValue()).append("\" ");
            }
            if (this.seatNumber != null) {
                strAttrs.append("SeatNumber=\"").append(this.seatNumber.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</CommonProfile>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

