/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UnknownContent
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private byte[] content;

    @Override
    public String getObjectTypeName() {
        return "UnkownContent";
    }

    public byte[] getContent() {
        return this.content == null ? null : (byte[])this.content.clone();
    }

    public void setConent(byte[] content) {
        this.content = content == null ? null : (byte[])content.clone();
    }

    @Override
    public int getObjectType() {
        return 327681;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.content == null) {
            throw new ValidationException("UnknownContent: content is required!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"UnknownContent".equals(element.getNodeName())) {
            throw new ValidationException("UnknownContent: can't import element(" + element.getNodeName() + ")!");
        }
        Element child = XMLHelper.getFirstChildElement(element);
        if (child == null) {
            throw new ValidationException("UnknownContent: child element is required!");
        }
        try {
            Document doc = XMLHelper.newDocument();
            doc.appendChild(XMLHelper.cloneElement(doc, child));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLHelper.serialize(doc, bos);
            bos.close();
            this.content = bos.toByteArray();
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("UnknownContent");
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.content);
            Document newDoc = XMLHelper.parse(bis);
            bis.close();
            Element root = newDoc.getDocumentElement();
            element.appendChild(XMLHelper.cloneElement(doc, root));
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
        catch (SAXException e) {
            throw new ValidationException("UnknownContent: invalid content!");
        }
        return element;
    }

    @Override
    public void initByAttributes(Attributes attributes) throws SAXException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void putTextContent(String content) throws SAXException {
    }

    @Override
    public void doSerialize(OutputStream os) throws ValidationException {
        try {
            os.write("<UnknownContent>".getBytes("UTF-8"));
            if (this.content != null) {
                XMLHelper.serialize(os, AbstractSchema.readXML(this.content), true);
            }
            os.write("</UnknownContent>".getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
        catch (SAXException saxe) {
            throw new ValidationException(saxe.getMessage());
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }
}

