/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubNet
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private String netAddr;
    private String netMask;
    private Boolean include;

    public SubNet() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "SubNet";
    }

    public String getNetAddr() {
        return this.netAddr;
    }

    public void setNetAddr(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.netAddr = value;
    }

    public String getNetMask() {
        return this.netMask;
    }

    public void setNetMask(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.netMask = value;
    }

    public Boolean getDefInclude() {
        return Boolean.TRUE;
    }

    public Boolean getOptInclude() {
        return this.include;
    }

    public void setOptInclude(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.include = value;
    }

    @Override
    public int getObjectType() {
        return 328063;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.netAddr == null) {
            throw new ValidationException("SubNet/NetAddr: attribute is required!");
        }
        if (this.netMask == null) {
            throw new ValidationException("SubNet/NetMask: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("NetAddr");
            if (value == null) {
                throw new ValidationException("SubNet/NetAddr: attribute is required!");
            }
            this.netAddr = value;
            value = attris.getValue("NetMask");
            if (value == null) {
                throw new ValidationException("SubNet/NetMask: attribute is required!");
            }
            this.netMask = value;
            value = attris.getValue("Include");
            if (value != null) {
                this.include = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SubNet".equals(element.getNodeName())) {
            throw new ValidationException("SubNet: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "NetAddr");
        if (value == null) {
            throw new ValidationException("SubNet/NetAddr: attribute is required!");
        }
        this.netAddr = value;
        value = XMLHelper.getAttribute(element, "NetMask");
        if (value == null) {
            throw new ValidationException("SubNet/NetMask: attribute is required!");
        }
        this.netMask = value;
        value = XMLHelper.getAttribute(element, "Include");
        if (value != null) {
            this.include = "1".equals(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SubNet");
        if (this.netAddr != null) {
            element.setAttribute("NetAddr", this.netAddr);
        }
        if (this.netMask != null) {
            element.setAttribute("NetMask", this.netMask);
        }
        if (this.include != null) {
            element.setAttribute("Include", this.include != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SubNet ");
            if (this.netAddr != null) {
                strAttrs.append("NetAddr=\"").append(AbstractSchema.checkXMLContent(this.netAddr)).append("\" ");
            }
            if (this.netMask != null) {
                strAttrs.append("NetMask=\"").append(AbstractSchema.checkXMLContent(this.netMask)).append("\" ");
            }
            if (this.include != null) {
                strAttrs.append("Include=").append(this.include != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SubNet>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

