/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StorageMigration
extends AbstractSchema {
    public static final Integer ACCESSED = 0;
    public static final Integer MODIFIED = 1;
    public static final Integer CREATED = 2;
    private static final long serialVersionUID = 1L;
    private Long migrationOption;
    private Boolean backupSemantics;
    private Integer accessType;
    private Long accessWindow;

    public StorageMigration() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "StorageMigration";
    }

    public Long getDefMigrationOption() {
        return 0x400000L;
    }

    public Long getOptMigrationOption() {
        return this.migrationOption;
    }

    public void setOptMigrationOption(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.migrationOption = value;
    }

    public Boolean getDefBackupSemantics() {
        return Boolean.FALSE;
    }

    public Boolean getOptBackupSemantics() {
        return this.backupSemantics;
    }

    public void setOptBackupSemantics(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.backupSemantics = value;
    }

    public Integer getDefAccessType() {
        return ACCESSED;
    }

    public Integer getOptAccessType() {
        return this.accessType;
    }

    public String getOptAccessTypeValue() throws ValidationException {
        if (this.accessType == null) {
            return null;
        }
        String s = null;
        switch (this.accessType) {
            case 0: {
                s = "ACCESSED";
                break;
            }
            case 1: {
                s = "MODIFIED";
                break;
            }
            case 2: {
                s = "CREATED";
                break;
            }
            default: {
                throw new ValidationException("StorageMigration/AccessType: invalid attribute value:" + this.accessType + "!");
            }
        }
        return s;
    }

    public void setOptAccessType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.accessType = value;
    }

    public void setOptAccessTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.accessType = null;
            return;
        }
        if ("ACCESSED".equals(value)) {
            this.accessType = ACCESSED;
        } else if ("MODIFIED".equals(value)) {
            this.accessType = MODIFIED;
        } else if ("CREATED".equals(value)) {
            this.accessType = CREATED;
        } else {
            throw new ValidationException("StorageMigration/AccessType: invalid attribute value:" + value + "!");
        }
    }

    public Long getDefAccessWindow() {
        return 30L;
    }

    public Long getOptAccessWindow() {
        return this.accessWindow;
    }

    public void setOptAccessWindow(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.accessWindow = value;
    }

    @Override
    public int getObjectType() {
        return 327947;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block12: {
            try {
                String value = attris.getValue("MigrationOption");
                if (value != null) {
                    try {
                        this.migrationOption = Long.valueOf(value);
                    }
                    catch (RuntimeException e) {
                        throw new ValidationException("StorageMigration/MigrationOption: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ValidationException("StorageMigration/MigrationOption: invalid attribute value:" + value + "! " + e.getMessage());
                    }
                }
                if ((value = attris.getValue("BackupSemantics")) != null) {
                    this.backupSemantics = "1".equals(value);
                }
                if ((value = attris.getValue("AccessType")) != null) {
                    this.setOptAccessTypeValue(value);
                }
                if ((value = attris.getValue("AccessWindow")) == null) break block12;
                try {
                    this.accessWindow = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("StorageMigration/AccessWindow: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("StorageMigration/AccessWindow: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"StorageMigration".equals(element.getNodeName())) {
            throw new ValidationException("StorageMigration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "MigrationOption");
        if (value != null) {
            try {
                this.migrationOption = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("StorageMigration/MigrationOption: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "BackupSemantics")) != null) {
            this.backupSemantics = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AccessType")) != null) {
            this.setOptAccessTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AccessWindow")) != null) {
            try {
                this.accessWindow = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("StorageMigration/AccessWindow: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("StorageMigration");
        if (this.migrationOption != null) {
            element.setAttribute("MigrationOption", this.migrationOption.toString());
        }
        if (this.backupSemantics != null) {
            element.setAttribute("BackupSemantics", this.backupSemantics != false ? "1" : "0");
        }
        if (this.accessType != null) {
            element.setAttribute("AccessType", this.getOptAccessTypeValue());
        }
        if (this.accessWindow != null) {
            element.setAttribute("AccessWindow", this.accessWindow.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<StorageMigration ");
            if (this.migrationOption != null) {
                strAttrs.append("MigrationOption=\"").append(this.migrationOption.toString()).append("\" ");
            }
            if (this.backupSemantics != null) {
                strAttrs.append("BackupSemantics=").append(this.backupSemantics != false ? "\"1\" " : "\"0\" ");
            }
            if (this.accessType != null) {
                strAttrs.append("AccessType=\"").append(this.getOptAccessTypeValue()).append("\" ");
            }
            if (this.accessWindow != null) {
                strAttrs.append("AccessWindow=\"").append(this.accessWindow.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</StorageMigration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

