/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SharedInsightCache
extends AbstractSchema {
    public static final Integer NONE = 0;
    public static final Integer CLIENT_SIDE = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private Boolean enabledvSIC;
    private Boolean requireSSL;
    private String hostName;
    private Integer port;
    private String username;
    private String password;
    private Integer encrypt;

    public SharedInsightCache() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "SharedInsightCache";
    }

    public Boolean getDefEnabled() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enabled = value;
    }

    public Boolean getDefEnabledvSIC() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnabledvSIC() {
        return this.enabledvSIC;
    }

    public void setOptEnabledvSIC(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enabledvSIC = value;
    }

    public Boolean getDefRequireSSL() {
        return Boolean.FALSE;
    }

    public Boolean getOptRequireSSL() {
        return this.requireSSL;
    }

    public void setOptRequireSSL(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.requireSSL = value;
    }

    public String getDefHostName() {
        return "";
    }

    public String getOptHostName() {
        return this.hostName;
    }

    public void setOptHostName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.hostName = value;
    }

    public Integer getDefPort() {
        return 9005;
    }

    public Integer getOptPort() {
        return this.port;
    }

    public void setOptPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public String getOptUsername() {
        return this.username;
    }

    public void setOptUsername(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.username = value;
    }

    public String getOptPassword() {
        return this.password;
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.password = value;
    }

    public Integer getDefEncrypt() {
        return CLIENT_SIDE;
    }

    public Integer getOptEncrypt() {
        return this.encrypt;
    }

    public String getOptEncryptValue() throws ValidationException {
        if (this.encrypt == null) {
            return null;
        }
        String s = null;
        switch (this.encrypt) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "CLIENT_SIDE";
                break;
            }
            default: {
                throw new ValidationException("SharedInsightCache/Encrypt: invalid attribute value:" + this.encrypt + "!");
            }
        }
        return s;
    }

    public void setOptEncrypt(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.encrypt = value;
    }

    public void setOptEncryptValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.encrypt = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.encrypt = NONE;
        } else if ("CLIENT_SIDE".equals(value)) {
            this.encrypt = CLIENT_SIDE;
        } else {
            throw new ValidationException("SharedInsightCache/Encrypt: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 327932;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("EnabledvSIC")) != null) {
                this.enabledvSIC = "1".equals(value);
            }
            if ((value = attris.getValue("RequireSSL")) != null) {
                this.requireSSL = "1".equals(value);
            }
            if ((value = attris.getValue("HostName")) != null) {
                this.hostName = value;
            }
            if ((value = attris.getValue("Port")) != null) {
                try {
                    this.port = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("SharedInsightCache/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("SharedInsightCache/Port: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Username")) != null) {
                this.username = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("Encrypt")) != null) {
                this.setOptEncryptValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SharedInsightCache".equals(element.getNodeName())) {
            throw new ValidationException("SharedInsightCache: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnabledvSIC")) != null) {
            this.enabledvSIC = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RequireSSL")) != null) {
            this.requireSSL = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HostName")) != null) {
            this.hostName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            try {
                this.port = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("SharedInsightCache/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Username")) != null) {
            this.username = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Encrypt")) != null) {
            this.setOptEncryptValue(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("SharedInsightCache");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.enabledvSIC != null) {
            element.setAttribute("EnabledvSIC", this.enabledvSIC != false ? "1" : "0");
        }
        if (this.requireSSL != null) {
            element.setAttribute("RequireSSL", this.requireSSL != false ? "1" : "0");
        }
        if (this.hostName != null) {
            element.setAttribute("HostName", this.hostName);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.username != null) {
            element.setAttribute("Username", this.username);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.encrypt != null) {
            element.setAttribute("Encrypt", this.getOptEncryptValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<SharedInsightCache ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enabledvSIC != null) {
                strAttrs.append("EnabledvSIC=").append(this.enabledvSIC != false ? "\"1\" " : "\"0\" ");
            }
            if (this.requireSSL != null) {
                strAttrs.append("RequireSSL=").append(this.requireSSL != false ? "\"1\" " : "\"0\" ");
            }
            if (this.hostName != null) {
                strAttrs.append("HostName=\"").append(AbstractSchema.checkXMLContent(this.hostName)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.username != null) {
                strAttrs.append("Username=\"").append(AbstractSchema.checkXMLContent(this.username)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.encrypt != null) {
                strAttrs.append("Encrypt=\"").append(this.getOptEncryptValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</SharedInsightCache>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

