/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RegistryValue
extends AbstractSchema {
    public static final Integer REG_STRING = 0;
    public static final Integer REG_DWORD = 1;
    public static final Integer REG_BINARY = 2;
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer type;
    private String operation;
    private String content;

    public RegistryValue() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "RegistryValue";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public Integer getOptType() {
        return this.type;
    }

    public String getOptTypeValue() throws ValidationException {
        if (this.type == null) {
            return null;
        }
        String s = null;
        switch (this.type) {
            case 0: {
                s = "REG_STRING";
                break;
            }
            case 1: {
                s = "REG_DWORD";
                break;
            }
            case 2: {
                s = "REG_BINARY";
                break;
            }
            default: {
                throw new ValidationException("RegistryValue/Type: invalid attribute value:" + this.type + "!");
            }
        }
        return s;
    }

    public void setOptType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.type = value;
    }

    public void setOptTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.type = null;
            return;
        }
        if ("REG_STRING".equals(value)) {
            this.type = REG_STRING;
        } else if ("REG_DWORD".equals(value)) {
            this.type = REG_DWORD;
        } else if ("REG_BINARY".equals(value)) {
            this.type = REG_BINARY;
        } else {
            throw new ValidationException("RegistryValue/Type: invalid attribute value:" + value + "!");
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operation = value;
    }

    public String getOptContent() {
        return this.content;
    }

    public void setOptContent(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.content = value;
    }

    @Override
    public int getObjectType() {
        return 327737;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("RegistryValue/Name: attribute is required!");
        }
        if (this.operation == null) {
            throw new ValidationException("RegistryValue/Operation: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
        this.content = tContent;
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("RegistryValue/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Type");
            if (value != null) {
                this.setOptTypeValue(value);
            }
            if ((value = attris.getValue("Operation")) == null) {
                throw new ValidationException("RegistryValue/Operation: attribute is required!");
            }
            this.operation = value;
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"RegistryValue".equals(element.getNodeName())) {
            throw new ValidationException("RegistryValue: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("RegistryValue/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Type");
        if (value != null) {
            this.setOptTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Operation")) == null) {
            throw new ValidationException("RegistryValue/Operation: attribute is required!");
        }
        this.operation = value;
        Node childTextNode = XMLHelper.getTextNode(element);
        if (childTextNode != null) {
            this.content = childTextNode.getNodeValue();
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("RegistryValue");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.type != null) {
            element.setAttribute("Type", this.getOptTypeValue());
        }
        if (this.operation != null) {
            element.setAttribute("Operation", this.operation);
        }
        if (this.content != null) {
            Text n = doc.createTextNode(this.content);
            element.appendChild(n);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RegistryValue ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.getOptTypeValue()).append("\" ");
            }
            if (this.operation != null) {
                strAttrs.append("Operation=\"").append(AbstractSchema.checkXMLContent(this.operation)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            StringBuffer strSimple = new StringBuffer(">");
            if (this.content != null) {
                strSimple.append(AbstractSchema.checkXMLContent(this.content));
                strSimple.append("</RegistryValue>");
                os_for_xml_generating.write(strSimple.toString().getBytes("UTF-8"));
                return;
            }
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RegistryValue>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

