/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.RegistryKey;
import com.sygate.scm.common.configobject.agent.RegistryValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RegistryEntry
extends AbstractSchema {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;

    public RegistryEntry() {
        this.nameSpace = "agent";
        this.children.put(327736, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(327737, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "RegistryEntry";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("RegistryEntry/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("RegistryEntry/Operator: invalid attribute value:" + value + "!");
        }
    }

    public void addRegistryKey(RegistryKey value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRegistryKey(int index, RegistryKey value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RegistryKey> getRegistryKey() {
        Vector<RegistryKey> v = new Vector<RegistryKey>();
        for (Transportable child : (ChildGroup)this.children.get(327736)) {
            v.add((RegistryKey)child);
        }
        return v;
    }

    public int getRegistryKeyCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327736);
        return childGroup.size();
    }

    public RegistryKey getRegistryKey(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(327736);
        return (RegistryKey)childGroup.get(index);
    }

    public void setRegistryKey(int index, RegistryKey value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRegistryKey(RegistryKey value) {
        this.removeChild(value);
    }

    public void addRegistryValue(RegistryValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addRegistryValue(int index, RegistryValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<RegistryValue> getRegistryValue() {
        Vector<RegistryValue> v = new Vector<RegistryValue>();
        for (Transportable child : (ChildGroup)this.children.get(327737)) {
            v.add((RegistryValue)child);
        }
        return v;
    }

    public int getRegistryValueCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327737);
        return childGroup.size();
    }

    public RegistryValue getRegistryValue(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(327737);
        return (RegistryValue)childGroup.get(index);
    }

    public void setRegistryValue(int index, RegistryValue value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeRegistryValue(RegistryValue value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 327735;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof RegistryKey) {
            try {
                this.addRegistryKey((RegistryKey)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof RegistryValue) {
            try {
                this.addRegistryValue((RegistryValue)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getRegistryKeyCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRegistryKey(i).setReadonly();
        }
        objCnt = this.getRegistryValueCount();
        for (i = 0; i < objCnt; ++i) {
            this.getRegistryValue(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"RegistryEntry".equals(element.getNodeName())) {
            throw new ValidationException("RegistryEntry: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "RegistryKey");
        for (i = 0; i < v.size(); ++i) {
            RegistryKey registryKeyObj = new RegistryKey();
            registryKeyObj.importFromElement(v.get(i));
            this.addRegistryKey(registryKeyObj);
        }
        v = XMLHelper.getChildElementByName(element, "RegistryValue");
        for (i = 0; i < v.size(); ++i) {
            RegistryValue registryValueObj = new RegistryValue();
            registryValueObj.importFromElement(v.get(i));
            this.addRegistryValue(registryValueObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("RegistryEntry");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<RegistryEntry ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</RegistryEntry>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

