/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProtectionTargetSettings
extends AbstractSchema {
    public static final Integer DISABLED = 0;
    public static final Integer ENABLED = 1;
    public static final Integer LOG_ONLY = 2;
    public static final Integer BLOCK_WITHOUT_LOG = 3;
    public static final Integer ADMIN = 0;
    public static final Integer USER = 1;
    private static final long serialVersionUID = 1L;
    private Integer protectionLevel;
    private Boolean lockProtectionLevel;
    private Integer applyModeProtectionLevel;
    private Boolean displayMessage;
    private Boolean lockDisplayMessage;
    private Integer applyModeDisplayMessage;

    public ProtectionTargetSettings() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "ProtectionTargetSettings";
    }

    public Integer getDefProtectionLevel() {
        return BLOCK_WITHOUT_LOG;
    }

    public Integer getOptProtectionLevel() {
        return this.protectionLevel;
    }

    public String getOptProtectionLevelValue() throws ValidationException {
        if (this.protectionLevel == null) {
            return null;
        }
        String s = null;
        switch (this.protectionLevel) {
            case 0: {
                s = "DISABLED";
                break;
            }
            case 1: {
                s = "ENABLED";
                break;
            }
            case 2: {
                s = "LOG_ONLY";
                break;
            }
            case 3: {
                s = "BLOCK_WITHOUT_LOG";
                break;
            }
            default: {
                throw new ValidationException("ProtectionTargetSettings/ProtectionLevel: invalid attribute value:" + this.protectionLevel + "!");
            }
        }
        return s;
    }

    public void setOptProtectionLevel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.protectionLevel = value;
    }

    public void setOptProtectionLevelValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.protectionLevel = null;
            return;
        }
        if ("DISABLED".equals(value)) {
            this.protectionLevel = DISABLED;
        } else if ("ENABLED".equals(value)) {
            this.protectionLevel = ENABLED;
        } else if ("LOG_ONLY".equals(value)) {
            this.protectionLevel = LOG_ONLY;
        } else if ("BLOCK_WITHOUT_LOG".equals(value)) {
            this.protectionLevel = BLOCK_WITHOUT_LOG;
        } else {
            throw new ValidationException("ProtectionTargetSettings/ProtectionLevel: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockProtectionLevel() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockProtectionLevel() {
        return this.lockProtectionLevel;
    }

    public void setOptLockProtectionLevel(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockProtectionLevel = value;
    }

    public Integer getDefApplyModeProtectionLevel() {
        return ADMIN;
    }

    public Integer getOptApplyModeProtectionLevel() {
        return this.applyModeProtectionLevel;
    }

    public String getOptApplyModeProtectionLevelValue() throws ValidationException {
        if (this.applyModeProtectionLevel == null) {
            return null;
        }
        String s = null;
        switch (this.applyModeProtectionLevel) {
            case 0: {
                s = "ADMIN";
                break;
            }
            case 1: {
                s = "USER";
                break;
            }
            default: {
                throw new ValidationException("ProtectionTargetSettings/ApplyModeProtectionLevel: invalid attribute value:" + this.applyModeProtectionLevel + "!");
            }
        }
        return s;
    }

    public void setOptApplyModeProtectionLevel(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.applyModeProtectionLevel = value;
    }

    public void setOptApplyModeProtectionLevelValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.applyModeProtectionLevel = null;
            return;
        }
        if ("ADMIN".equals(value)) {
            this.applyModeProtectionLevel = ADMIN;
        } else if ("USER".equals(value)) {
            this.applyModeProtectionLevel = USER;
        } else {
            throw new ValidationException("ProtectionTargetSettings/ApplyModeProtectionLevel: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefDisplayMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptDisplayMessage() {
        return this.displayMessage;
    }

    public void setOptDisplayMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.displayMessage = value;
    }

    public Boolean getDefLockDisplayMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockDisplayMessage() {
        return this.lockDisplayMessage;
    }

    public void setOptLockDisplayMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockDisplayMessage = value;
    }

    public Integer getDefApplyModeDisplayMessage() {
        return ADMIN;
    }

    public Integer getOptApplyModeDisplayMessage() {
        return this.applyModeDisplayMessage;
    }

    public String getOptApplyModeDisplayMessageValue() throws ValidationException {
        if (this.applyModeDisplayMessage == null) {
            return null;
        }
        String s = null;
        switch (this.applyModeDisplayMessage) {
            case 0: {
                s = "ADMIN";
                break;
            }
            case 1: {
                s = "USER";
                break;
            }
            default: {
                throw new ValidationException("ProtectionTargetSettings/ApplyModeDisplayMessage: invalid attribute value:" + this.applyModeDisplayMessage + "!");
            }
        }
        return s;
    }

    public void setOptApplyModeDisplayMessage(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.applyModeDisplayMessage = value;
    }

    public void setOptApplyModeDisplayMessageValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.applyModeDisplayMessage = null;
            return;
        }
        if ("ADMIN".equals(value)) {
            this.applyModeDisplayMessage = ADMIN;
        } else if ("USER".equals(value)) {
            this.applyModeDisplayMessage = USER;
        } else {
            throw new ValidationException("ProtectionTargetSettings/ApplyModeDisplayMessage: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 328180;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ProtectionLevel");
            if (value != null) {
                this.setOptProtectionLevelValue(value);
            }
            if ((value = attris.getValue("LockProtectionLevel")) != null) {
                this.lockProtectionLevel = "1".equals(value);
            }
            if ((value = attris.getValue("ApplyModeProtectionLevel")) != null) {
                this.setOptApplyModeProtectionLevelValue(value);
            }
            if ((value = attris.getValue("DisplayMessage")) != null) {
                this.displayMessage = "1".equals(value);
            }
            if ((value = attris.getValue("LockDisplayMessage")) != null) {
                this.lockDisplayMessage = "1".equals(value);
            }
            if ((value = attris.getValue("ApplyModeDisplayMessage")) != null) {
                this.setOptApplyModeDisplayMessageValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"ProtectionTargetSettings".equals(element.getNodeName())) {
            throw new ValidationException("ProtectionTargetSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ProtectionLevel");
        if (value != null) {
            this.setOptProtectionLevelValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockProtectionLevel")) != null) {
            this.lockProtectionLevel = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ApplyModeProtectionLevel")) != null) {
            this.setOptApplyModeProtectionLevelValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisplayMessage")) != null) {
            this.displayMessage = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockDisplayMessage")) != null) {
            this.lockDisplayMessage = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ApplyModeDisplayMessage")) != null) {
            this.setOptApplyModeDisplayMessageValue(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ProtectionTargetSettings");
        if (this.protectionLevel != null) {
            element.setAttribute("ProtectionLevel", this.getOptProtectionLevelValue());
        }
        if (this.lockProtectionLevel != null) {
            element.setAttribute("LockProtectionLevel", this.lockProtectionLevel != false ? "1" : "0");
        }
        if (this.applyModeProtectionLevel != null) {
            element.setAttribute("ApplyModeProtectionLevel", this.getOptApplyModeProtectionLevelValue());
        }
        if (this.displayMessage != null) {
            element.setAttribute("DisplayMessage", this.displayMessage != false ? "1" : "0");
        }
        if (this.lockDisplayMessage != null) {
            element.setAttribute("LockDisplayMessage", this.lockDisplayMessage != false ? "1" : "0");
        }
        if (this.applyModeDisplayMessage != null) {
            element.setAttribute("ApplyModeDisplayMessage", this.getOptApplyModeDisplayMessageValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ProtectionTargetSettings ");
            if (this.protectionLevel != null) {
                strAttrs.append("ProtectionLevel=\"").append(this.getOptProtectionLevelValue()).append("\" ");
            }
            if (this.lockProtectionLevel != null) {
                strAttrs.append("LockProtectionLevel=").append(this.lockProtectionLevel != false ? "\"1\" " : "\"0\" ");
            }
            if (this.applyModeProtectionLevel != null) {
                strAttrs.append("ApplyModeProtectionLevel=\"").append(this.getOptApplyModeProtectionLevelValue()).append("\" ");
            }
            if (this.displayMessage != null) {
                strAttrs.append("DisplayMessage=").append(this.displayMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockDisplayMessage != null) {
                strAttrs.append("LockDisplayMessage=").append(this.lockDisplayMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.applyModeDisplayMessage != null) {
                strAttrs.append("ApplyModeDisplayMessage=\"").append(this.getOptApplyModeDisplayMessageValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ProtectionTargetSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

