/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PrivateInsightServer
extends AbstractSchema {
    public static final Integer HTTP = 0;
    public static final Integer HTTPS = 1;
    private static final long serialVersionUID = 1L;
    private String address;
    private String edrConnectToken;
    private Integer port;
    private Integer protocol;
    private Boolean httpsVerifyCA;
    private Boolean legacyClientSupport;

    public PrivateInsightServer() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "PrivateInsightServer";
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.address = value;
    }

    public String getOptEdrConnectToken() {
        return this.edrConnectToken;
    }

    public void setOptEdrConnectToken(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.edrConnectToken = value;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public Integer getDefProtocol() {
        return HTTP;
    }

    public Integer getOptProtocol() {
        return this.protocol;
    }

    public String getOptProtocolValue() throws ValidationException {
        if (this.protocol == null) {
            return null;
        }
        String s = null;
        switch (this.protocol) {
            case 0: {
                s = "HTTP";
                break;
            }
            case 1: {
                s = "HTTPS";
                break;
            }
            default: {
                throw new ValidationException("PrivateInsightServer/Protocol: invalid attribute value:" + this.protocol + "!");
            }
        }
        return s;
    }

    public void setOptProtocol(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.protocol = value;
    }

    public void setOptProtocolValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.protocol = null;
            return;
        }
        if ("HTTP".equals(value)) {
            this.protocol = HTTP;
        } else if ("HTTPS".equals(value)) {
            this.protocol = HTTPS;
        } else {
            throw new ValidationException("PrivateInsightServer/Protocol: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefHttpsVerifyCA() {
        return Boolean.FALSE;
    }

    public Boolean getOptHttpsVerifyCA() {
        return this.httpsVerifyCA;
    }

    public void setOptHttpsVerifyCA(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.httpsVerifyCA = value;
    }

    public Boolean getDefLegacyClientSupport() {
        return Boolean.FALSE;
    }

    public Boolean getOptLegacyClientSupport() {
        return this.legacyClientSupport;
    }

    public void setOptLegacyClientSupport(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.legacyClientSupport = value;
    }

    @Override
    public int getObjectType() {
        return 328249;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.address == null) {
            throw new ValidationException("PrivateInsightServer/Address: attribute is required!");
        }
        if (this.port == null) {
            throw new ValidationException("PrivateInsightServer/Port: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Address");
            if (value == null) {
                throw new ValidationException("PrivateInsightServer/Address: attribute is required!");
            }
            this.address = value;
            value = attris.getValue("EdrConnectToken");
            if (value != null) {
                this.edrConnectToken = value;
            }
            if ((value = attris.getValue("Port")) == null) {
                throw new ValidationException("PrivateInsightServer/Port: attribute is required!");
            }
            try {
                this.port = Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Protocol");
            if (value != null) {
                this.setOptProtocolValue(value);
            }
            if ((value = attris.getValue("HttpsVerifyCA")) != null) {
                this.httpsVerifyCA = "1".equals(value);
            }
            if ((value = attris.getValue("LegacyClientSupport")) != null) {
                this.legacyClientSupport = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"PrivateInsightServer".equals(element.getNodeName())) {
            throw new ValidationException("PrivateInsightServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Address");
        if (value == null) {
            throw new ValidationException("PrivateInsightServer/Address: attribute is required!");
        }
        this.address = value;
        value = XMLHelper.getAttribute(element, "EdrConnectToken");
        if (value != null) {
            this.edrConnectToken = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) == null) {
            throw new ValidationException("PrivateInsightServer/Port: attribute is required!");
        }
        try {
            this.port = Integer.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("PrivateInsightServer/Port: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Protocol");
        if (value != null) {
            this.setOptProtocolValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsVerifyCA")) != null) {
            this.httpsVerifyCA = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LegacyClientSupport")) != null) {
            this.legacyClientSupport = "1".equals(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("PrivateInsightServer");
        if (this.address != null) {
            element.setAttribute("Address", this.address);
        }
        if (this.edrConnectToken != null) {
            element.setAttribute("EdrConnectToken", this.edrConnectToken);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port.toString());
        }
        if (this.protocol != null) {
            element.setAttribute("Protocol", this.getOptProtocolValue());
        }
        if (this.httpsVerifyCA != null) {
            element.setAttribute("HttpsVerifyCA", this.httpsVerifyCA != false ? "1" : "0");
        }
        if (this.legacyClientSupport != null) {
            element.setAttribute("LegacyClientSupport", this.legacyClientSupport != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<PrivateInsightServer ");
            if (this.address != null) {
                strAttrs.append("Address=\"").append(AbstractSchema.checkXMLContent(this.address)).append("\" ");
            }
            if (this.edrConnectToken != null) {
                strAttrs.append("EdrConnectToken=\"").append(AbstractSchema.checkXMLContent(this.edrConnectToken)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(this.port.toString()).append("\" ");
            }
            if (this.protocol != null) {
                strAttrs.append("Protocol=\"").append(this.getOptProtocolValue()).append("\" ");
            }
            if (this.httpsVerifyCA != null) {
                strAttrs.append("HttpsVerifyCA=").append(this.httpsVerifyCA != false ? "\"1\" " : "\"0\" ");
            }
            if (this.legacyClientSupport != null) {
                strAttrs.append("LegacyClientSupport=").append(this.legacyClientSupport != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</PrivateInsightServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

