/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.AuthParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class P2P
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private Boolean enableAuthentication;
    private Boolean enableClientActivityLog;

    public P2P() {
        this.nameSpace = "agent";
        this.children.put(327775, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "P2P";
    }

    public Boolean getEnableAuthentication() {
        return this.enableAuthentication;
    }

    public void setEnableAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enableAuthentication = value;
    }

    public Boolean getDefEnableClientActivityLog() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableClientActivityLog() {
        return this.enableClientActivityLog;
    }

    public void setOptEnableClientActivityLog(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enableClientActivityLog = value;
    }

    public AuthParameter getOptAuthParameter() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327775);
        if (childGroup.size() > 0) {
            return (AuthParameter)childGroup.get(0);
        }
        return null;
    }

    public void setOptAuthParameter(AuthParameter value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            AuthParameter obj = this.getOptAuthParameter();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 327774;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.enableAuthentication == null) {
            throw new ValidationException("P2P/EnableAuthentication: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof AuthParameter) {
            try {
                this.setOptAuthParameter((AuthParameter)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("EnableAuthentication");
            if (value == null) {
                throw new ValidationException("P2P/EnableAuthentication: attribute is required!");
            }
            this.enableAuthentication = "1".equals(value);
            value = attris.getValue("EnableClientActivityLog");
            if (value != null) {
                this.enableClientActivityLog = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptAuthParameter() != null) {
            this.getOptAuthParameter().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"P2P".equals(element.getNodeName())) {
            throw new ValidationException("P2P: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "EnableAuthentication");
        if (value == null) {
            throw new ValidationException("P2P/EnableAuthentication: attribute is required!");
        }
        this.enableAuthentication = "1".equals(value);
        value = XMLHelper.getAttribute(element, "EnableClientActivityLog");
        if (value != null) {
            this.enableClientActivityLog = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "AuthParameter")).size() > 0) {
            AuthParameter authParameterObj = new AuthParameter();
            authParameterObj.importFromElement(v.get(0));
            this.setOptAuthParameter(authParameterObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("P2P");
        if (this.enableAuthentication != null) {
            element.setAttribute("EnableAuthentication", this.enableAuthentication != false ? "1" : "0");
        }
        if (this.enableClientActivityLog != null) {
            element.setAttribute("EnableClientActivityLog", this.enableClientActivityLog != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<P2P ");
            if (this.enableAuthentication != null) {
                strAttrs.append("EnableAuthentication=").append(this.enableAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableClientActivityLog != null) {
                strAttrs.append("EnableClientActivityLog=").append(this.enableClientActivityLog != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</P2P>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

