/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.OS;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OSVersion
extends AbstractSchema {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;

    public OSVersion() {
        this.nameSpace = "agent";
        this.children.put(327747, new ChildGroup(1, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "OSVersion";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("OSVersion/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("OSVersion/Operator: invalid attribute value:" + value + "!");
        }
    }

    public void addOS(OS value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addOS(int index, OS value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<OS> getOS() {
        Vector<OS> v = new Vector<OS>();
        for (Transportable child : (ChildGroup)this.children.get(327747)) {
            v.add((OS)child);
        }
        return v;
    }

    public int getOSCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327747);
        return childGroup.size();
    }

    public OS getOS(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(327747);
        return (OS)childGroup.get(index);
    }

    public void setOS(int index, OS value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeOS(OS value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 327746;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getOSCount() < 1) {
            throw new ValidationException("OSVersion/OS: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof OS) {
            try {
                this.addOS((OS)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getOSCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getOS(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(327747)).size();
        }
        catch (Throwable t) {
            throw new SAXException("OSVersion: can't import element == OS!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"OSVersion".equals(element.getNodeName())) {
            throw new ValidationException("OSVersion: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "OS")).size() < 1) {
            throw new ValidationException("OSVersion/OS: element is require!");
        }
        for (int i = 0; i < v.size(); ++i) {
            OS oSObj = new OS();
            oSObj.importFromElement(v.get(i));
            this.addOS(oSObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("OSVersion");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OSVersion ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OSVersion>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

