/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OSIntegration
extends AbstractSchema {
    public static final Integer WINDOWS = 0;
    public static final Integer MAC = 1;
    public static final Integer NO_ACTION = 0;
    public static final Integer DISABLE_ONCE_ONLY = 1;
    public static final Integer DISABLE_ALWAYS = 2;
    public static final Integer RESTORE_IF_DISABLED = 3;
    private static final long serialVersionUID = 1L;
    private Integer oSPlatform;
    private Integer disableOSFW;
    private Boolean oSFWDisabledMessage;

    public OSIntegration() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "OSIntegration";
    }

    public Integer getDefOSPlatform() {
        return WINDOWS;
    }

    public Integer getOptOSPlatform() {
        return this.oSPlatform;
    }

    public String getOptOSPlatformValue() throws ValidationException {
        if (this.oSPlatform == null) {
            return null;
        }
        String s = null;
        switch (this.oSPlatform) {
            case 0: {
                s = "WINDOWS";
                break;
            }
            case 1: {
                s = "MAC";
                break;
            }
            default: {
                throw new ValidationException("OSIntegration/OSPlatform: invalid attribute value:" + this.oSPlatform + "!");
            }
        }
        return s;
    }

    public void setOptOSPlatform(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.oSPlatform = value;
    }

    public void setOptOSPlatformValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.oSPlatform = null;
            return;
        }
        if ("WINDOWS".equals(value)) {
            this.oSPlatform = WINDOWS;
        } else if ("MAC".equals(value)) {
            this.oSPlatform = MAC;
        } else {
            throw new ValidationException("OSIntegration/OSPlatform: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefDisableOSFW() {
        return DISABLE_ONCE_ONLY;
    }

    public Integer getOptDisableOSFW() {
        return this.disableOSFW;
    }

    public String getOptDisableOSFWValue() throws ValidationException {
        if (this.disableOSFW == null) {
            return null;
        }
        String s = null;
        switch (this.disableOSFW) {
            case 0: {
                s = "NO_ACTION";
                break;
            }
            case 1: {
                s = "DISABLE_ONCE_ONLY";
                break;
            }
            case 2: {
                s = "DISABLE_ALWAYS";
                break;
            }
            case 3: {
                s = "RESTORE_IF_DISABLED";
                break;
            }
            default: {
                throw new ValidationException("OSIntegration/DisableOSFW: invalid attribute value:" + this.disableOSFW + "!");
            }
        }
        return s;
    }

    public void setOptDisableOSFW(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.disableOSFW = value;
    }

    public void setOptDisableOSFWValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.disableOSFW = null;
            return;
        }
        if ("NO_ACTION".equals(value)) {
            this.disableOSFW = NO_ACTION;
        } else if ("DISABLE_ONCE_ONLY".equals(value)) {
            this.disableOSFW = DISABLE_ONCE_ONLY;
        } else if ("DISABLE_ALWAYS".equals(value)) {
            this.disableOSFW = DISABLE_ALWAYS;
        } else if ("RESTORE_IF_DISABLED".equals(value)) {
            this.disableOSFW = RESTORE_IF_DISABLED;
        } else {
            throw new ValidationException("OSIntegration/DisableOSFW: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefOSFWDisabledMessage() {
        return Boolean.FALSE;
    }

    public Boolean getOptOSFWDisabledMessage() {
        return this.oSFWDisabledMessage;
    }

    public void setOptOSFWDisabledMessage(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.oSFWDisabledMessage = value;
    }

    @Override
    public int getObjectType() {
        return 328038;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("OSPlatform");
            if (value != null) {
                this.setOptOSPlatformValue(value);
            }
            if ((value = attris.getValue("DisableOSFW")) != null) {
                this.setOptDisableOSFWValue(value);
            }
            if ((value = attris.getValue("OSFWDisabledMessage")) != null) {
                this.oSFWDisabledMessage = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"OSIntegration".equals(element.getNodeName())) {
            throw new ValidationException("OSIntegration: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "OSPlatform");
        if (value != null) {
            this.setOptOSPlatformValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisableOSFW")) != null) {
            this.setOptDisableOSFWValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "OSFWDisabledMessage")) != null) {
            this.oSFWDisabledMessage = "1".equals(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("OSIntegration");
        if (this.oSPlatform != null) {
            element.setAttribute("OSPlatform", this.getOptOSPlatformValue());
        }
        if (this.disableOSFW != null) {
            element.setAttribute("DisableOSFW", this.getOptDisableOSFWValue());
        }
        if (this.oSFWDisabledMessage != null) {
            element.setAttribute("OSFWDisabledMessage", this.oSFWDisabledMessage != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OSIntegration ");
            if (this.oSPlatform != null) {
                strAttrs.append("OSPlatform=\"").append(this.getOptOSPlatformValue()).append("\" ");
            }
            if (this.disableOSFW != null) {
                strAttrs.append("DisableOSFW=\"").append(this.getOptDisableOSFWValue()).append("\" ");
            }
            if (this.oSFWDisabledMessage != null) {
                strAttrs.append("OSFWDisabledMessage=").append(this.oSFWDisabledMessage != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OSIntegration>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

