/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OS
extends AbstractSchema {
    public static final Integer X64 = 0;
    public static final Integer X86 = 1;
    public static final Integer ALL = 2;
    private static final long serialVersionUID = 1L;
    private Integer arch;
    private String name;
    private Integer buildNumber;

    public OS() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "OS";
    }

    public Integer getOptArch() {
        return this.arch;
    }

    public String getOptArchValue() throws ValidationException {
        if (this.arch == null) {
            return null;
        }
        String s = null;
        switch (this.arch) {
            case 0: {
                s = "X64";
                break;
            }
            case 1: {
                s = "X86";
                break;
            }
            case 2: {
                s = "ALL";
                break;
            }
            default: {
                throw new ValidationException("OS/Arch: invalid attribute value:" + this.arch + "!");
            }
        }
        return s;
    }

    public void setOptArch(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.arch = value;
    }

    public void setOptArchValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.arch = null;
            return;
        }
        if ("X64".equals(value)) {
            this.arch = X64;
        } else if ("X86".equals(value)) {
            this.arch = X86;
        } else if ("ALL".equals(value)) {
            this.arch = ALL;
        } else {
            throw new ValidationException("OS/Arch: invalid attribute value:" + value + "!");
        }
    }

    public String getOptName() {
        return this.name;
    }

    public void setOptName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public Integer getOptBuildNumber() {
        return this.buildNumber;
    }

    public void setOptBuildNumber(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.buildNumber = value;
    }

    @Override
    public int getObjectType() {
        return 327747;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block8: {
            try {
                String value = attris.getValue("Arch");
                if (value != null) {
                    this.setOptArchValue(value);
                }
                if ((value = attris.getValue("Name")) != null) {
                    this.name = value;
                }
                if ((value = attris.getValue("BuildNumber")) == null) break block8;
                try {
                    this.buildNumber = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("OS/BuildNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("OS/BuildNumber: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"OS".equals(element.getNodeName())) {
            throw new ValidationException("OS: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Arch");
        if (value != null) {
            this.setOptArchValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) != null) {
            this.name = value;
        }
        if ((value = XMLHelper.getAttribute(element, "BuildNumber")) != null) {
            try {
                this.buildNumber = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("OS/BuildNumber: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("OS");
        if (this.arch != null) {
            element.setAttribute("Arch", this.getOptArchValue());
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.buildNumber != null) {
            element.setAttribute("BuildNumber", this.buildNumber.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<OS ");
            if (this.arch != null) {
                strAttrs.append("Arch=\"").append(this.getOptArchValue()).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.buildNumber != null) {
                strAttrs.append("BuildNumber=\"").append(this.buildNumber.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</OS>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

