/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.IpAddress;
import com.sygate.scm.common.configobject.agent.NpNiDescription;
import com.sygate.scm.common.configobject.agent.NpNiName;
import com.sygate.scm.common.configobject.agent.SubNet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkInterface
extends AbstractSchema {
    public static final Integer PPTP = 0;
    public static final Integer VPN = 1;
    public static final Integer ALL = 2;
    public static final Integer ETHERNET = 3;
    public static final Integer ETHERNET_802_11 = 4;
    public static final Integer DUN = 5;
    public static final Integer VP_CISCO3000 = 6;
    public static final Integer VP_SAFENET = 7;
    public static final Integer VP_CHECKPOINT = 8;
    public static final Integer VP_NETSCREEN = 9;
    public static final Integer VP_AVENTAIL = 10;
    public static final Integer VP_ALCATEL = 11;
    public static final Integer VP_JUNIPER_SSL = 12;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean include;
    private Integer networkInterfaceType;

    public NetworkInterface() {
        this.nameSpace = "agent";
        this.children.put(328061, new ChildGroup(0, 1));
        this.children.put(328063, new ChildGroup(0, 1));
        this.children.put(328031, new ChildGroup(0, 1));
        this.children.put(328032, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "NetworkInterface";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public Boolean getInclude() {
        return this.include;
    }

    public void setInclude(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.include = value;
    }

    public Integer getDefNetworkInterfaceType() {
        return ALL;
    }

    public Integer getOptNetworkInterfaceType() {
        return this.networkInterfaceType;
    }

    public String getOptNetworkInterfaceTypeValue() throws ValidationException {
        if (this.networkInterfaceType == null) {
            return null;
        }
        String s = null;
        switch (this.networkInterfaceType) {
            case 0: {
                s = "PPTP";
                break;
            }
            case 1: {
                s = "VPN";
                break;
            }
            case 2: {
                s = "ALL";
                break;
            }
            case 3: {
                s = "ETHERNET";
                break;
            }
            case 4: {
                s = "ETHERNET_802_11";
                break;
            }
            case 5: {
                s = "DUN";
                break;
            }
            case 6: {
                s = "VP_CISCO3000";
                break;
            }
            case 7: {
                s = "VP_SAFENET";
                break;
            }
            case 8: {
                s = "VP_CHECKPOINT";
                break;
            }
            case 9: {
                s = "VP_NETSCREEN";
                break;
            }
            case 10: {
                s = "VP_AVENTAIL";
                break;
            }
            case 11: {
                s = "VP_ALCATEL";
                break;
            }
            case 12: {
                s = "VP_JUNIPER_SSL";
                break;
            }
            default: {
                throw new ValidationException("NetworkInterface/NetworkInterfaceType: invalid attribute value:" + this.networkInterfaceType + "!");
            }
        }
        return s;
    }

    public void setOptNetworkInterfaceType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.networkInterfaceType = value;
    }

    public void setOptNetworkInterfaceTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.networkInterfaceType = null;
            return;
        }
        if ("PPTP".equals(value)) {
            this.networkInterfaceType = PPTP;
        } else if ("VPN".equals(value)) {
            this.networkInterfaceType = VPN;
        } else if ("ALL".equals(value)) {
            this.networkInterfaceType = ALL;
        } else if ("ETHERNET".equals(value)) {
            this.networkInterfaceType = ETHERNET;
        } else if ("ETHERNET_802_11".equals(value)) {
            this.networkInterfaceType = ETHERNET_802_11;
        } else if ("DUN".equals(value)) {
            this.networkInterfaceType = DUN;
        } else if ("VP_CISCO3000".equals(value)) {
            this.networkInterfaceType = VP_CISCO3000;
        } else if ("VP_SAFENET".equals(value)) {
            this.networkInterfaceType = VP_SAFENET;
        } else if ("VP_CHECKPOINT".equals(value)) {
            this.networkInterfaceType = VP_CHECKPOINT;
        } else if ("VP_NETSCREEN".equals(value)) {
            this.networkInterfaceType = VP_NETSCREEN;
        } else if ("VP_AVENTAIL".equals(value)) {
            this.networkInterfaceType = VP_AVENTAIL;
        } else if ("VP_ALCATEL".equals(value)) {
            this.networkInterfaceType = VP_ALCATEL;
        } else if ("VP_JUNIPER_SSL".equals(value)) {
            this.networkInterfaceType = VP_JUNIPER_SSL;
        } else {
            throw new ValidationException("NetworkInterface/NetworkInterfaceType: invalid attribute value:" + value + "!");
        }
    }

    public IpAddress getOptIpAddress() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328061);
        if (childGroup.size() > 0) {
            return (IpAddress)childGroup.get(0);
        }
        return null;
    }

    public void setOptIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IpAddress obj = this.getOptIpAddress();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public SubNet getOptSubNet() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328063);
        if (childGroup.size() > 0) {
            return (SubNet)childGroup.get(0);
        }
        return null;
    }

    public void setOptSubNet(SubNet value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            SubNet obj = this.getOptSubNet();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public NpNiName getOptNpNiName() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328031);
        if (childGroup.size() > 0) {
            return (NpNiName)childGroup.get(0);
        }
        return null;
    }

    public void setOptNpNiName(NpNiName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NpNiName obj = this.getOptNpNiName();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public NpNiDescription getOptNpNiDescription() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328032);
        if (childGroup.size() > 0) {
            return (NpNiDescription)childGroup.get(0);
        }
        return null;
    }

    public void setOptNpNiDescription(NpNiDescription value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NpNiDescription obj = this.getOptNpNiDescription();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 328030;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.include == null) {
            throw new ValidationException("NetworkInterface/Include: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof IpAddress) {
            try {
                this.setOptIpAddress((IpAddress)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SubNet) {
            try {
                this.setOptSubNet((SubNet)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof NpNiName) {
            try {
                this.setOptNpNiName((NpNiName)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof NpNiDescription) {
            try {
                this.setOptNpNiDescription((NpNiDescription)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Include")) == null) {
                throw new ValidationException("NetworkInterface/Include: attribute is required!");
            }
            this.include = "1".equals(value);
            value = attris.getValue("NetworkInterfaceType");
            if (value != null) {
                this.setOptNetworkInterfaceTypeValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptIpAddress() != null) {
            this.getOptIpAddress().setReadonly();
        }
        if (this.getOptSubNet() != null) {
            this.getOptSubNet().setReadonly();
        }
        if (this.getOptNpNiName() != null) {
            this.getOptNpNiName().setReadonly();
        }
        if (this.getOptNpNiDescription() != null) {
            this.getOptNpNiDescription().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"NetworkInterface".equals(element.getNodeName())) {
            throw new ValidationException("NetworkInterface: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Include")) == null) {
            throw new ValidationException("NetworkInterface/Include: attribute is required!");
        }
        this.include = "1".equals(value);
        value = XMLHelper.getAttribute(element, "NetworkInterfaceType");
        if (value != null) {
            this.setOptNetworkInterfaceTypeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "IpAddress")).size() > 0) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(0));
            this.setOptIpAddress(ipAddressObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "SubNet")).size() > 0) {
            SubNet subNetObj = new SubNet();
            subNetObj.importFromElement(v.get(0));
            this.setOptSubNet(subNetObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "NpNiName")).size() > 0) {
            NpNiName npNiNameObj = new NpNiName();
            npNiNameObj.importFromElement(v.get(0));
            this.setOptNpNiName(npNiNameObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "NpNiDescription")).size() > 0) {
            NpNiDescription npNiDescriptionObj = new NpNiDescription();
            npNiDescriptionObj.importFromElement(v.get(0));
            this.setOptNpNiDescription(npNiDescriptionObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("NetworkInterface");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.include != null) {
            element.setAttribute("Include", this.include != false ? "1" : "0");
        }
        if (this.networkInterfaceType != null) {
            element.setAttribute("NetworkInterfaceType", this.getOptNetworkInterfaceTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NetworkInterface ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.include != null) {
                strAttrs.append("Include=").append(this.include != false ? "\"1\" " : "\"0\" ");
            }
            if (this.networkInterfaceType != null) {
                strAttrs.append("NetworkInterfaceType=\"").append(this.getOptNetworkInterfaceTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NetworkInterface>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

