/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.EthernetExclusionList;
import com.sygate.scm.common.configobject.agent.NetworkInterfaceGroupLink;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkConnection
extends AbstractSchema {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private Long connectionStatus;

    public NetworkConnection() {
        this.nameSpace = "agent";
        this.children.put(328028, new ChildGroup(0, 1));
        this.children.put(327726, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "NetworkConnection";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("NetworkConnection/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("NetworkConnection/Operator: invalid attribute value:" + value + "!");
        }
    }

    public Long getOptConnectionStatus() {
        return this.connectionStatus;
    }

    public void setOptConnectionStatus(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.connectionStatus = value;
    }

    public NetworkInterfaceGroupLink getOptNetworkInterfaceGroupLink() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328028);
        if (childGroup.size() > 0) {
            return (NetworkInterfaceGroupLink)childGroup.get(0);
        }
        return null;
    }

    public void setOptNetworkInterfaceGroupLink(NetworkInterfaceGroupLink value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            NetworkInterfaceGroupLink obj = this.getOptNetworkInterfaceGroupLink();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public EthernetExclusionList getOptEthernetExclusionList() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327726);
        if (childGroup.size() > 0) {
            return (EthernetExclusionList)childGroup.get(0);
        }
        return null;
    }

    public void setOptEthernetExclusionList(EthernetExclusionList value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            EthernetExclusionList obj = this.getOptEthernetExclusionList();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 327725;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof NetworkInterfaceGroupLink) {
            try {
                this.setOptNetworkInterfaceGroupLink((NetworkInterfaceGroupLink)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof EthernetExclusionList) {
            try {
                this.setOptEthernetExclusionList((EthernetExclusionList)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block7: {
            try {
                String value = attris.getValue("Operator");
                if (value != null) {
                    this.setOptOperatorValue(value);
                }
                if ((value = attris.getValue("ConnectionStatus")) == null) break block7;
                try {
                    this.connectionStatus = Long.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("NetworkConnection/ConnectionStatus: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("NetworkConnection/ConnectionStatus: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptNetworkInterfaceGroupLink() != null) {
            this.getOptNetworkInterfaceGroupLink().setReadonly();
        }
        if (this.getOptEthernetExclusionList() != null) {
            this.getOptEthernetExclusionList().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"NetworkConnection".equals(element.getNodeName())) {
            throw new ValidationException("NetworkConnection: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ConnectionStatus")) != null) {
            try {
                this.connectionStatus = Long.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("NetworkConnection/ConnectionStatus: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((v = XMLHelper.getChildElementByName(element, "NetworkInterfaceGroupLink")).size() > 0) {
            NetworkInterfaceGroupLink networkInterfaceGroupLinkObj = new NetworkInterfaceGroupLink();
            networkInterfaceGroupLinkObj.importFromElement(v.get(0));
            this.setOptNetworkInterfaceGroupLink(networkInterfaceGroupLinkObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "EthernetExclusionList")).size() > 0) {
            EthernetExclusionList ethernetExclusionListObj = new EthernetExclusionList();
            ethernetExclusionListObj.importFromElement(v.get(0));
            this.setOptEthernetExclusionList(ethernetExclusionListObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("NetworkConnection");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.connectionStatus != null) {
            element.setAttribute("ConnectionStatus", this.connectionStatus.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NetworkConnection ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.connectionStatus != null) {
                strAttrs.append("ConnectionStatus=\"").append(this.connectionStatus.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NetworkConnection>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

