/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.AncestorProcess;
import com.sygate.scm.common.configobject.agent.NXProcess;
import com.sygate.scm.common.configobject.agent.ProcessAction;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NXPrograms
extends AbstractSchema {
    public static final Integer NONE = 0;
    public static final Integer OR = 1;
    public static final Integer AND = 2;
    private static final long serialVersionUID = 1L;
    private Integer ancestorOP;
    private Boolean enable;
    private String name;
    private String description;

    public NXPrograms() {
        this.nameSpace = "agent";
        this.children.put(328134, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(328135, new ChildGroup(1, Integer.MAX_VALUE));
        this.children.put(328102, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "NXPrograms";
    }

    public Integer getDefAncestorOP() {
        return NONE;
    }

    public Integer getOptAncestorOP() {
        return this.ancestorOP;
    }

    public String getOptAncestorOPValue() throws ValidationException {
        if (this.ancestorOP == null) {
            return null;
        }
        String s = null;
        switch (this.ancestorOP) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "OR";
                break;
            }
            case 2: {
                s = "AND";
                break;
            }
            default: {
                throw new ValidationException("NXPrograms/AncestorOP: invalid attribute value:" + this.ancestorOP + "!");
            }
        }
        return s;
    }

    public void setOptAncestorOP(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ancestorOP = value;
    }

    public void setOptAncestorOPValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.ancestorOP = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.ancestorOP = NONE;
        } else if ("OR".equals(value)) {
            this.ancestorOP = OR;
        } else if ("AND".equals(value)) {
            this.ancestorOP = AND;
        } else {
            throw new ValidationException("NXPrograms/AncestorOP: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public String getOptName() {
        return this.name;
    }

    public void setOptName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.description = value;
    }

    public void addAncestorProcess(AncestorProcess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addAncestorProcess(int index, AncestorProcess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<AncestorProcess> getAncestorProcess() {
        Vector<AncestorProcess> v = new Vector<AncestorProcess>();
        for (Transportable child : (ChildGroup)this.children.get(328134)) {
            v.add((AncestorProcess)child);
        }
        return v;
    }

    public int getAncestorProcessCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328134);
        return childGroup.size();
    }

    public AncestorProcess getAncestorProcess(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328134);
        return (AncestorProcess)childGroup.get(index);
    }

    public void setAncestorProcess(int index, AncestorProcess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeAncestorProcess(AncestorProcess value) {
        this.removeChild(value);
    }

    public void addNXProcess(NXProcess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addNXProcess(int index, NXProcess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<NXProcess> getNXProcess() {
        Vector<NXProcess> v = new Vector<NXProcess>();
        for (Transportable child : (ChildGroup)this.children.get(328135)) {
            v.add((NXProcess)child);
        }
        return v;
    }

    public int getNXProcessCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328135);
        return childGroup.size();
    }

    public NXProcess getNXProcess(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328135);
        return (NXProcess)childGroup.get(index);
    }

    public void setNXProcess(int index, NXProcess value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeNXProcess(NXProcess value) {
        this.removeChild(value);
    }

    public ProcessAction getProcessAction() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328102);
        if (childGroup.size() > 0) {
            return (ProcessAction)childGroup.get(0);
        }
        return null;
    }

    public void setProcessAction(ProcessAction value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ProcessAction obj = this.getProcessAction();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 328133;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getNXProcessCount() < 1) {
            throw new ValidationException("NXPrograms/NXProcess: attribute is required!");
        }
        if (this.getProcessAction() == null) {
            throw new ValidationException("NXPrograms/ProcessAction: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof AncestorProcess) {
            try {
                this.addAncestorProcess((AncestorProcess)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof NXProcess) {
            try {
                this.addNXProcess((NXProcess)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ProcessAction) {
            try {
                this.setProcessAction((ProcessAction)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("AncestorOP");
            if (value != null) {
                this.setOptAncestorOPValue(value);
            }
            if ((value = attris.getValue("Enable")) != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Name")) != null) {
                this.name = value;
            }
            if ((value = attris.getValue("Description")) != null) {
                this.description = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getAncestorProcessCount();
        for (i = 0; i < objCnt; ++i) {
            this.getAncestorProcess(i).setReadonly();
        }
        objCnt = this.getNXProcessCount();
        for (i = 0; i < objCnt; ++i) {
            this.getNXProcess(i).setReadonly();
        }
        if (this.getProcessAction() != null) {
            this.getProcessAction().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(328135)).size();
        }
        catch (Throwable t) {
            throw new SAXException("NXPrograms: can't import element == NXProcess!");
        }
        try {
            ((ChildGroup)this.children.get(328102)).size();
        }
        catch (Throwable t) {
            throw new SAXException("NXPrograms: can't import element == ProcessAction!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"NXPrograms".equals(element.getNodeName())) {
            throw new ValidationException("NXPrograms: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "AncestorOP");
        if (value != null) {
            this.setOptAncestorOPValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Enable")) != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) != null) {
            this.name = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Description")) != null) {
            this.description = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "AncestorProcess");
        for (i = 0; i < v.size(); ++i) {
            AncestorProcess ancestorProcessObj = new AncestorProcess();
            ancestorProcessObj.importFromElement(v.get(i));
            this.addAncestorProcess(ancestorProcessObj);
        }
        v = XMLHelper.getChildElementByName(element, "NXProcess");
        if (v.size() < 1) {
            throw new ValidationException("NXPrograms/NXProcess: element is require!");
        }
        for (i = 0; i < v.size(); ++i) {
            NXProcess nXProcessObj = new NXProcess();
            nXProcessObj.importFromElement(v.get(i));
            this.addNXProcess(nXProcessObj);
        }
        v = XMLHelper.getChildElementByName(element, "ProcessAction");
        if (v.size() != 1) {
            throw new ValidationException("NXPrograms/ProcessAction: element is require!");
        }
        ProcessAction processActionObj = new ProcessAction();
        processActionObj.importFromElement(v.get(0));
        this.setProcessAction(processActionObj);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("NXPrograms");
        if (this.ancestorOP != null) {
            element.setAttribute("AncestorOP", this.getOptAncestorOPValue());
        }
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<NXPrograms ");
            if (this.ancestorOP != null) {
                strAttrs.append("AncestorOP=\"").append(this.getOptAncestorOPValue()).append("\" ");
            }
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</NXPrograms>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

