/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Macro
extends AbstractSchema {
    public static final Integer NONE = 0;
    public static final Integer UDP_PORT = 1;
    public static final Integer TCP_PORT = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String name;
    private String description;
    private Integer type;
    private String content;

    public Macro() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "Macro";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.description = value;
    }

    public Integer getDefType() {
        return NONE;
    }

    public Integer getOptType() {
        return this.type;
    }

    public String getOptTypeValue() throws ValidationException {
        if (this.type == null) {
            return null;
        }
        String s = null;
        switch (this.type) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "UDP_PORT";
                break;
            }
            case 2: {
                s = "TCP_PORT";
                break;
            }
            default: {
                throw new ValidationException("Macro/Type: invalid attribute value:" + this.type + "!");
            }
        }
        return s;
    }

    public void setOptType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.type = value;
    }

    public void setOptTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.type = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.type = NONE;
        } else if ("UDP_PORT".equals(value)) {
            this.type = UDP_PORT;
        } else if ("TCP_PORT".equals(value)) {
            this.type = TCP_PORT;
        } else {
            throw new ValidationException("Macro/Type: invalid attribute value:" + value + "!");
        }
    }

    public String getOptContent() {
        return this.content;
    }

    public void setOptContent(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.content = value;
    }

    @Override
    public int getObjectType() {
        return 328160;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("Macro/Name: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Name")) == null) {
                throw new ValidationException("Macro/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("Type")) != null) {
                this.setOptTypeValue(value);
            }
            if ((value = attris.getValue("Content")) != null) {
                this.content = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Macro".equals(element.getNodeName())) {
            throw new ValidationException("Macro: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) == null) {
            throw new ValidationException("Macro/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Type")) != null) {
            this.setOptTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Content")) != null) {
            this.content = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Macro");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.type != null) {
            element.setAttribute("Type", this.getOptTypeValue());
        }
        if (this.content != null) {
            element.setAttribute("Content", this.content);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Macro ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.getOptTypeValue()).append("\" ");
            }
            if (this.content != null) {
                strAttrs.append("Content=\"").append(AbstractSchema.checkXMLContent(this.content)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Macro>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

