/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.Description;
import com.sygate.scm.common.configobject.agent.Items;
import com.sygate.scm.common.configobject.agent.MacScanNotification;
import com.sygate.scm.common.configobject.agent.Schedule;
import com.sygate.scm.common.configobject.agent.ThrottleScan;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MacAVScanSettings
extends AbstractSchema {
    public static final Integer DRIVES = 0;
    public static final Integer FOLDERS = 1;
    private static final long serialVersionUID = 1L;
    private String scanID;
    private Integer scanSelection;
    private Boolean hardDrives;
    private Boolean removableDrives;
    private Boolean idleTimeScan;

    public MacAVScanSettings() {
        this.nameSpace = "agent";
        this.children.put(327940, new ChildGroup(0, 1));
        this.children.put(327941, new ChildGroup(0, 1));
        this.children.put(327943, new ChildGroup(0, 1));
        this.children.put(327948, new ChildGroup(0, 1));
        this.children.put(327918, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "MacAVScanSettings";
    }

    public String getScanID() {
        return this.scanID;
    }

    public void setScanID(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.scanID = value;
    }

    public Integer getDefScanSelection() {
        return DRIVES;
    }

    public Integer getOptScanSelection() {
        return this.scanSelection;
    }

    public String getOptScanSelectionValue() throws ValidationException {
        if (this.scanSelection == null) {
            return null;
        }
        String s = null;
        switch (this.scanSelection) {
            case 0: {
                s = "DRIVES";
                break;
            }
            case 1: {
                s = "FOLDERS";
                break;
            }
            default: {
                throw new ValidationException("MacAVScanSettings/ScanSelection: invalid attribute value:" + this.scanSelection + "!");
            }
        }
        return s;
    }

    public void setOptScanSelection(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.scanSelection = value;
    }

    public void setOptScanSelectionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.scanSelection = null;
            return;
        }
        if ("DRIVES".equals(value)) {
            this.scanSelection = DRIVES;
        } else if ("FOLDERS".equals(value)) {
            this.scanSelection = FOLDERS;
        } else {
            throw new ValidationException("MacAVScanSettings/ScanSelection: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefHardDrives() {
        return Boolean.TRUE;
    }

    public Boolean getOptHardDrives() {
        return this.hardDrives;
    }

    public void setOptHardDrives(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.hardDrives = value;
    }

    public Boolean getDefRemovableDrives() {
        return Boolean.TRUE;
    }

    public Boolean getOptRemovableDrives() {
        return this.removableDrives;
    }

    public void setOptRemovableDrives(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.removableDrives = value;
    }

    public Boolean getDefIdleTimeScan() {
        return Boolean.TRUE;
    }

    public Boolean getOptIdleTimeScan() {
        return this.idleTimeScan;
    }

    public void setOptIdleTimeScan(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.idleTimeScan = value;
    }

    public Description getOptDescription() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327940);
        if (childGroup.size() > 0) {
            return (Description)childGroup.get(0);
        }
        return null;
    }

    public void setOptDescription(Description value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Description obj = this.getOptDescription();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Schedule getOptSchedule() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327941);
        if (childGroup.size() > 0) {
            return (Schedule)childGroup.get(0);
        }
        return null;
    }

    public void setOptSchedule(Schedule value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Schedule obj = this.getOptSchedule();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Items getOptItems() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327943);
        if (childGroup.size() > 0) {
            return (Items)childGroup.get(0);
        }
        return null;
    }

    public void setOptItems(Items value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Items obj = this.getOptItems();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public ThrottleScan getOptThrottleScan() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327948);
        if (childGroup.size() > 0) {
            return (ThrottleScan)childGroup.get(0);
        }
        return null;
    }

    public void setOptThrottleScan(ThrottleScan value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            ThrottleScan obj = this.getOptThrottleScan();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public MacScanNotification getOptMacScanNotification() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327918);
        if (childGroup.size() > 0) {
            return (MacScanNotification)childGroup.get(0);
        }
        return null;
    }

    public void setOptMacScanNotification(MacScanNotification value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            MacScanNotification obj = this.getOptMacScanNotification();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 327917;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.scanID == null) {
            throw new ValidationException("MacAVScanSettings/ScanID: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof Description) {
            try {
                this.setOptDescription((Description)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Schedule) {
            try {
                this.setOptSchedule((Schedule)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Items) {
            try {
                this.setOptItems((Items)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof ThrottleScan) {
            try {
                this.setOptThrottleScan((ThrottleScan)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof MacScanNotification) {
            try {
                this.setOptMacScanNotification((MacScanNotification)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("ScanID");
            if (value == null) {
                throw new ValidationException("MacAVScanSettings/ScanID: attribute is required!");
            }
            this.scanID = value;
            value = attris.getValue("ScanSelection");
            if (value != null) {
                this.setOptScanSelectionValue(value);
            }
            if ((value = attris.getValue("HardDrives")) != null) {
                this.hardDrives = "1".equals(value);
            }
            if ((value = attris.getValue("RemovableDrives")) != null) {
                this.removableDrives = "1".equals(value);
            }
            if ((value = attris.getValue("IdleTimeScan")) != null) {
                this.idleTimeScan = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getOptDescription() != null) {
            this.getOptDescription().setReadonly();
        }
        if (this.getOptSchedule() != null) {
            this.getOptSchedule().setReadonly();
        }
        if (this.getOptItems() != null) {
            this.getOptItems().setReadonly();
        }
        if (this.getOptThrottleScan() != null) {
            this.getOptThrottleScan().setReadonly();
        }
        if (this.getOptMacScanNotification() != null) {
            this.getOptMacScanNotification().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"MacAVScanSettings".equals(element.getNodeName())) {
            throw new ValidationException("MacAVScanSettings: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "ScanID");
        if (value == null) {
            throw new ValidationException("MacAVScanSettings/ScanID: attribute is required!");
        }
        this.scanID = value;
        value = XMLHelper.getAttribute(element, "ScanSelection");
        if (value != null) {
            this.setOptScanSelectionValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HardDrives")) != null) {
            this.hardDrives = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RemovableDrives")) != null) {
            this.removableDrives = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "IdleTimeScan")) != null) {
            this.idleTimeScan = "1".equals(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Description")).size() > 0) {
            Description descriptionObj = new Description();
            descriptionObj.importFromElement(v.get(0));
            this.setOptDescription(descriptionObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Schedule")).size() > 0) {
            Schedule scheduleObj = new Schedule();
            scheduleObj.importFromElement(v.get(0));
            this.setOptSchedule(scheduleObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "Items")).size() > 0) {
            Items itemsObj = new Items();
            itemsObj.importFromElement(v.get(0));
            this.setOptItems(itemsObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "ThrottleScan")).size() > 0) {
            ThrottleScan throttleScanObj = new ThrottleScan();
            throttleScanObj.importFromElement(v.get(0));
            this.setOptThrottleScan(throttleScanObj);
        }
        if ((v = XMLHelper.getChildElementByName(element, "MacScanNotification")).size() > 0) {
            MacScanNotification macScanNotificationObj = new MacScanNotification();
            macScanNotificationObj.importFromElement(v.get(0));
            this.setOptMacScanNotification(macScanNotificationObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("MacAVScanSettings");
        if (this.scanID != null) {
            element.setAttribute("ScanID", this.scanID);
        }
        if (this.scanSelection != null) {
            element.setAttribute("ScanSelection", this.getOptScanSelectionValue());
        }
        if (this.hardDrives != null) {
            element.setAttribute("HardDrives", this.hardDrives != false ? "1" : "0");
        }
        if (this.removableDrives != null) {
            element.setAttribute("RemovableDrives", this.removableDrives != false ? "1" : "0");
        }
        if (this.idleTimeScan != null) {
            element.setAttribute("IdleTimeScan", this.idleTimeScan != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<MacAVScanSettings ");
            if (this.scanID != null) {
                strAttrs.append("ScanID=\"").append(AbstractSchema.checkXMLContent(this.scanID)).append("\" ");
            }
            if (this.scanSelection != null) {
                strAttrs.append("ScanSelection=\"").append(this.getOptScanSelectionValue()).append("\" ");
            }
            if (this.hardDrives != null) {
                strAttrs.append("HardDrives=").append(this.hardDrives != false ? "\"1\" " : "\"0\" ");
            }
            if (this.removableDrives != null) {
                strAttrs.append("RemovableDrives=").append(this.removableDrives != false ? "\"1\" " : "\"0\" ");
            }
            if (this.idleTimeScan != null) {
                strAttrs.append("IdleTimeScan=").append(this.idleTimeScan != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</MacAVScanSettings>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

