/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LUHttpProxy
extends AbstractSchema {
    public static final Integer NONE = 0;
    public static final Integer SYSTEM = 1;
    public static final Integer CUSTOM = 2;
    public static final Integer BASIC = 0;
    public static final Integer NTLM = 1;
    public static final Integer CLIENT_SIDE = 1;
    private static final long serialVersionUID = 1L;
    private Integer mode;
    private Boolean lockMode;
    private String host;
    private String port;
    private String httpsPort;
    private Boolean requireAuthentication;
    private Integer authenticationType;
    private String userName;
    private String password;
    private String ntlmUserName;
    private String ntlmPassword;
    private String ntlmDomainName;
    private Integer encrypt;
    private Integer modeEx;

    public LUHttpProxy() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "LUHttpProxy";
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "SYSTEM";
                break;
            }
            case 2: {
                s = "CUSTOM";
                break;
            }
            default: {
                throw new ValidationException("LUHttpProxy/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.mode = value;
    }

    public void setModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NONE".equals(value)) {
            this.mode = NONE;
        } else if ("SYSTEM".equals(value)) {
            this.mode = SYSTEM;
        } else if ("CUSTOM".equals(value)) {
            this.mode = CUSTOM;
        } else {
            throw new ValidationException("LUHttpProxy/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockMode() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockMode() {
        return this.lockMode;
    }

    public void setOptLockMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockMode = value;
    }

    public String getOptHost() {
        return this.host;
    }

    public void setOptHost(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.host = value;
    }

    public String getOptPort() {
        return this.port;
    }

    public void setOptPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public String getOptHttpsPort() {
        return this.httpsPort;
    }

    public void setOptHttpsPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.httpsPort = value;
    }

    public Boolean getDefRequireAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptRequireAuthentication() {
        return this.requireAuthentication;
    }

    public void setOptRequireAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.requireAuthentication = value;
    }

    public Integer getDefAuthenticationType() {
        return BASIC;
    }

    public Integer getOptAuthenticationType() {
        return this.authenticationType;
    }

    public String getOptAuthenticationTypeValue() throws ValidationException {
        if (this.authenticationType == null) {
            return null;
        }
        String s = null;
        switch (this.authenticationType) {
            case 0: {
                s = "BASIC";
                break;
            }
            case 1: {
                s = "NTLM";
                break;
            }
            default: {
                throw new ValidationException("LUHttpProxy/AuthenticationType: invalid attribute value:" + this.authenticationType + "!");
            }
        }
        return s;
    }

    public void setOptAuthenticationType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.authenticationType = value;
    }

    public void setOptAuthenticationTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.authenticationType = null;
            return;
        }
        if ("BASIC".equals(value)) {
            this.authenticationType = BASIC;
        } else if ("NTLM".equals(value)) {
            this.authenticationType = NTLM;
        } else {
            throw new ValidationException("LUHttpProxy/AuthenticationType: invalid attribute value:" + value + "!");
        }
    }

    public String getOptUserName() {
        return this.userName;
    }

    public void setOptUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.userName = value;
    }

    public String getOptPassword() {
        return this.password;
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.password = value;
    }

    public String getOptNtlmUserName() {
        return this.ntlmUserName;
    }

    public void setOptNtlmUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ntlmUserName = value;
    }

    public String getOptNtlmPassword() {
        return this.ntlmPassword;
    }

    public void setOptNtlmPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ntlmPassword = value;
    }

    public String getOptNtlmDomainName() {
        return this.ntlmDomainName;
    }

    public void setOptNtlmDomainName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ntlmDomainName = value;
    }

    public Integer getDefEncrypt() {
        return CLIENT_SIDE;
    }

    public Integer getOptEncrypt() {
        return this.encrypt;
    }

    public String getOptEncryptValue() throws ValidationException {
        if (this.encrypt == null) {
            return null;
        }
        String s = null;
        switch (this.encrypt) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "CLIENT_SIDE";
                break;
            }
            default: {
                throw new ValidationException("LUHttpProxy/Encrypt: invalid attribute value:" + this.encrypt + "!");
            }
        }
        return s;
    }

    public void setOptEncrypt(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.encrypt = value;
    }

    public void setOptEncryptValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.encrypt = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.encrypt = NONE;
        } else if ("CLIENT_SIDE".equals(value)) {
            this.encrypt = CLIENT_SIDE;
        } else {
            throw new ValidationException("LUHttpProxy/Encrypt: invalid attribute value:" + value + "!");
        }
    }

    public Integer getModeEx() {
        return this.modeEx;
    }

    public String getModeExValue() throws ValidationException {
        if (this.modeEx == null) {
            return null;
        }
        String s = null;
        switch (this.modeEx) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "SYSTEM";
                break;
            }
            case 2: {
                s = "CUSTOM";
                break;
            }
            default: {
                throw new ValidationException("LUHttpProxy/ModeEx: invalid attribute value:" + this.modeEx + "!");
            }
        }
        return s;
    }

    public void setModeEx(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.modeEx = value;
    }

    public void setModeExValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NONE".equals(value)) {
            this.modeEx = NONE;
        } else if ("SYSTEM".equals(value)) {
            this.modeEx = SYSTEM;
        } else if ("CUSTOM".equals(value)) {
            this.modeEx = CUSTOM;
        } else {
            throw new ValidationException("LUHttpProxy/ModeEx: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 328244;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.mode == null) {
            throw new ValidationException("LUHttpProxy/Mode: attribute is required!");
        }
        if (this.modeEx == null) {
            throw new ValidationException("LUHttpProxy/ModeEx: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Mode");
            if (value == null) {
                throw new ValidationException("LUHttpProxy/Mode: attribute is required!");
            }
            this.setModeValue(value);
            value = attris.getValue("LockMode");
            if (value != null) {
                this.lockMode = "1".equals(value);
            }
            if ((value = attris.getValue("Host")) != null) {
                this.host = value;
            }
            if ((value = attris.getValue("Port")) != null) {
                this.port = value;
            }
            if ((value = attris.getValue("HttpsPort")) != null) {
                this.httpsPort = value;
            }
            if ((value = attris.getValue("RequireAuthentication")) != null) {
                this.requireAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("AuthenticationType")) != null) {
                this.setOptAuthenticationTypeValue(value);
            }
            if ((value = attris.getValue("UserName")) != null) {
                this.userName = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("NtlmUserName")) != null) {
                this.ntlmUserName = value;
            }
            if ((value = attris.getValue("NtlmPassword")) != null) {
                this.ntlmPassword = value;
            }
            if ((value = attris.getValue("NtlmDomainName")) != null) {
                this.ntlmDomainName = value;
            }
            if ((value = attris.getValue("Encrypt")) != null) {
                this.setOptEncryptValue(value);
            }
            if ((value = attris.getValue("ModeEx")) == null) {
                throw new ValidationException("LUHttpProxy/ModeEx: attribute is required!");
            }
            this.setModeExValue(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LUHttpProxy".equals(element.getNodeName())) {
            throw new ValidationException("LUHttpProxy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Mode");
        if (value == null) {
            throw new ValidationException("LUHttpProxy/Mode: attribute is required!");
        }
        this.setModeValue(value);
        value = XMLHelper.getAttribute(element, "LockMode");
        if (value != null) {
            this.lockMode = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Host")) != null) {
            this.host = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            this.port = value;
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsPort")) != null) {
            this.httpsPort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RequireAuthentication")) != null) {
            this.requireAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AuthenticationType")) != null) {
            this.setOptAuthenticationTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UserName")) != null) {
            this.userName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmUserName")) != null) {
            this.ntlmUserName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmPassword")) != null) {
            this.ntlmPassword = value;
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmDomainName")) != null) {
            this.ntlmDomainName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Encrypt")) != null) {
            this.setOptEncryptValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "ModeEx")) == null) {
            throw new ValidationException("LUHttpProxy/ModeEx: attribute is required!");
        }
        this.setModeExValue(value);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("LUHttpProxy");
        if (this.mode != null) {
            element.setAttribute("Mode", this.getModeValue());
        }
        if (this.lockMode != null) {
            element.setAttribute("LockMode", this.lockMode != false ? "1" : "0");
        }
        if (this.host != null) {
            element.setAttribute("Host", this.host);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port);
        }
        if (this.httpsPort != null) {
            element.setAttribute("HttpsPort", this.httpsPort);
        }
        if (this.requireAuthentication != null) {
            element.setAttribute("RequireAuthentication", this.requireAuthentication != false ? "1" : "0");
        }
        if (this.authenticationType != null) {
            element.setAttribute("AuthenticationType", this.getOptAuthenticationTypeValue());
        }
        if (this.userName != null) {
            element.setAttribute("UserName", this.userName);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.ntlmUserName != null) {
            element.setAttribute("NtlmUserName", this.ntlmUserName);
        }
        if (this.ntlmPassword != null) {
            element.setAttribute("NtlmPassword", this.ntlmPassword);
        }
        if (this.ntlmDomainName != null) {
            element.setAttribute("NtlmDomainName", this.ntlmDomainName);
        }
        if (this.encrypt != null) {
            element.setAttribute("Encrypt", this.getOptEncryptValue());
        }
        if (this.modeEx != null) {
            element.setAttribute("ModeEx", this.getModeExValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LUHttpProxy ");
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getModeValue()).append("\" ");
            }
            if (this.lockMode != null) {
                strAttrs.append("LockMode=").append(this.lockMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.host != null) {
                strAttrs.append("Host=\"").append(AbstractSchema.checkXMLContent(this.host)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(AbstractSchema.checkXMLContent(this.port)).append("\" ");
            }
            if (this.httpsPort != null) {
                strAttrs.append("HttpsPort=\"").append(AbstractSchema.checkXMLContent(this.httpsPort)).append("\" ");
            }
            if (this.requireAuthentication != null) {
                strAttrs.append("RequireAuthentication=").append(this.requireAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.authenticationType != null) {
                strAttrs.append("AuthenticationType=\"").append(this.getOptAuthenticationTypeValue()).append("\" ");
            }
            if (this.userName != null) {
                strAttrs.append("UserName=\"").append(AbstractSchema.checkXMLContent(this.userName)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.ntlmUserName != null) {
                strAttrs.append("NtlmUserName=\"").append(AbstractSchema.checkXMLContent(this.ntlmUserName)).append("\" ");
            }
            if (this.ntlmPassword != null) {
                strAttrs.append("NtlmPassword=\"").append(AbstractSchema.checkXMLContent(this.ntlmPassword)).append("\" ");
            }
            if (this.ntlmDomainName != null) {
                strAttrs.append("NtlmDomainName=\"").append(AbstractSchema.checkXMLContent(this.ntlmDomainName)).append("\" ");
            }
            if (this.encrypt != null) {
                strAttrs.append("Encrypt=\"").append(this.getOptEncryptValue()).append("\" ");
            }
            if (this.modeEx != null) {
                strAttrs.append("ModeEx=\"").append(this.getModeExValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LUHttpProxy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

