/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LUFtpProxy
extends AbstractSchema {
    public static final Integer NONE = 0;
    public static final Integer SYSTEM = 1;
    public static final Integer CUSTOM = 2;
    public static final Integer CLIENT_SIDE = 1;
    private static final long serialVersionUID = 1L;
    private Integer mode;
    private Boolean lockMode;
    private String host;
    private String port;
    private Boolean requireAuthentication;
    private String userName;
    private String password;
    private Integer encrypt;

    public LUFtpProxy() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "LUFtpProxy";
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "SYSTEM";
                break;
            }
            case 2: {
                s = "CUSTOM";
                break;
            }
            default: {
                throw new ValidationException("LUFtpProxy/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.mode = value;
    }

    public void setModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NONE".equals(value)) {
            this.mode = NONE;
        } else if ("SYSTEM".equals(value)) {
            this.mode = SYSTEM;
        } else if ("CUSTOM".equals(value)) {
            this.mode = CUSTOM;
        } else {
            throw new ValidationException("LUFtpProxy/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockMode() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockMode() {
        return this.lockMode;
    }

    public void setOptLockMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockMode = value;
    }

    public String getOptHost() {
        return this.host;
    }

    public void setOptHost(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.host = value;
    }

    public String getOptPort() {
        return this.port;
    }

    public void setOptPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public Boolean getDefRequireAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptRequireAuthentication() {
        return this.requireAuthentication;
    }

    public void setOptRequireAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.requireAuthentication = value;
    }

    public String getOptUserName() {
        return this.userName;
    }

    public void setOptUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.userName = value;
    }

    public String getOptPassword() {
        return this.password;
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.password = value;
    }

    public Integer getDefEncrypt() {
        return CLIENT_SIDE;
    }

    public Integer getOptEncrypt() {
        return this.encrypt;
    }

    public String getOptEncryptValue() throws ValidationException {
        if (this.encrypt == null) {
            return null;
        }
        String s = null;
        switch (this.encrypt) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "CLIENT_SIDE";
                break;
            }
            default: {
                throw new ValidationException("LUFtpProxy/Encrypt: invalid attribute value:" + this.encrypt + "!");
            }
        }
        return s;
    }

    public void setOptEncrypt(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.encrypt = value;
    }

    public void setOptEncryptValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.encrypt = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.encrypt = NONE;
        } else if ("CLIENT_SIDE".equals(value)) {
            this.encrypt = CLIENT_SIDE;
        } else {
            throw new ValidationException("LUFtpProxy/Encrypt: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 328245;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.mode == null) {
            throw new ValidationException("LUFtpProxy/Mode: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Mode");
            if (value == null) {
                throw new ValidationException("LUFtpProxy/Mode: attribute is required!");
            }
            this.setModeValue(value);
            value = attris.getValue("LockMode");
            if (value != null) {
                this.lockMode = "1".equals(value);
            }
            if ((value = attris.getValue("Host")) != null) {
                this.host = value;
            }
            if ((value = attris.getValue("Port")) != null) {
                this.port = value;
            }
            if ((value = attris.getValue("RequireAuthentication")) != null) {
                this.requireAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("UserName")) != null) {
                this.userName = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("Encrypt")) != null) {
                this.setOptEncryptValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LUFtpProxy".equals(element.getNodeName())) {
            throw new ValidationException("LUFtpProxy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Mode");
        if (value == null) {
            throw new ValidationException("LUFtpProxy/Mode: attribute is required!");
        }
        this.setModeValue(value);
        value = XMLHelper.getAttribute(element, "LockMode");
        if (value != null) {
            this.lockMode = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Host")) != null) {
            this.host = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            this.port = value;
        }
        if ((value = XMLHelper.getAttribute(element, "RequireAuthentication")) != null) {
            this.requireAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UserName")) != null) {
            this.userName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Encrypt")) != null) {
            this.setOptEncryptValue(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("LUFtpProxy");
        if (this.mode != null) {
            element.setAttribute("Mode", this.getModeValue());
        }
        if (this.lockMode != null) {
            element.setAttribute("LockMode", this.lockMode != false ? "1" : "0");
        }
        if (this.host != null) {
            element.setAttribute("Host", this.host);
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port);
        }
        if (this.requireAuthentication != null) {
            element.setAttribute("RequireAuthentication", this.requireAuthentication != false ? "1" : "0");
        }
        if (this.userName != null) {
            element.setAttribute("UserName", this.userName);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.encrypt != null) {
            element.setAttribute("Encrypt", this.getOptEncryptValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LUFtpProxy ");
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getModeValue()).append("\" ");
            }
            if (this.lockMode != null) {
                strAttrs.append("LockMode=").append(this.lockMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.host != null) {
                strAttrs.append("Host=\"").append(AbstractSchema.checkXMLContent(this.host)).append("\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(AbstractSchema.checkXMLContent(this.port)).append("\" ");
            }
            if (this.requireAuthentication != null) {
                strAttrs.append("RequireAuthentication=").append(this.requireAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.userName != null) {
                strAttrs.append("UserName=\"").append(AbstractSchema.checkXMLContent(this.userName)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.encrypt != null) {
                strAttrs.append("Encrypt=\"").append(this.getOptEncryptValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LUFtpProxy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

