/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LUChannelFailoverMode
extends AbstractSchema {
    public static final Integer HOURS = 0;
    public static final Integer MINUTES = 1;
    private static final long serialVersionUID = 1L;
    private Boolean enabled;
    private Integer disconnectDuration;
    private Integer frequency;

    public LUChannelFailoverMode() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "LUChannelFailoverMode";
    }

    public Boolean getDefEnabled() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnabled() {
        return this.enabled;
    }

    public void setOptEnabled(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enabled = value;
    }

    public Integer getDefDisconnectDuration() {
        return 8;
    }

    public Integer getOptDisconnectDuration() {
        return this.disconnectDuration;
    }

    public void setOptDisconnectDuration(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.disconnectDuration = value;
    }

    public Integer getDefFrequency() {
        return HOURS;
    }

    public Integer getOptFrequency() {
        return this.frequency;
    }

    public String getOptFrequencyValue() throws ValidationException {
        if (this.frequency == null) {
            return null;
        }
        String s = null;
        switch (this.frequency) {
            case 0: {
                s = "HOURS";
                break;
            }
            case 1: {
                s = "MINUTES";
                break;
            }
            default: {
                throw new ValidationException("LUChannelFailoverMode/Frequency: invalid attribute value:" + this.frequency + "!");
            }
        }
        return s;
    }

    public void setOptFrequency(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.frequency = value;
    }

    public void setOptFrequencyValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.frequency = null;
            return;
        }
        if ("HOURS".equals(value)) {
            this.frequency = HOURS;
        } else if ("MINUTES".equals(value)) {
            this.frequency = MINUTES;
        } else {
            throw new ValidationException("LUChannelFailoverMode/Frequency: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 328203;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enabled");
            if (value != null) {
                this.enabled = "1".equals(value);
            }
            if ((value = attris.getValue("DisconnectDuration")) != null) {
                try {
                    this.disconnectDuration = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("LUChannelFailoverMode/DisconnectDuration: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("LUChannelFailoverMode/DisconnectDuration: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            if ((value = attris.getValue("Frequency")) != null) {
                this.setOptFrequencyValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LUChannelFailoverMode".equals(element.getNodeName())) {
            throw new ValidationException("LUChannelFailoverMode: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enabled");
        if (value != null) {
            this.enabled = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "DisconnectDuration")) != null) {
            try {
                this.disconnectDuration = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("LUChannelFailoverMode/DisconnectDuration: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        if ((value = XMLHelper.getAttribute(element, "Frequency")) != null) {
            this.setOptFrequencyValue(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("LUChannelFailoverMode");
        if (this.enabled != null) {
            element.setAttribute("Enabled", this.enabled != false ? "1" : "0");
        }
        if (this.disconnectDuration != null) {
            element.setAttribute("DisconnectDuration", this.disconnectDuration.toString());
        }
        if (this.frequency != null) {
            element.setAttribute("Frequency", this.getOptFrequencyValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LUChannelFailoverMode ");
            if (this.enabled != null) {
                strAttrs.append("Enabled=").append(this.enabled != false ? "\"1\" " : "\"0\" ");
            }
            if (this.disconnectDuration != null) {
                strAttrs.append("DisconnectDuration=\"").append(this.disconnectDuration.toString()).append("\" ");
            }
            if (this.frequency != null) {
                strAttrs.append("Frequency=\"").append(this.getOptFrequencyValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LUChannelFailoverMode>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

