/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LUCentralServer
extends AbstractSchema {
    public static final Integer HTTP = 0;
    public static final Integer HTTPS = 1;
    public static final Integer FTP = 2;
    public static final Integer LAN = 3;
    public static final Integer NONE = 0;
    public static final Integer CLIENT_SIDE = 1;
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Integer protocol;
    private String uRL;
    private String userName;
    private String password;
    private Integer encrypt;
    private String encryptedPassword;

    public LUCentralServer() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "LUCentralServer";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.description = value;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public String getProtocolValue() throws ValidationException {
        if (this.protocol == null) {
            return null;
        }
        String s = null;
        switch (this.protocol) {
            case 0: {
                s = "HTTP";
                break;
            }
            case 1: {
                s = "HTTPS";
                break;
            }
            case 2: {
                s = "FTP";
                break;
            }
            case 3: {
                s = "LAN";
                break;
            }
            default: {
                throw new ValidationException("LUCentralServer/Protocol: invalid attribute value:" + this.protocol + "!");
            }
        }
        return s;
    }

    public void setProtocol(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.protocol = value;
    }

    public void setProtocolValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("HTTP".equals(value)) {
            this.protocol = HTTP;
        } else if ("HTTPS".equals(value)) {
            this.protocol = HTTPS;
        } else if ("FTP".equals(value)) {
            this.protocol = FTP;
        } else if ("LAN".equals(value)) {
            this.protocol = LAN;
        } else {
            throw new ValidationException("LUCentralServer/Protocol: invalid attribute value:" + value + "!");
        }
    }

    public String getURL() {
        return this.uRL;
    }

    public void setURL(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.uRL = value;
    }

    public String getOptUserName() {
        return this.userName;
    }

    public void setOptUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.userName = value;
    }

    public String getOptPassword() {
        return this.password;
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.password = value;
    }

    public Integer getDefEncrypt() {
        return CLIENT_SIDE;
    }

    public Integer getOptEncrypt() {
        return this.encrypt;
    }

    public String getOptEncryptValue() throws ValidationException {
        if (this.encrypt == null) {
            return null;
        }
        String s = null;
        switch (this.encrypt) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "CLIENT_SIDE";
                break;
            }
            default: {
                throw new ValidationException("LUCentralServer/Encrypt: invalid attribute value:" + this.encrypt + "!");
            }
        }
        return s;
    }

    public void setOptEncrypt(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.encrypt = value;
    }

    public void setOptEncryptValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.encrypt = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.encrypt = NONE;
        } else if ("CLIENT_SIDE".equals(value)) {
            this.encrypt = CLIENT_SIDE;
        } else {
            throw new ValidationException("LUCentralServer/Encrypt: invalid attribute value:" + value + "!");
        }
    }

    public String getOptEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setOptEncryptedPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.encryptedPassword = value;
    }

    @Override
    public int getObjectType() {
        return 328185;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("LUCentralServer/Name: attribute is required!");
        }
        if (this.protocol == null) {
            throw new ValidationException("LUCentralServer/Protocol: attribute is required!");
        }
        if (this.uRL == null) {
            throw new ValidationException("LUCentralServer/URL: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("LUCentralServer/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("Protocol")) == null) {
                throw new ValidationException("LUCentralServer/Protocol: attribute is required!");
            }
            this.setProtocolValue(value);
            value = attris.getValue("URL");
            if (value == null) {
                throw new ValidationException("LUCentralServer/URL: attribute is required!");
            }
            this.uRL = value;
            value = attris.getValue("UserName");
            if (value != null) {
                this.userName = value;
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("Encrypt")) != null) {
                this.setOptEncryptValue(value);
            }
            if ((value = attris.getValue("EncryptedPassword")) != null) {
                this.encryptedPassword = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"LUCentralServer".equals(element.getNodeName())) {
            throw new ValidationException("LUCentralServer: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("LUCentralServer/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Protocol")) == null) {
            throw new ValidationException("LUCentralServer/Protocol: attribute is required!");
        }
        this.setProtocolValue(value);
        value = XMLHelper.getAttribute(element, "URL");
        if (value == null) {
            throw new ValidationException("LUCentralServer/URL: attribute is required!");
        }
        this.uRL = value;
        value = XMLHelper.getAttribute(element, "UserName");
        if (value != null) {
            this.userName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Encrypt")) != null) {
            this.setOptEncryptValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EncryptedPassword")) != null) {
            this.encryptedPassword = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("LUCentralServer");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.protocol != null) {
            element.setAttribute("Protocol", this.getProtocolValue());
        }
        if (this.uRL != null) {
            element.setAttribute("URL", this.uRL);
        }
        if (this.userName != null) {
            element.setAttribute("UserName", this.userName);
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.encrypt != null) {
            element.setAttribute("Encrypt", this.getOptEncryptValue());
        }
        if (this.encryptedPassword != null) {
            element.setAttribute("EncryptedPassword", this.encryptedPassword);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<LUCentralServer ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.protocol != null) {
                strAttrs.append("Protocol=\"").append(this.getProtocolValue()).append("\" ");
            }
            if (this.uRL != null) {
                strAttrs.append("URL=\"").append(AbstractSchema.checkXMLContent(this.uRL)).append("\" ");
            }
            if (this.userName != null) {
                strAttrs.append("UserName=\"").append(AbstractSchema.checkXMLContent(this.userName)).append("\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.encrypt != null) {
                strAttrs.append("Encrypt=\"").append(this.getOptEncryptValue()).append("\" ");
            }
            if (this.encryptedPassword != null) {
                strAttrs.append("EncryptedPassword=\"").append(AbstractSchema.checkXMLContent(this.encryptedPassword)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</LUCentralServer>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

