/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.IdsSignature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IdsSignatureGroup
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String id;
    private String name;
    private String description;
    private Long severity;
    private String applicationGroupLink;

    public IdsSignatureGroup() {
        this.nameSpace = "agent";
        this.children.put(328163, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "IdsSignatureGroup";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public String getOptId() {
        return this.id;
    }

    public void setOptId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.description = value;
    }

    public Long getSeverity() {
        return this.severity;
    }

    public void setSeverity(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.severity = value;
    }

    public String getOptApplicationGroupLink() {
        return this.applicationGroupLink;
    }

    public void setOptApplicationGroupLink(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.applicationGroupLink = value;
    }

    public void addIdsSignature(IdsSignature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIdsSignature(int index, IdsSignature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IdsSignature> getIdsSignature() {
        Vector<IdsSignature> v = new Vector<IdsSignature>();
        for (Transportable child : (ChildGroup)this.children.get(328163)) {
            v.add((IdsSignature)child);
        }
        return v;
    }

    public int getIdsSignatureCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328163);
        return childGroup.size();
    }

    public IdsSignature getIdsSignature(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328163);
        return (IdsSignature)childGroup.get(index);
    }

    public void setIdsSignature(int index, IdsSignature value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIdsSignature(IdsSignature value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 328162;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("IdsSignatureGroup/Name: attribute is required!");
        }
        if (this.severity == null) {
            throw new ValidationException("IdsSignatureGroup/Severity: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof IdsSignature) {
            try {
                this.addIdsSignature((IdsSignature)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Id")) != null) {
                this.id = value;
            }
            if ((value = attris.getValue("Name")) == null) {
                throw new ValidationException("IdsSignatureGroup/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("Severity")) == null) {
                throw new ValidationException("IdsSignatureGroup/Severity: attribute is required!");
            }
            try {
                this.severity = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("IdsSignatureGroup/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("IdsSignatureGroup/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("ApplicationGroupLink");
            if (value != null) {
                this.applicationGroupLink = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        int objCnt = this.getIdsSignatureCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getIdsSignature(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"IdsSignatureGroup".equals(element.getNodeName())) {
            throw new ValidationException("IdsSignatureGroup: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Id")) != null) {
            this.id = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Name")) == null) {
            throw new ValidationException("IdsSignatureGroup/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Severity")) == null) {
            throw new ValidationException("IdsSignatureGroup/Severity: attribute is required!");
        }
        try {
            this.severity = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("IdsSignatureGroup/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("IdsSignatureGroup/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "ApplicationGroupLink");
        if (value != null) {
            this.applicationGroupLink = value;
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "IdsSignature");
        for (int i = 0; i < v.size(); ++i) {
            IdsSignature idsSignatureObj = new IdsSignature();
            idsSignatureObj.importFromElement(v.get(i));
            this.addIdsSignature(idsSignatureObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("IdsSignatureGroup");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.severity != null) {
            element.setAttribute("Severity", this.severity.toString());
        }
        if (this.applicationGroupLink != null) {
            element.setAttribute("ApplicationGroupLink", this.applicationGroupLink);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IdsSignatureGroup ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.severity != null) {
                strAttrs.append("Severity=\"").append(this.severity.toString()).append("\" ");
            }
            if (this.applicationGroupLink != null) {
                strAttrs.append("ApplicationGroupLink=\"").append(AbstractSchema.checkXMLContent(this.applicationGroupLink)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IdsSignatureGroup>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

