/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.Action;
import com.sygate.scm.common.configobject.agent.IdsTrafficCondition;
import com.sygate.scm.common.configobject.agent.SignatureLink;
import com.sygate.scm.common.configobject.agent.TriggerExpiration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IdsSignature
extends AbstractSchema {
    public static final Integer UNKNOWN = 0;
    public static final Integer ACTIVE = 1;
    public static final Integer PASSIVE = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private String id;
    private String name;
    private String description;
    private Long severity;
    private Integer hostType;

    public IdsSignature() {
        this.nameSpace = "agent";
        this.children.put(328164, new ChildGroup(1, 1));
        this.children.put(328074, new ChildGroup(1, 1));
        this.children.put(328165, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(328166, new ChildGroup(0, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "IdsSignature";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public String getOptDescription() {
        return this.description;
    }

    public void setOptDescription(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.description = value;
    }

    public Long getSeverity() {
        return this.severity;
    }

    public void setSeverity(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.severity = value;
    }

    public Integer getDefHostType() {
        return UNKNOWN;
    }

    public Integer getOptHostType() {
        return this.hostType;
    }

    public String getOptHostTypeValue() throws ValidationException {
        if (this.hostType == null) {
            return null;
        }
        String s = null;
        switch (this.hostType) {
            case 0: {
                s = "UNKNOWN";
                break;
            }
            case 1: {
                s = "ACTIVE";
                break;
            }
            case 2: {
                s = "PASSIVE";
                break;
            }
            default: {
                throw new ValidationException("IdsSignature/HostType: invalid attribute value:" + this.hostType + "!");
            }
        }
        return s;
    }

    public void setOptHostType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.hostType = value;
    }

    public void setOptHostTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.hostType = null;
            return;
        }
        if ("UNKNOWN".equals(value)) {
            this.hostType = UNKNOWN;
        } else if ("ACTIVE".equals(value)) {
            this.hostType = ACTIVE;
        } else if ("PASSIVE".equals(value)) {
            this.hostType = PASSIVE;
        } else {
            throw new ValidationException("IdsSignature/HostType: invalid attribute value:" + value + "!");
        }
    }

    public IdsTrafficCondition getIdsTrafficCondition() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328164);
        if (childGroup.size() > 0) {
            return (IdsTrafficCondition)childGroup.get(0);
        }
        return null;
    }

    public void setIdsTrafficCondition(IdsTrafficCondition value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            IdsTrafficCondition obj = this.getIdsTrafficCondition();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public Action getAction() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328074);
        if (childGroup.size() > 0) {
            return (Action)childGroup.get(0);
        }
        return null;
    }

    public void setAction(Action value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Action obj = this.getAction();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    public void addSignatureLink(SignatureLink value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addSignatureLink(int index, SignatureLink value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<SignatureLink> getSignatureLink() {
        Vector<SignatureLink> v = new Vector<SignatureLink>();
        for (Transportable child : (ChildGroup)this.children.get(328165)) {
            v.add((SignatureLink)child);
        }
        return v;
    }

    public int getSignatureLinkCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328165);
        return childGroup.size();
    }

    public SignatureLink getSignatureLink(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328165);
        return (SignatureLink)childGroup.get(index);
    }

    public void setSignatureLink(int index, SignatureLink value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeSignatureLink(SignatureLink value) {
        this.removeChild(value);
    }

    public TriggerExpiration getOptTriggerExpiration() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328166);
        if (childGroup.size() > 0) {
            return (TriggerExpiration)childGroup.get(0);
        }
        return null;
    }

    public void setOptTriggerExpiration(TriggerExpiration value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            TriggerExpiration obj = this.getOptTriggerExpiration();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 328163;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.id == null) {
            throw new ValidationException("IdsSignature/Id: attribute is required!");
        }
        if (this.name == null) {
            throw new ValidationException("IdsSignature/Name: attribute is required!");
        }
        if (this.severity == null) {
            throw new ValidationException("IdsSignature/Severity: attribute is required!");
        }
        if (this.getIdsTrafficCondition() == null) {
            throw new ValidationException("IdsSignature/IdsTrafficCondition: attribute is required!");
        }
        if (this.getAction() == null) {
            throw new ValidationException("IdsSignature/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof IdsTrafficCondition) {
            try {
                this.setIdsTrafficCondition((IdsTrafficCondition)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Action) {
            try {
                this.setAction((Action)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof SignatureLink) {
            try {
                this.addSignatureLink((SignatureLink)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof TriggerExpiration) {
            try {
                this.setOptTriggerExpiration((TriggerExpiration)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Id")) == null) {
                throw new ValidationException("IdsSignature/Id: attribute is required!");
            }
            this.id = value;
            value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("IdsSignature/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("Description");
            if (value != null) {
                this.description = value;
            }
            if ((value = attris.getValue("Severity")) == null) {
                throw new ValidationException("IdsSignature/Severity: attribute is required!");
            }
            try {
                this.severity = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("HostType");
            if (value != null) {
                this.setOptHostTypeValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getIdsTrafficCondition() != null) {
            this.getIdsTrafficCondition().setReadonly();
        }
        if (this.getAction() != null) {
            this.getAction().setReadonly();
        }
        int objCnt = this.getSignatureLinkCount();
        for (int i = 0; i < objCnt; ++i) {
            this.getSignatureLink(i).setReadonly();
        }
        if (this.getOptTriggerExpiration() != null) {
            this.getOptTriggerExpiration().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(328164)).size();
        }
        catch (Throwable t) {
            throw new SAXException("IdsSignature: can't import element == IdsTrafficCondition!");
        }
        try {
            ((ChildGroup)this.children.get(328074)).size();
        }
        catch (Throwable t) {
            throw new SAXException("IdsSignature: can't import element == Action!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"IdsSignature".equals(element.getNodeName())) {
            throw new ValidationException("IdsSignature: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Id")) == null) {
            throw new ValidationException("IdsSignature/Id: attribute is required!");
        }
        this.id = value;
        value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("IdsSignature/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "Description");
        if (value != null) {
            this.description = value;
        }
        if ((value = XMLHelper.getAttribute(element, "Severity")) == null) {
            throw new ValidationException("IdsSignature/Severity: attribute is required!");
        }
        try {
            this.severity = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("IdsSignature/Severity: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "HostType");
        if (value != null) {
            this.setOptHostTypeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "IdsTrafficCondition")).size() != 1) {
            throw new ValidationException("IdsSignature/IdsTrafficCondition: element is require!");
        }
        IdsTrafficCondition idsTrafficConditionObj = new IdsTrafficCondition();
        idsTrafficConditionObj.importFromElement(v.get(0));
        this.setIdsTrafficCondition(idsTrafficConditionObj);
        v = XMLHelper.getChildElementByName(element, "Action");
        if (v.size() != 1) {
            throw new ValidationException("IdsSignature/Action: element is require!");
        }
        Action actionObj = new Action();
        actionObj.importFromElement(v.get(0));
        this.setAction(actionObj);
        v = XMLHelper.getChildElementByName(element, "SignatureLink");
        for (int i = 0; i < v.size(); ++i) {
            SignatureLink signatureLinkObj = new SignatureLink();
            signatureLinkObj.importFromElement(v.get(i));
            this.addSignatureLink(signatureLinkObj);
        }
        v = XMLHelper.getChildElementByName(element, "TriggerExpiration");
        if (v.size() > 0) {
            TriggerExpiration triggerExpirationObj = new TriggerExpiration();
            triggerExpirationObj.importFromElement(v.get(0));
            this.setOptTriggerExpiration(triggerExpirationObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("IdsSignature");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.id != null) {
            element.setAttribute("Id", this.id);
        }
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("Description", this.description);
        }
        if (this.severity != null) {
            element.setAttribute("Severity", this.severity.toString());
        }
        if (this.hostType != null) {
            element.setAttribute("HostType", this.getOptHostTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<IdsSignature ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.id != null) {
                strAttrs.append("Id=\"").append(AbstractSchema.checkXMLContent(this.id)).append("\" ");
            }
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.description != null) {
                strAttrs.append("Description=\"").append(AbstractSchema.checkXMLContent(this.description)).append("\" ");
            }
            if (this.severity != null) {
                strAttrs.append("Severity=\"").append(this.severity.toString()).append("\" ");
            }
            if (this.hostType != null) {
                strAttrs.append("HostType=\"").append(this.getOptHostTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</IdsSignature>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

