/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.DnsHost;
import com.sygate.scm.common.configobject.agent.IpAddress;
import com.sygate.scm.common.configobject.agent.Ipv6Address;
import com.sygate.scm.common.configobject.agent.Link;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ICMPRequest
extends AbstractSchema {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    public static final Integer MATCH_ALL_HOST_ADDR = 0;
    public static final Integer MATCH_ANY_HOST_ADDR = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private Integer mode;
    private Integer frequency;

    public ICMPRequest() {
        this.nameSpace = "agent";
        this.children.put(328064, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(328061, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(327773, new ChildGroup(0, Integer.MAX_VALUE));
        this.children.put(328066, new ChildGroup(0, Integer.MAX_VALUE));
    }

    @Override
    public String getObjectTypeName() {
        return "ICMPRequest";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("ICMPRequest/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("ICMPRequest/Operator: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefMode() {
        return MATCH_ALL_HOST_ADDR;
    }

    public Integer getOptMode() {
        return this.mode;
    }

    public String getOptModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "MATCH_ALL_HOST_ADDR";
                break;
            }
            case 1: {
                s = "MATCH_ANY_HOST_ADDR";
                break;
            }
            default: {
                throw new ValidationException("ICMPRequest/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setOptMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.mode = value;
    }

    public void setOptModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.mode = null;
            return;
        }
        if ("MATCH_ALL_HOST_ADDR".equals(value)) {
            this.mode = MATCH_ALL_HOST_ADDR;
        } else if ("MATCH_ANY_HOST_ADDR".equals(value)) {
            this.mode = MATCH_ANY_HOST_ADDR;
        } else {
            throw new ValidationException("ICMPRequest/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Integer getOptFrequency() {
        return this.frequency;
    }

    public void setOptFrequency(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.frequency = value;
    }

    public void addDnsHost(DnsHost value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addDnsHost(int index, DnsHost value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<DnsHost> getDnsHost() {
        Vector<DnsHost> v = new Vector<DnsHost>();
        for (Transportable child : (ChildGroup)this.children.get(328064)) {
            v.add((DnsHost)child);
        }
        return v;
    }

    public int getDnsHostCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328064);
        return childGroup.size();
    }

    public DnsHost getDnsHost(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328064);
        return (DnsHost)childGroup.get(index);
    }

    public void setDnsHost(int index, DnsHost value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeDnsHost(DnsHost value) {
        this.removeChild(value);
    }

    public void addIpAddress(IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<IpAddress> getIpAddress() {
        Vector<IpAddress> v = new Vector<IpAddress>();
        for (Transportable child : (ChildGroup)this.children.get(328061)) {
            v.add((IpAddress)child);
        }
        return v;
    }

    public int getIpAddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328061);
        return childGroup.size();
    }

    public IpAddress getIpAddress(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328061);
        return (IpAddress)childGroup.get(index);
    }

    public void setIpAddress(int index, IpAddress value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpAddress(IpAddress value) {
        this.removeChild(value);
    }

    public void addLink(Link value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addLink(int index, Link value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Link> getLink() {
        Vector<Link> v = new Vector<Link>();
        for (Transportable child : (ChildGroup)this.children.get(327773)) {
            v.add((Link)child);
        }
        return v;
    }

    public int getLinkCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327773);
        return childGroup.size();
    }

    public Link getLink(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(327773);
        return (Link)childGroup.get(index);
    }

    public void setLink(int index, Link value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeLink(Link value) {
        this.removeChild(value);
    }

    public void addIpv6Address(Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(value);
    }

    public void addIpv6Address(int index, Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.addChild(index, value);
    }

    public Vector<Ipv6Address> getIpv6Address() {
        Vector<Ipv6Address> v = new Vector<Ipv6Address>();
        for (Transportable child : (ChildGroup)this.children.get(328066)) {
            v.add((Ipv6Address)child);
        }
        return v;
    }

    public int getIpv6AddressCount() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328066);
        return childGroup.size();
    }

    public Ipv6Address getIpv6Address(int index) {
        ChildGroup childGroup = (ChildGroup)this.children.get(328066);
        return (Ipv6Address)childGroup.get(index);
    }

    public void setIpv6Address(int index, Ipv6Address value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.setChild(index, value);
    }

    public void removeIpv6Address(Ipv6Address value) {
        this.removeChild(value);
    }

    @Override
    public int getObjectType() {
        return 328214;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof DnsHost) {
            try {
                this.addDnsHost((DnsHost)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof IpAddress) {
            try {
                this.addIpAddress((IpAddress)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Link) {
            try {
                this.addLink((Link)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (sonObject instanceof Ipv6Address) {
            try {
                this.addIpv6Address((Ipv6Address)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        block8: {
            try {
                String value = attris.getValue("Operator");
                if (value != null) {
                    this.setOptOperatorValue(value);
                }
                if ((value = attris.getValue("Mode")) != null) {
                    this.setOptModeValue(value);
                }
                if ((value = attris.getValue("Frequency")) == null) break block8;
                try {
                    this.frequency = Integer.valueOf(value);
                }
                catch (RuntimeException e) {
                    throw new ValidationException("ICMPRequest/Frequency: invalid attribute value:" + value + "! " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ValidationException("ICMPRequest/Frequency: invalid attribute value:" + value + "! " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void setReadonly() {
        int i;
        super.setReadonly();
        int objCnt = this.getDnsHostCount();
        for (i = 0; i < objCnt; ++i) {
            this.getDnsHost(i).setReadonly();
        }
        objCnt = this.getIpAddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpAddress(i).setReadonly();
        }
        objCnt = this.getLinkCount();
        for (i = 0; i < objCnt; ++i) {
            this.getLink(i).setReadonly();
        }
        objCnt = this.getIpv6AddressCount();
        for (i = 0; i < objCnt; ++i) {
            this.getIpv6Address(i).setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        int i;
        if (!"ICMPRequest".equals(element.getNodeName())) {
            throw new ValidationException("ICMPRequest: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Mode")) != null) {
            this.setOptModeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Frequency")) != null) {
            try {
                this.frequency = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new ValidationException("ICMPRequest/Frequency: invalid attribute value:" + value + "! " + e.getMessage());
            }
        }
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "DnsHost");
        for (i = 0; i < v.size(); ++i) {
            DnsHost dnsHostObj = new DnsHost();
            dnsHostObj.importFromElement(v.get(i));
            this.addDnsHost(dnsHostObj);
        }
        v = XMLHelper.getChildElementByName(element, "IpAddress");
        for (i = 0; i < v.size(); ++i) {
            IpAddress ipAddressObj = new IpAddress();
            ipAddressObj.importFromElement(v.get(i));
            this.addIpAddress(ipAddressObj);
        }
        v = XMLHelper.getChildElementByName(element, "Link");
        for (i = 0; i < v.size(); ++i) {
            Link linkObj = new Link();
            linkObj.importFromElement(v.get(i));
            this.addLink(linkObj);
        }
        v = XMLHelper.getChildElementByName(element, "Ipv6Address");
        for (i = 0; i < v.size(); ++i) {
            Ipv6Address ipv6AddressObj = new Ipv6Address();
            ipv6AddressObj.importFromElement(v.get(i));
            this.addIpv6Address(ipv6AddressObj);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("ICMPRequest");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.mode != null) {
            element.setAttribute("Mode", this.getOptModeValue());
        }
        if (this.frequency != null) {
            element.setAttribute("Frequency", this.frequency.toString());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<ICMPRequest ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getOptModeValue()).append("\" ");
            }
            if (this.frequency != null) {
                strAttrs.append("Frequency=\"").append(this.frequency.toString()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</ICMPRequest>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

