/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HttpProxy
extends AbstractSchema {
    public static final Integer NONE = 0;
    public static final Integer SYSTEM = 1;
    public static final Integer CUSTOM = 2;
    public static final Integer CLIENT_SIDE = 1;
    public static final Integer BASIC = 0;
    public static final Integer NTLM = 1;
    private static final long serialVersionUID = 1L;
    private Integer mode;
    private Boolean lockMode;
    private String host;
    private Boolean lockHost;
    private String port;
    private Boolean lockPort;
    private String httpsPort;
    private Boolean lockHttpsPort;
    private Boolean requireAuthentication;
    private Boolean lockRequireAuthentication;
    private String userName;
    private Boolean lockUserName;
    private String password;
    private Boolean lockPassword;
    private Integer encrypt;
    private Boolean lockEncrypt;
    private Integer authenticationType;
    private Boolean lockAuthenticationType;
    private String ntlmFullUserName;
    private Boolean lockNtlmFullUserName;
    private String ntlmPassword;
    private Boolean lockNtlmPassword;

    public HttpProxy() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "HttpProxy";
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "SYSTEM";
                break;
            }
            case 2: {
                s = "CUSTOM";
                break;
            }
            default: {
                throw new ValidationException("HttpProxy/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.mode = value;
    }

    public void setModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("NONE".equals(value)) {
            this.mode = NONE;
        } else if ("SYSTEM".equals(value)) {
            this.mode = SYSTEM;
        } else if ("CUSTOM".equals(value)) {
            this.mode = CUSTOM;
        } else {
            throw new ValidationException("HttpProxy/Mode: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockMode() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockMode() {
        return this.lockMode;
    }

    public void setOptLockMode(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockMode = value;
    }

    public String getOptHost() {
        return this.host;
    }

    public void setOptHost(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.host = value;
    }

    public Boolean getDefLockHost() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockHost() {
        return this.lockHost;
    }

    public void setOptLockHost(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockHost = value;
    }

    public String getOptPort() {
        return this.port;
    }

    public void setOptPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.port = value;
    }

    public Boolean getDefLockPort() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockPort() {
        return this.lockPort;
    }

    public void setOptLockPort(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockPort = value;
    }

    public String getOptHttpsPort() {
        return this.httpsPort;
    }

    public void setOptHttpsPort(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.httpsPort = value;
    }

    public Boolean getDefLockHttpsPort() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockHttpsPort() {
        return this.lockHttpsPort;
    }

    public void setOptLockHttpsPort(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockHttpsPort = value;
    }

    public Boolean getDefRequireAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptRequireAuthentication() {
        return this.requireAuthentication;
    }

    public void setOptRequireAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.requireAuthentication = value;
    }

    public Boolean getDefLockRequireAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockRequireAuthentication() {
        return this.lockRequireAuthentication;
    }

    public void setOptLockRequireAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockRequireAuthentication = value;
    }

    public String getOptUserName() {
        return this.userName;
    }

    public void setOptUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.userName = value;
    }

    public Boolean getDefLockUserName() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockUserName() {
        return this.lockUserName;
    }

    public void setOptLockUserName(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockUserName = value;
    }

    public String getOptPassword() {
        return this.password;
    }

    public void setOptPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.password = value;
    }

    public Boolean getDefLockPassword() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockPassword() {
        return this.lockPassword;
    }

    public void setOptLockPassword(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockPassword = value;
    }

    public Integer getDefEncrypt() {
        return CLIENT_SIDE;
    }

    public Integer getOptEncrypt() {
        return this.encrypt;
    }

    public String getOptEncryptValue() throws ValidationException {
        if (this.encrypt == null) {
            return null;
        }
        String s = null;
        switch (this.encrypt) {
            case 0: {
                s = "NONE";
                break;
            }
            case 1: {
                s = "CLIENT_SIDE";
                break;
            }
            default: {
                throw new ValidationException("HttpProxy/Encrypt: invalid attribute value:" + this.encrypt + "!");
            }
        }
        return s;
    }

    public void setOptEncrypt(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.encrypt = value;
    }

    public void setOptEncryptValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.encrypt = null;
            return;
        }
        if ("NONE".equals(value)) {
            this.encrypt = NONE;
        } else if ("CLIENT_SIDE".equals(value)) {
            this.encrypt = CLIENT_SIDE;
        } else {
            throw new ValidationException("HttpProxy/Encrypt: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockEncrypt() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockEncrypt() {
        return this.lockEncrypt;
    }

    public void setOptLockEncrypt(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockEncrypt = value;
    }

    public Integer getDefAuthenticationType() {
        return BASIC;
    }

    public Integer getOptAuthenticationType() {
        return this.authenticationType;
    }

    public String getOptAuthenticationTypeValue() throws ValidationException {
        if (this.authenticationType == null) {
            return null;
        }
        String s = null;
        switch (this.authenticationType) {
            case 0: {
                s = "BASIC";
                break;
            }
            case 1: {
                s = "NTLM";
                break;
            }
            default: {
                throw new ValidationException("HttpProxy/AuthenticationType: invalid attribute value:" + this.authenticationType + "!");
            }
        }
        return s;
    }

    public void setOptAuthenticationType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.authenticationType = value;
    }

    public void setOptAuthenticationTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.authenticationType = null;
            return;
        }
        if ("BASIC".equals(value)) {
            this.authenticationType = BASIC;
        } else if ("NTLM".equals(value)) {
            this.authenticationType = NTLM;
        } else {
            throw new ValidationException("HttpProxy/AuthenticationType: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLockAuthenticationType() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockAuthenticationType() {
        return this.lockAuthenticationType;
    }

    public void setOptLockAuthenticationType(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockAuthenticationType = value;
    }

    public String getOptNtlmFullUserName() {
        return this.ntlmFullUserName;
    }

    public void setOptNtlmFullUserName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ntlmFullUserName = value;
    }

    public Boolean getDefLockNtlmFullUserName() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockNtlmFullUserName() {
        return this.lockNtlmFullUserName;
    }

    public void setOptLockNtlmFullUserName(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockNtlmFullUserName = value;
    }

    public String getOptNtlmPassword() {
        return this.ntlmPassword;
    }

    public void setOptNtlmPassword(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.ntlmPassword = value;
    }

    public Boolean getDefLockNtlmPassword() {
        return Boolean.FALSE;
    }

    public Boolean getOptLockNtlmPassword() {
        return this.lockNtlmPassword;
    }

    public void setOptLockNtlmPassword(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.lockNtlmPassword = value;
    }

    @Override
    public int getObjectType() {
        return 328186;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.mode == null) {
            throw new ValidationException("HttpProxy/Mode: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Mode");
            if (value == null) {
                throw new ValidationException("HttpProxy/Mode: attribute is required!");
            }
            this.setModeValue(value);
            value = attris.getValue("LockMode");
            if (value != null) {
                this.lockMode = "1".equals(value);
            }
            if ((value = attris.getValue("Host")) != null) {
                this.host = value;
            }
            if ((value = attris.getValue("LockHost")) != null) {
                this.lockHost = "1".equals(value);
            }
            if ((value = attris.getValue("Port")) != null) {
                this.port = value;
            }
            if ((value = attris.getValue("LockPort")) != null) {
                this.lockPort = "1".equals(value);
            }
            if ((value = attris.getValue("HttpsPort")) != null) {
                this.httpsPort = value;
            }
            if ((value = attris.getValue("LockHttpsPort")) != null) {
                this.lockHttpsPort = "1".equals(value);
            }
            if ((value = attris.getValue("RequireAuthentication")) != null) {
                this.requireAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("LockRequireAuthentication")) != null) {
                this.lockRequireAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("UserName")) != null) {
                this.userName = value;
            }
            if ((value = attris.getValue("LockUserName")) != null) {
                this.lockUserName = "1".equals(value);
            }
            if ((value = attris.getValue("Password")) != null) {
                this.password = value;
            }
            if ((value = attris.getValue("LockPassword")) != null) {
                this.lockPassword = "1".equals(value);
            }
            if ((value = attris.getValue("Encrypt")) != null) {
                this.setOptEncryptValue(value);
            }
            if ((value = attris.getValue("LockEncrypt")) != null) {
                this.lockEncrypt = "1".equals(value);
            }
            if ((value = attris.getValue("AuthenticationType")) != null) {
                this.setOptAuthenticationTypeValue(value);
            }
            if ((value = attris.getValue("LockAuthenticationType")) != null) {
                this.lockAuthenticationType = "1".equals(value);
            }
            if ((value = attris.getValue("NtlmFullUserName")) != null) {
                this.ntlmFullUserName = value;
            }
            if ((value = attris.getValue("LockNtlmFullUserName")) != null) {
                this.lockNtlmFullUserName = "1".equals(value);
            }
            if ((value = attris.getValue("NtlmPassword")) != null) {
                this.ntlmPassword = value;
            }
            if ((value = attris.getValue("LockNtlmPassword")) != null) {
                this.lockNtlmPassword = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"HttpProxy".equals(element.getNodeName())) {
            throw new ValidationException("HttpProxy: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Mode");
        if (value == null) {
            throw new ValidationException("HttpProxy/Mode: attribute is required!");
        }
        this.setModeValue(value);
        value = XMLHelper.getAttribute(element, "LockMode");
        if (value != null) {
            this.lockMode = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Host")) != null) {
            this.host = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockHost")) != null) {
            this.lockHost = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Port")) != null) {
            this.port = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockPort")) != null) {
            this.lockPort = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "HttpsPort")) != null) {
            this.httpsPort = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockHttpsPort")) != null) {
            this.lockHttpsPort = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "RequireAuthentication")) != null) {
            this.requireAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockRequireAuthentication")) != null) {
            this.lockRequireAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "UserName")) != null) {
            this.userName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockUserName")) != null) {
            this.lockUserName = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Password")) != null) {
            this.password = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockPassword")) != null) {
            this.lockPassword = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Encrypt")) != null) {
            this.setOptEncryptValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockEncrypt")) != null) {
            this.lockEncrypt = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "AuthenticationType")) != null) {
            this.setOptAuthenticationTypeValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LockAuthenticationType")) != null) {
            this.lockAuthenticationType = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmFullUserName")) != null) {
            this.ntlmFullUserName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockNtlmFullUserName")) != null) {
            this.lockNtlmFullUserName = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NtlmPassword")) != null) {
            this.ntlmPassword = value;
        }
        if ((value = XMLHelper.getAttribute(element, "LockNtlmPassword")) != null) {
            this.lockNtlmPassword = "1".equals(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("HttpProxy");
        if (this.mode != null) {
            element.setAttribute("Mode", this.getModeValue());
        }
        if (this.lockMode != null) {
            element.setAttribute("LockMode", this.lockMode != false ? "1" : "0");
        }
        if (this.host != null) {
            element.setAttribute("Host", this.host);
        }
        if (this.lockHost != null) {
            element.setAttribute("LockHost", this.lockHost != false ? "1" : "0");
        }
        if (this.port != null) {
            element.setAttribute("Port", this.port);
        }
        if (this.lockPort != null) {
            element.setAttribute("LockPort", this.lockPort != false ? "1" : "0");
        }
        if (this.httpsPort != null) {
            element.setAttribute("HttpsPort", this.httpsPort);
        }
        if (this.lockHttpsPort != null) {
            element.setAttribute("LockHttpsPort", this.lockHttpsPort != false ? "1" : "0");
        }
        if (this.requireAuthentication != null) {
            element.setAttribute("RequireAuthentication", this.requireAuthentication != false ? "1" : "0");
        }
        if (this.lockRequireAuthentication != null) {
            element.setAttribute("LockRequireAuthentication", this.lockRequireAuthentication != false ? "1" : "0");
        }
        if (this.userName != null) {
            element.setAttribute("UserName", this.userName);
        }
        if (this.lockUserName != null) {
            element.setAttribute("LockUserName", this.lockUserName != false ? "1" : "0");
        }
        if (this.password != null) {
            element.setAttribute("Password", this.password);
        }
        if (this.lockPassword != null) {
            element.setAttribute("LockPassword", this.lockPassword != false ? "1" : "0");
        }
        if (this.encrypt != null) {
            element.setAttribute("Encrypt", this.getOptEncryptValue());
        }
        if (this.lockEncrypt != null) {
            element.setAttribute("LockEncrypt", this.lockEncrypt != false ? "1" : "0");
        }
        if (this.authenticationType != null) {
            element.setAttribute("AuthenticationType", this.getOptAuthenticationTypeValue());
        }
        if (this.lockAuthenticationType != null) {
            element.setAttribute("LockAuthenticationType", this.lockAuthenticationType != false ? "1" : "0");
        }
        if (this.ntlmFullUserName != null) {
            element.setAttribute("NtlmFullUserName", this.ntlmFullUserName);
        }
        if (this.lockNtlmFullUserName != null) {
            element.setAttribute("LockNtlmFullUserName", this.lockNtlmFullUserName != false ? "1" : "0");
        }
        if (this.ntlmPassword != null) {
            element.setAttribute("NtlmPassword", this.ntlmPassword);
        }
        if (this.lockNtlmPassword != null) {
            element.setAttribute("LockNtlmPassword", this.lockNtlmPassword != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<HttpProxy ");
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getModeValue()).append("\" ");
            }
            if (this.lockMode != null) {
                strAttrs.append("LockMode=").append(this.lockMode != false ? "\"1\" " : "\"0\" ");
            }
            if (this.host != null) {
                strAttrs.append("Host=\"").append(AbstractSchema.checkXMLContent(this.host)).append("\" ");
            }
            if (this.lockHost != null) {
                strAttrs.append("LockHost=").append(this.lockHost != false ? "\"1\" " : "\"0\" ");
            }
            if (this.port != null) {
                strAttrs.append("Port=\"").append(AbstractSchema.checkXMLContent(this.port)).append("\" ");
            }
            if (this.lockPort != null) {
                strAttrs.append("LockPort=").append(this.lockPort != false ? "\"1\" " : "\"0\" ");
            }
            if (this.httpsPort != null) {
                strAttrs.append("HttpsPort=\"").append(AbstractSchema.checkXMLContent(this.httpsPort)).append("\" ");
            }
            if (this.lockHttpsPort != null) {
                strAttrs.append("LockHttpsPort=").append(this.lockHttpsPort != false ? "\"1\" " : "\"0\" ");
            }
            if (this.requireAuthentication != null) {
                strAttrs.append("RequireAuthentication=").append(this.requireAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.lockRequireAuthentication != null) {
                strAttrs.append("LockRequireAuthentication=").append(this.lockRequireAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.userName != null) {
                strAttrs.append("UserName=\"").append(AbstractSchema.checkXMLContent(this.userName)).append("\" ");
            }
            if (this.lockUserName != null) {
                strAttrs.append("LockUserName=").append(this.lockUserName != false ? "\"1\" " : "\"0\" ");
            }
            if (this.password != null) {
                strAttrs.append("Password=\"").append(AbstractSchema.checkXMLContent(this.password)).append("\" ");
            }
            if (this.lockPassword != null) {
                strAttrs.append("LockPassword=").append(this.lockPassword != false ? "\"1\" " : "\"0\" ");
            }
            if (this.encrypt != null) {
                strAttrs.append("Encrypt=\"").append(this.getOptEncryptValue()).append("\" ");
            }
            if (this.lockEncrypt != null) {
                strAttrs.append("LockEncrypt=").append(this.lockEncrypt != false ? "\"1\" " : "\"0\" ");
            }
            if (this.authenticationType != null) {
                strAttrs.append("AuthenticationType=\"").append(this.getOptAuthenticationTypeValue()).append("\" ");
            }
            if (this.lockAuthenticationType != null) {
                strAttrs.append("LockAuthenticationType=").append(this.lockAuthenticationType != false ? "\"1\" " : "\"0\" ");
            }
            if (this.ntlmFullUserName != null) {
                strAttrs.append("NtlmFullUserName=\"").append(AbstractSchema.checkXMLContent(this.ntlmFullUserName)).append("\" ");
            }
            if (this.lockNtlmFullUserName != null) {
                strAttrs.append("LockNtlmFullUserName=").append(this.lockNtlmFullUserName != false ? "\"1\" " : "\"0\" ");
            }
            if (this.ntlmPassword != null) {
                strAttrs.append("NtlmPassword=\"").append(AbstractSchema.checkXMLContent(this.ntlmPassword)).append("\" ");
            }
            if (this.lockNtlmPassword != null) {
                strAttrs.append("LockNtlmPassword=").append(this.lockNtlmPassword != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</HttpProxy>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

