/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.Data;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class File
extends AbstractSchema {
    public static final Integer XML = 0;
    public static final Integer BINARY = 1;
    private static final long serialVersionUID = 1L;
    private String name;
    private Long versionTimeStamp;
    private Integer type;

    public File() {
        this.nameSpace = "agent";
        this.children.put(328174, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "File";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.name = value;
    }

    public Long getVersionTimeStamp() {
        return this.versionTimeStamp;
    }

    public void setVersionTimeStamp(Long value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.versionTimeStamp = value;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeValue() throws ValidationException {
        if (this.type == null) {
            return null;
        }
        String s = null;
        switch (this.type) {
            case 0: {
                s = "XML";
                break;
            }
            case 1: {
                s = "BINARY";
                break;
            }
            default: {
                throw new ValidationException("File/Type: invalid attribute value:" + this.type + "!");
            }
        }
        return s;
    }

    public void setType(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.type = value;
    }

    public void setTypeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("XML".equals(value)) {
            this.type = XML;
        } else if ("BINARY".equals(value)) {
            this.type = BINARY;
        } else {
            throw new ValidationException("File/Type: invalid attribute value:" + value + "!");
        }
    }

    public Data getData() {
        ChildGroup childGroup = (ChildGroup)this.children.get(328174);
        if (childGroup.size() > 0) {
            return (Data)childGroup.get(0);
        }
        return null;
    }

    public void setData(Data value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            Data obj = this.getData();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 328173;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.name == null) {
            throw new ValidationException("File/Name: attribute is required!");
        }
        if (this.versionTimeStamp == null) {
            throw new ValidationException("File/VersionTimeStamp: attribute is required!");
        }
        if (this.type == null) {
            throw new ValidationException("File/Type: attribute is required!");
        }
        if (this.getData() == null) {
            throw new ValidationException("File/Data: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof Data) {
            try {
                this.setData((Data)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Name");
            if (value == null) {
                throw new ValidationException("File/Name: attribute is required!");
            }
            this.name = value;
            value = attris.getValue("VersionTimeStamp");
            if (value == null) {
                throw new ValidationException("File/VersionTimeStamp: attribute is required!");
            }
            try {
                this.versionTimeStamp = Long.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ValidationException("File/VersionTimeStamp: invalid attribute value:" + value + "! " + e.getMessage());
            }
            catch (Exception e) {
                throw new ValidationException("File/VersionTimeStamp: invalid attribute value:" + value + "! " + e.getMessage());
            }
            value = attris.getValue("Type");
            if (value == null) {
                throw new ValidationException("File/Type: attribute is required!");
            }
            this.setTypeValue(value);
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getData() != null) {
            this.getData().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(328174)).size();
        }
        catch (Throwable t) {
            throw new SAXException("File: can't import element == Data!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"File".equals(element.getNodeName())) {
            throw new ValidationException("File: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Name");
        if (value == null) {
            throw new ValidationException("File/Name: attribute is required!");
        }
        this.name = value;
        value = XMLHelper.getAttribute(element, "VersionTimeStamp");
        if (value == null) {
            throw new ValidationException("File/VersionTimeStamp: attribute is required!");
        }
        try {
            this.versionTimeStamp = Long.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new ValidationException("File/VersionTimeStamp: invalid attribute value:" + value + "! " + e.getMessage());
        }
        catch (Exception e) {
            throw new ValidationException("File/VersionTimeStamp: invalid attribute value:" + value + "! " + e.getMessage());
        }
        value = XMLHelper.getAttribute(element, "Type");
        if (value == null) {
            throw new ValidationException("File/Type: attribute is required!");
        }
        this.setTypeValue(value);
        ArrayList<Element> v = XMLHelper.getChildElementByName(element, "Data");
        if (v.size() != 1) {
            throw new ValidationException("File/Data: element is require!");
        }
        Data dataObj = new Data();
        dataObj.importFromElement(v.get(0));
        this.setData(dataObj);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("File");
        if (this.name != null) {
            element.setAttribute("Name", this.name);
        }
        if (this.versionTimeStamp != null) {
            element.setAttribute("VersionTimeStamp", this.versionTimeStamp.toString());
        }
        if (this.type != null) {
            element.setAttribute("Type", this.getTypeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<File ");
            if (this.name != null) {
                strAttrs.append("Name=\"").append(AbstractSchema.checkXMLContent(this.name)).append("\" ");
            }
            if (this.versionTimeStamp != null) {
                strAttrs.append("VersionTimeStamp=\"").append(this.versionTimeStamp.toString()).append("\" ");
            }
            if (this.type != null) {
                strAttrs.append("Type=\"").append(this.getTypeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</File>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

