/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Entitlement
extends AbstractSchema {
    public static final Integer ENTITLED = 0;
    public static final Integer NOT_ENTITLED = 1;
    private static final long serialVersionUID = 1L;
    private String featureName;
    private Integer state;

    public Entitlement() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "Entitlement";
    }

    public String getOptFeatureName() {
        return this.featureName;
    }

    public void setOptFeatureName(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.featureName = value;
    }

    public Integer getOptState() {
        return this.state;
    }

    public String getOptStateValue() throws ValidationException {
        if (this.state == null) {
            return null;
        }
        String s = null;
        switch (this.state) {
            case 0: {
                s = "ENTITLED";
                break;
            }
            case 1: {
                s = "NOT_ENTITLED";
                break;
            }
            default: {
                throw new ValidationException("Entitlement/State: invalid attribute value:" + this.state + "!");
            }
        }
        return s;
    }

    public void setOptState(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.state = value;
    }

    public void setOptStateValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.state = null;
            return;
        }
        if ("ENTITLED".equals(value)) {
            this.state = ENTITLED;
        } else if ("NOT_ENTITLED".equals(value)) {
            this.state = NOT_ENTITLED;
        } else {
            throw new ValidationException("Entitlement/State: invalid attribute value:" + value + "!");
        }
    }

    @Override
    public int getObjectType() {
        return 327961;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("FeatureName");
            if (value != null) {
                this.featureName = value;
            }
            if ((value = attris.getValue("State")) != null) {
                this.setOptStateValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Entitlement".equals(element.getNodeName())) {
            throw new ValidationException("Entitlement: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "FeatureName");
        if (value != null) {
            this.featureName = value;
        }
        if ((value = XMLHelper.getAttribute(element, "State")) != null) {
            this.setOptStateValue(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Entitlement");
        if (this.featureName != null) {
            element.setAttribute("FeatureName", this.featureName);
        }
        if (this.state != null) {
            element.setAttribute("State", this.getOptStateValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Entitlement ");
            if (this.featureName != null) {
                strAttrs.append("FeatureName=\"").append(AbstractSchema.checkXMLContent(this.featureName)).append("\" ");
            }
            if (this.state != null) {
                strAttrs.append("State=\"").append(this.getOptStateValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Entitlement>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

