/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DomainName
extends AbstractSchema {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private String content;

    public DomainName() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "DomainName";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("DomainName/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("DomainName/Operator: invalid attribute value:" + value + "!");
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.content = value;
    }

    @Override
    public int getObjectType() {
        return 327734;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.content == null) {
            throw new ValidationException("DomainName: content is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
        this.content = tContent;
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        Node childTextNode;
        if (!"DomainName".equals(element.getNodeName())) {
            throw new ValidationException("DomainName: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((childTextNode = XMLHelper.getTextNode(element)) == null) {
            throw new ValidationException("DomainName: content is require!");
        }
        this.content = childTextNode.getNodeValue();
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("DomainName");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.content != null) {
            Text n = doc.createTextNode(this.content);
            element.appendChild(n);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DomainName ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            StringBuffer strSimple = new StringBuffer(">");
            if (this.content != null) {
                strSimple.append(AbstractSchema.checkXMLContent(this.content));
                strSimple.append("</DomainName>");
                os_for_xml_generating.write(strSimple.toString().getBytes("UTF-8"));
                return;
            }
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DomainName>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

