/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.DomainName;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DnsServerName
extends AbstractSchema {
    public static final Integer EQUAL = 0;
    public static final Integer NOT_EQUAL = 1;
    public static final Integer MATCH_ALL_HOST_ADDR = 0;
    public static final Integer MATCH_ANY_HOST_ADDR = 1;
    private static final long serialVersionUID = 1L;
    private Integer operator;
    private Integer mode;

    public DnsServerName() {
        this.nameSpace = "agent";
        this.children.put(327734, new ChildGroup(1, 1));
    }

    @Override
    public String getObjectTypeName() {
        return "DnsServerName";
    }

    public Integer getDefOperator() {
        return EQUAL;
    }

    public Integer getOptOperator() {
        return this.operator;
    }

    public String getOptOperatorValue() throws ValidationException {
        if (this.operator == null) {
            return null;
        }
        String s = null;
        switch (this.operator) {
            case 0: {
                s = "EQUAL";
                break;
            }
            case 1: {
                s = "NOT_EQUAL";
                break;
            }
            default: {
                throw new ValidationException("DnsServerName/Operator: invalid attribute value:" + this.operator + "!");
            }
        }
        return s;
    }

    public void setOptOperator(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.operator = value;
    }

    public void setOptOperatorValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.operator = null;
            return;
        }
        if ("EQUAL".equals(value)) {
            this.operator = EQUAL;
        } else if ("NOT_EQUAL".equals(value)) {
            this.operator = NOT_EQUAL;
        } else {
            throw new ValidationException("DnsServerName/Operator: invalid attribute value:" + value + "!");
        }
    }

    public Integer getDefMode() {
        return MATCH_ALL_HOST_ADDR;
    }

    public Integer getOptMode() {
        return this.mode;
    }

    public String getOptModeValue() throws ValidationException {
        if (this.mode == null) {
            return null;
        }
        String s = null;
        switch (this.mode) {
            case 0: {
                s = "MATCH_ALL_HOST_ADDR";
                break;
            }
            case 1: {
                s = "MATCH_ANY_HOST_ADDR";
                break;
            }
            default: {
                throw new ValidationException("DnsServerName/Mode: invalid attribute value:" + this.mode + "!");
            }
        }
        return s;
    }

    public void setOptMode(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.mode = value;
    }

    public void setOptModeValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.mode = null;
            return;
        }
        if ("MATCH_ALL_HOST_ADDR".equals(value)) {
            this.mode = MATCH_ALL_HOST_ADDR;
        } else if ("MATCH_ANY_HOST_ADDR".equals(value)) {
            this.mode = MATCH_ANY_HOST_ADDR;
        } else {
            throw new ValidationException("DnsServerName/Mode: invalid attribute value:" + value + "!");
        }
    }

    public DomainName getDomainName() {
        ChildGroup childGroup = (ChildGroup)this.children.get(327734);
        if (childGroup.size() > 0) {
            return (DomainName)childGroup.get(0);
        }
        return null;
    }

    public void setDomainName(DomainName value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            DomainName obj = this.getDomainName();
            if (obj != null) {
                this.removeChild(obj);
            }
        } else {
            this.setChild(value);
        }
    }

    @Override
    public int getObjectType() {
        return 327732;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getDomainName() == null) {
            throw new ValidationException("DnsServerName/DomainName: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        if (sonObject instanceof DomainName) {
            try {
                this.setDomainName((DomainName)sonObject);
                return;
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Operator");
            if (value != null) {
                this.setOptOperatorValue(value);
            }
            if ((value = attris.getValue("Mode")) != null) {
                this.setOptModeValue(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.getDomainName() != null) {
            this.getDomainName().setReadonly();
        }
    }

    @Override
    public void checkIntegrity() throws SAXException {
        try {
            ((ChildGroup)this.children.get(327734)).size();
        }
        catch (Throwable t) {
            throw new SAXException("DnsServerName: can't import element == DomainName!");
        }
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        ArrayList<Element> v;
        if (!"DnsServerName".equals(element.getNodeName())) {
            throw new ValidationException("DnsServerName: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Operator");
        if (value != null) {
            this.setOptOperatorValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Mode")) != null) {
            this.setOptModeValue(value);
        }
        if ((v = XMLHelper.getChildElementByName(element, "DomainName")).size() != 1) {
            throw new ValidationException("DnsServerName/DomainName: element is require!");
        }
        DomainName domainNameObj = new DomainName();
        domainNameObj.importFromElement(v.get(0));
        this.setDomainName(domainNameObj);
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("DnsServerName");
        if (this.operator != null) {
            element.setAttribute("Operator", this.getOptOperatorValue());
        }
        if (this.mode != null) {
            element.setAttribute("Mode", this.getOptModeValue());
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DnsServerName ");
            if (this.operator != null) {
                strAttrs.append("Operator=\"").append(this.getOptOperatorValue()).append("\" ");
            }
            if (this.mode != null) {
                strAttrs.append("Mode=\"").append(this.getOptModeValue()).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DnsServerName>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

