/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeviceAction
extends AbstractSchema {
    public static final Integer ALLOW = 0;
    public static final Integer BLOCK = 1;
    private static final long serialVersionUID = 1L;
    private Integer action;
    private Boolean logEvent;
    private Boolean notificationEnable;
    private String notificationAdditionalText;

    public DeviceAction() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "DeviceAction";
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "ALLOW";
                break;
            }
            case 1: {
                s = "BLOCK";
                break;
            }
            default: {
                throw new ValidationException("DeviceAction/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ALLOW".equals(value)) {
            this.action = ALLOW;
        } else if ("BLOCK".equals(value)) {
            this.action = BLOCK;
        } else {
            throw new ValidationException("DeviceAction/Action: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefLogEvent() {
        return Boolean.FALSE;
    }

    public Boolean getOptLogEvent() {
        return this.logEvent;
    }

    public void setOptLogEvent(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.logEvent = value;
    }

    public Boolean getDefNotificationEnable() {
        return Boolean.FALSE;
    }

    public Boolean getOptNotificationEnable() {
        return this.notificationEnable;
    }

    public void setOptNotificationEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.notificationEnable = value;
    }

    public String getOptNotificationAdditionalText() {
        return this.notificationAdditionalText;
    }

    public void setOptNotificationAdditionalText(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.notificationAdditionalText = value;
    }

    @Override
    public int getObjectType() {
        return 328145;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("DeviceAction/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Action");
            if (value == null) {
                throw new ValidationException("DeviceAction/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("LogEvent");
            if (value != null) {
                this.logEvent = "1".equals(value);
            }
            if ((value = attris.getValue("NotificationEnable")) != null) {
                this.notificationEnable = "1".equals(value);
            }
            if ((value = attris.getValue("NotificationAdditionalText")) != null) {
                this.notificationAdditionalText = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"DeviceAction".equals(element.getNodeName())) {
            throw new ValidationException("DeviceAction: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Action");
        if (value == null) {
            throw new ValidationException("DeviceAction/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "LogEvent");
        if (value != null) {
            this.logEvent = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NotificationEnable")) != null) {
            this.notificationEnable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "NotificationAdditionalText")) != null) {
            this.notificationAdditionalText = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("DeviceAction");
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.logEvent != null) {
            element.setAttribute("LogEvent", this.logEvent != false ? "1" : "0");
        }
        if (this.notificationEnable != null) {
            element.setAttribute("NotificationEnable", this.notificationEnable != false ? "1" : "0");
        }
        if (this.notificationAdditionalText != null) {
            element.setAttribute("NotificationAdditionalText", this.notificationAdditionalText);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<DeviceAction ");
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.logEvent != null) {
                strAttrs.append("LogEvent=").append(this.logEvent != false ? "\"1\" " : "\"0\" ");
            }
            if (this.notificationEnable != null) {
                strAttrs.append("NotificationEnable=").append(this.notificationEnable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.notificationAdditionalText != null) {
                strAttrs.append("NotificationAdditionalText=\"").append(AbstractSchema.checkXMLContent(this.notificationAdditionalText)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</DeviceAction>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

