/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AppAuthenticationProtection
extends AbstractSchema {
    public static final Integer ALLOW = 0;
    public static final Integer ASK = 1;
    public static final Integer DISALLOW = 2;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean enableDllAuthentication;
    private Integer action;
    private String additionalText;

    public AppAuthenticationProtection() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "AppAuthenticationProtection";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public Boolean getDefEnableDllAuthentication() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableDllAuthentication() {
        return this.enableDllAuthentication;
    }

    public void setOptEnableDllAuthentication(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enableDllAuthentication = value;
    }

    public Integer getAction() {
        return this.action;
    }

    public String getActionValue() throws ValidationException {
        if (this.action == null) {
            return null;
        }
        String s = null;
        switch (this.action) {
            case 0: {
                s = "ALLOW";
                break;
            }
            case 1: {
                s = "ASK";
                break;
            }
            case 2: {
                s = "DISALLOW";
                break;
            }
            default: {
                throw new ValidationException("AppAuthenticationProtection/Action: invalid attribute value:" + this.action + "!");
            }
        }
        return s;
    }

    public void setAction(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.action = value;
    }

    public void setActionValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if ("ALLOW".equals(value)) {
            this.action = ALLOW;
        } else if ("ASK".equals(value)) {
            this.action = ASK;
        } else if ("DISALLOW".equals(value)) {
            this.action = DISALLOW;
        } else {
            throw new ValidationException("AppAuthenticationProtection/Action: invalid attribute value:" + value + "!");
        }
    }

    public String getOptAdditionalText() {
        return this.additionalText;
    }

    public void setOptAdditionalText(String value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.additionalText = value;
    }

    @Override
    public int getObjectType() {
        return 328021;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.action == null) {
            throw new ValidationException("AppAuthenticationProtection/Action: attribute is required!");
        }
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("EnableDllAuthentication")) != null) {
                this.enableDllAuthentication = "1".equals(value);
            }
            if ((value = attris.getValue("Action")) == null) {
                throw new ValidationException("AppAuthenticationProtection/Action: attribute is required!");
            }
            this.setActionValue(value);
            value = attris.getValue("AdditionalText");
            if (value != null) {
                this.additionalText = value;
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"AppAuthenticationProtection".equals(element.getNodeName())) {
            throw new ValidationException("AppAuthenticationProtection: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableDllAuthentication")) != null) {
            this.enableDllAuthentication = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Action")) == null) {
            throw new ValidationException("AppAuthenticationProtection/Action: attribute is required!");
        }
        this.setActionValue(value);
        value = XMLHelper.getAttribute(element, "AdditionalText");
        if (value != null) {
            this.additionalText = value;
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("AppAuthenticationProtection");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.enableDllAuthentication != null) {
            element.setAttribute("EnableDllAuthentication", this.enableDllAuthentication != false ? "1" : "0");
        }
        if (this.action != null) {
            element.setAttribute("Action", this.getActionValue());
        }
        if (this.additionalText != null) {
            element.setAttribute("AdditionalText", this.additionalText);
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<AppAuthenticationProtection ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableDllAuthentication != null) {
                strAttrs.append("EnableDllAuthentication=").append(this.enableDllAuthentication != false ? "\"1\" " : "\"0\" ");
            }
            if (this.action != null) {
                strAttrs.append("Action=\"").append(this.getActionValue()).append("\" ");
            }
            if (this.additionalText != null) {
                strAttrs.append("AdditionalText=\"").append(AbstractSchema.checkXMLContent(this.additionalText)).append("\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</AppAuthenticationProtection>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

